/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.launching.AbstractOprofileLaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;

public class OprofileLaunchConfigurationDelegate
extends AbstractOprofileLaunchConfigurationDelegate {
    @Override
    protected boolean preExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents, ILaunch launch) {
        IProject project = this.getProject();
        Oprofile.OprofileProject.setProject((IProject)project);
        if (!this.oprofileStatus()) {
            OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", null);
            return false;
        }
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationWatcher(launch, options.getExecutionsNumber()));
        return true;
    }

    @Override
    protected void postExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents, Process process) {
    }

    class LaunchTerminationWatcher
    implements ILaunchesListener2 {
        private ILaunch launch;
        private int executions;

        public LaunchTerminationWatcher(ILaunch il, int executions) {
            this.launch = il;
            this.executions = executions;
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch l = iLaunchArray[n2];
                if (l.equals(this.launch) && l.getProcesses().length == this.executions && !Oprofile.OprofileProject.getProfilingBinary().equals("ocount")) {
                    Display.getDefault().syncExec(() -> OprofileLaunchConfigurationDelegate.this.refreshOprofileView());
                }
                ++n2;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

