/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.aspects.factory.internal;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jwt.we.conf.model.Aspect;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.aspects.factory.AspectFactory;
import org.eclipse.jwt.we.conf.model.plugin.internal.Logger;

public class AspectFactoryImpl
implements AspectFactory {
    private static Logger logger = Logger.getLogger(AspectFactoryImpl.class);

    protected AspectFactoryImpl() {
    }

    public static AspectFactory createAspectFactory() {
        return new AspectFactoryImpl();
    }

    public AspectInstance createAspectInstance(Aspect aspect, EObject modelElement) {
        EClassifier aspectInstanceETypeEClassifier = aspect.getAspectInstanceEType();
        if (aspectInstanceETypeEClassifier == null) {
            logger.severe("Creating aspect : no aspectInstanceEType " + aspectInstanceETypeEClassifier + " of aspect " + aspect.getId());
            return null;
        }
        if (aspectInstanceETypeEClassifier.eIsProxy()) {
            logger.severe("Creating aspect : can't find EMF definition of aspectInstanceEType " + aspectInstanceETypeEClassifier + " of aspect " + aspect.getId());
            return null;
        }
        AspectFactory aspectFactory = AspectFactory.Registry.INSTANCE.getFactory(aspect);
        AspectInstance newAspectInstance = aspectFactory.createAspectInstance(aspect, modelElement);
        newAspectInstance.setId(aspect.getId());
        newAspectInstance.setTargetModelElement(modelElement);
        return newAspectInstance;
    }
}

