/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.FacesConfigPlugin;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.MethodBindingType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.osgi.framework.Bundle;

public class ActionType
extends MethodBindingType
implements IPossibleValues {
    protected static final ImageDescriptor MISSING_IMAGE = ImageDescriptor.getMissingImageDescriptor();
    private static final String IMAGE_NAME = "/icons/full/obj16/NavigationCaseType.gif";
    private ImageDescriptor imageDescriptor;

    public boolean isValidValue(String value) {
        if (value == null || value != null && value.length() == 0) {
            ValidationMessage msg = new ValidationMessage(Messages.ActionType_invalid_empty_value);
            this.getValidationMessages().add(msg);
            return false;
        }
        IFile jsp = this.getFile2();
        if (jsp == null) {
            return true;
        }
        if (JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(jsp.getProject()) == null) {
            return true;
        }
        List<NavigationRuleType> rules = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(jsp.getProject()).getNavigationRulesForPage(jsp);
        for (NavigationRuleType rule : rules) {
            for (NavigationCaseType navCase : rule.getNavigationCase()) {
                if (navCase.getFromOutcome() == null || navCase.getFromOutcome().getTextContent() == null || !value.equals(navCase.getFromOutcome().getTextContent().trim())) continue;
                return true;
            }
        }
        if (JSFVersion.valueOfProject(jsp.getProject()).compareTo(JSFVersion.V2_0) >= 0) {
            int index = value.indexOf(63);
            if (index != -1) {
                value = value.substring(0, index);
            }
            if (value != null && value.length() > 1) {
                IVirtualFolder webRoot = ComponentCore.createComponent((IProject)jsp.getProject()).getRootFolder();
                if (value.charAt(0) == '/') {
                    IVirtualFile file = webRoot.getFile((IPath)new Path(value));
                    if (file.exists()) {
                        return true;
                    }
                } else {
                    IPath webContentPath = webRoot.getUnderlyingFolder().getFullPath();
                    IPath filePath = jsp.getFullPath();
                    if (filePath.matchingFirstSegments(webContentPath) == webContentPath.segmentCount()) {
                        IVirtualFile file;
                        String extension = filePath.getFileExtension();
                        filePath = filePath.removeFirstSegments(webContentPath.segmentCount());
                        filePath = filePath.removeLastSegments(1);
                        if ((filePath = filePath.append(value)).getFileExtension() == null && extension != null) {
                            filePath = filePath.addFileExtension(extension);
                        }
                        if ((file = webRoot.getFile(filePath)).exists()) {
                            return true;
                        }
                    }
                }
            }
        }
        ValidationMessage msg = new ValidationMessage(Messages.ActionType_invalid_value);
        this.getValidationMessages().add(msg);
        return false;
    }

    public List getPossibleValues() {
        ArrayList ret = new ArrayList();
        IProject project = this.getProject2();
        IFile file = this.getFile2();
        if (this.getModelContext() == null || file == null || project == null) {
            return ret;
        }
        if (JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(project) != null) {
            IFile jsp = file;
            List<NavigationRuleType> rules = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(project).getNavigationRulesForPage(jsp);
            for (NavigationRuleType rule : rules) {
                if (rule == null) continue;
                ret.addAll(this.createProposals(rule));
            }
            ret.addAll(this.createImplicitProposals(jsp));
        }
        return ret;
    }

    private List createProposals(NavigationRuleType rule) {
        ArrayList<PossibleValue> ret = new ArrayList<PossibleValue>();
        EList cases = rule.getNavigationCase();
        for (NavigationCaseType navCase : cases) {
            PossibleValue pv = this.createProposal(rule, navCase);
            if (pv == null) continue;
            ret.add(pv);
        }
        return ret;
    }

    private PossibleValue createProposal(NavigationRuleType rule, NavigationCaseType navCase) {
        PossibleValue pv = null;
        String value = null;
        String ruleDisp = null;
        String navDisplay = null;
        String navAction = null;
        String toViewId = null;
        if (navCase.getFromOutcome() != null) {
            value = navCase.getFromOutcome().getTextContent();
        }
        if (navCase.getToViewId() != null) {
            toViewId = navCase.getToViewId().getTextContent();
        }
        if (rule.getFromViewId() != null) {
            ruleDisp = rule.getFromViewId().getTextContent();
        }
        if (navCase.getDisplayName() != null && navCase.getDisplayName().size() > 0) {
            navDisplay = ((DisplayNameType)navCase.getDisplayName().get(0)).getTextContent();
        }
        if (navCase.getFromAction() != null) {
            navAction = navCase.getFromAction().getTextContent();
        }
        if (navDisplay == null || navDisplay.trim().equals("")) {
            navDisplay = NLS.bind((String)Messages.ActionType_navcase_display, (Object[])new String[]{value, toViewId});
        }
        if (value != null) {
            pv = new PossibleValue(value, navDisplay);
            pv.setIcon(this.getNavCaseImageDescriptor());
            pv.setAdditionalInformation("from-outcome: " + value + "<br>to-view-id: " + toViewId + "<br>from-view-id: " + ruleDisp + "<br>from-action: " + (navAction == null ? "null" : navAction));
        }
        return pv;
    }

    private List createImplicitProposals(IFile fromFile) {
        IPath fromPath;
        IPath webContentPath;
        IVirtualFolder folder;
        IVirtualComponent component;
        IProject project;
        ArrayList<PossibleValue> ret = new ArrayList<PossibleValue>();
        if (fromFile != null && (project = fromFile.getProject()) != null && (component = ComponentCore.createComponent((IProject)project)) != null && (folder = component.getRootFolder()) != null && (webContentPath = folder.getUnderlyingFolder().getFullPath()).isPrefixOf(fromPath = fromFile.getFullPath())) {
            fromPath = fromPath.makeRelativeTo(webContentPath);
            IPath fromPathParent = fromPath.removeLastSegments(1);
            List<IFile> files = JSFAppConfigUtils.getImplicitNavigationFiles(fromFile);
            for (IFile currentFile : files) {
                IPath currentPath = currentFile.getFullPath();
                if (!webContentPath.isPrefixOf(currentPath)) continue;
                currentPath = currentPath.makeRelativeTo(webContentPath);
                String toViewId = String.valueOf('/') + currentPath.toString();
                boolean isRelative = false;
                if (fromPathParent.isPrefixOf(currentPath)) {
                    currentPath = currentPath.makeRelativeTo(fromPathParent);
                    isRelative = true;
                }
                String value = currentPath.toString();
                String fromPathExt = fromPath.getFileExtension();
                if (fromPathExt != null && fromPathExt.equals(currentPath.getFileExtension())) {
                    value = currentPath.removeFileExtension().toString();
                }
                if (!isRelative) {
                    value = String.valueOf('/') + value;
                }
                String navDisplay = NLS.bind((String)Messages.ActionType_navcase_display, (Object[])new String[]{value, toViewId});
                PossibleValue possibleValue = new PossibleValue(value, navDisplay);
                possibleValue.setIcon(this.getNavCaseImageDescriptor());
                possibleValue.setAdditionalInformation(NLS.bind((String)Messages.ActionType_implicit_navigation_additional_info, (Object)toViewId));
                ret.add(possibleValue);
            }
        }
        return ret;
    }

    private ImageDescriptor getNavCaseImageDescriptor() {
        ImageDescriptor ret = super.getImage();
        if (ret != null && ret != MISSING_IMAGE) {
            return ret;
        }
        if (this.imageDescriptor == null) {
            this.imageDescriptor = this.getImageDesc(IMAGE_NAME);
        }
        return this.imageDescriptor;
    }

    private ImageDescriptor getImageDesc(String img) {
        Bundle bundle = FacesConfigPlugin.getPlugin().getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(img), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        if (desc == MISSING_IMAGE) {
            return null;
        }
        return desc;
    }
}

