/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.examples.common.util.Util;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class AddAllClassesCommand
extends RecordingCommand {
    private IProject project;
    private TransactionalEditingDomain editingDomain;
    private String diagramName;
    private Resource createdResource;

    public AddAllClassesCommand(IProject project, TransactionalEditingDomain editingDomain, String diagramName) {
        super(editingDomain);
        this.project = project;
        this.editingDomain = editingDomain;
        this.diagramName = diagramName;
    }

    protected void doExecute() {
        EClass[] allClasses = Util.getAllClasses((IProject)this.project, (ResourceSet)this.editingDomain.getResourceSet());
        Diagram diagram = Graphiti.getPeCreateService().createDiagram("tutorial", this.diagramName, true);
        IFolder diagramFolder = this.project.getFolder("src/diagrams/");
        IFile diagramFile = diagramFolder.getFile(String.valueOf(this.diagramName) + ".diagram");
        URI uri = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        this.createdResource = this.editingDomain.getResourceSet().createResource(uri);
        this.createdResource.getContents().add((Object)diagram);
        IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(diagram, "org.eclipse.graphiti.examples.tutorial.diagram.TutorialDiagramTypeProvider");
        IFeatureProvider featureProvider = dtp.getFeatureProvider();
        int x = 20;
        int y = 20;
        int i = 0;
        while (i < allClasses.length) {
            AddContext addContext = new AddContext();
            addContext.setNewObject((Object)allClasses[i]);
            addContext.setTargetContainer((ContainerShape)diagram);
            addContext.setX(x);
            addContext.setY(y);
            x += 20;
            y += 20;
            IAddFeature addFeature = featureProvider.getAddFeature((IAddContext)addContext);
            if (addFeature.canAdd((IAddContext)addContext)) {
                addFeature.add((IAddContext)addContext);
            }
            ++i;
        }
    }

    public Resource getCreatedResource() {
        return this.createdResource;
    }
}

