/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.language.style.StylePackage;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotStyleJavaValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class DotStyleJavaValidator
extends AbstractDotStyleJavaValidator {
    @Check
    public void checkStyleItemConformsToContext(StyleItem styleItem) {
        if (styleItem.getName().equals("setlinewidth")) {
            return;
        }
        DotAttributes.Context attributeContext = this.getAttributeContext();
        if (DotAttributes.Context.NODE.equals((Object)attributeContext)) {
            NodeStyle[] nodeStyleArray = NodeStyle.values();
            int n = nodeStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeStyle validValue = nodeStyleArray[n2];
                if (((Object)((Object)validValue)).toString().equals(styleItem.getName())) {
                    return;
                }
                ++n2;
            }
            this.reportRangeBaseError("Value should be one of " + this.getFormattedValues((Object[])NodeStyle.values()) + ".", styleItem, (EStructuralFeature)StylePackage.Literals.STYLE_ITEM__NAME, attributeContext);
        } else if (DotAttributes.Context.EDGE.equals((Object)attributeContext)) {
            EdgeStyle[] edgeStyleArray = EdgeStyle.values();
            int n = edgeStyleArray.length;
            int n3 = 0;
            while (n3 < n) {
                EdgeStyle validValue = edgeStyleArray[n3];
                if (((Object)((Object)validValue)).toString().equals(styleItem.getName())) {
                    return;
                }
                ++n3;
            }
            this.reportRangeBaseError("Value should be one of " + this.getFormattedValues((Object[])EdgeStyle.values()) + ".", styleItem, (EStructuralFeature)StylePackage.Literals.STYLE_ITEM__NAME, attributeContext);
        }
    }

    @Check
    public void checkDeprecatedStyleItem(StyleItem styleItem) {
        if (styleItem.getName().equals("setlinewidth")) {
            this.reportRangeBasedWarning("The usage of setlinewidth is deprecated, use the penwidth attribute instead.", styleItem, (EStructuralFeature)StylePackage.Literals.STYLE_ITEM__NAME);
        }
    }

    private void reportRangeBasedWarning(String message, StyleItem styleItem, EStructuralFeature feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)styleItem, (EStructuralFeature)feature);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        String[] issueData = new String[]{styleItem.getName()};
        this.getMessageAcceptor().acceptWarning(message, (EObject)styleItem, offset, length, code, issueData);
    }

    private void reportRangeBaseError(String message, StyleItem styleItem, EStructuralFeature feature, DotAttributes.Context attributeContext) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)styleItem, (EStructuralFeature)feature);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        String[] issueData = new String[]{styleItem.getName(), attributeContext.toString()};
        this.getMessageAcceptor().acceptError(message, (EObject)styleItem, offset, length, code, issueData);
    }

    private DotAttributes.Context getAttributeContext() {
        DotAttributes.Context attributeContext = (DotAttributes.Context)((Object)this.getContext().get(DotAttributes.Context.class.getName()));
        return attributeContext;
    }

    private String getFormattedValues(Object[] values) {
        StringBuilder sb = new StringBuilder();
        for (Object value : new TreeSet<Object>(Arrays.asList(values))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'" + value + "'");
        }
        return sb.toString();
    }
}

