/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.epp.logging.aeri.core.IModelFactory
 * @model kind="package"
 * @generated
 */
public interface IModelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "core";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "https://www.eclipse.org/epp/logging/aeri/core/2.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "aeri";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	IModelPackage eINSTANCE = org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl <em>Report</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.ReportImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getReport()
	 * @generated
	 */
	int REPORT = 0;

	/**
	 * The feature id for the '<em><b>Anonymous Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__ANONYMOUS_ID = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__NAME = 1;

	/**
	 * The feature id for the '<em><b>Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__EMAIL = 2;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__COMMENT = 3;

	/**
	 * The feature id for the '<em><b>Eclipse Build Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__ECLIPSE_BUILD_ID = 4;

	/**
	 * The feature id for the '<em><b>Eclipse Product</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__ECLIPSE_PRODUCT = 5;

	/**
	 * The feature id for the '<em><b>Java Runtime Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__JAVA_RUNTIME_VERSION = 6;

	/**
	 * The feature id for the '<em><b>Osgi Ws</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__OSGI_WS = 7;

	/**
	 * The feature id for the '<em><b>Osgi Os</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__OSGI_OS = 8;

	/**
	 * The feature id for the '<em><b>Osgi Os Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__OSGI_OS_VERSION = 9;

	/**
	 * The feature id for the '<em><b>Osgi Arch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__OSGI_ARCH = 10;

	/**
	 * The feature id for the '<em><b>Present Bundles</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__PRESENT_BUNDLES = 11;

	/**
	 * The feature id for the '<em><b>Status</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__STATUS = 12;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__SEVERITY = 13;

	/**
	 * The feature id for the '<em><b>Auxiliary Information</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT__AUXILIARY_INFORMATION = 14;

	/**
	 * The number of structural features of the '<em>Report</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT_FEATURE_COUNT = 15;

	/**
	 * The number of operations of the '<em>Report</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPORT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.BundleImpl <em>Bundle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.BundleImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getBundle()
	 * @generated
	 */
	int BUNDLE = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUNDLE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUNDLE__VERSION = 1;

	/**
	 * The number of structural features of the '<em>Bundle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUNDLE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Bundle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUNDLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.StatusImpl <em>Status</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.StatusImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStatus()
	 * @generated
	 */
	int STATUS = 2;

	/**
	 * The feature id for the '<em><b>Plugin Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__PLUGIN_ID = 0;

	/**
	 * The feature id for the '<em><b>Plugin Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__PLUGIN_VERSION = 1;

	/**
	 * The feature id for the '<em><b>Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__CODE = 2;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__SEVERITY = 3;

	/**
	 * The feature id for the '<em><b>Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__MESSAGE = 4;

	/**
	 * The feature id for the '<em><b>Fingerprint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__FINGERPRINT = 5;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__CHILDREN = 6;

	/**
	 * The feature id for the '<em><b>Exception</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__EXCEPTION = 7;

	/**
	 * The number of structural features of the '<em>Status</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Status</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.ThrowableImpl <em>Throwable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.ThrowableImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getThrowable()
	 * @generated
	 */
	int THROWABLE = 3;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROWABLE__CLASS_NAME = 0;

	/**
	 * The feature id for the '<em><b>Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROWABLE__MESSAGE = 1;

	/**
	 * The feature id for the '<em><b>Cause</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROWABLE__CAUSE = 2;

	/**
	 * The feature id for the '<em><b>Stack Trace</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROWABLE__STACK_TRACE = 3;

	/**
	 * The number of structural features of the '<em>Throwable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROWABLE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Throwable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROWABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.StackTraceElementImpl <em>Stack Trace Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.StackTraceElementImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStackTraceElement()
	 * @generated
	 */
	int STACK_TRACE_ELEMENT = 4;

	/**
	 * The feature id for the '<em><b>File Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STACK_TRACE_ELEMENT__FILE_NAME = 0;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STACK_TRACE_ELEMENT__CLASS_NAME = 1;

	/**
	 * The feature id for the '<em><b>Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STACK_TRACE_ELEMENT__METHOD_NAME = 2;

	/**
	 * The feature id for the '<em><b>Line Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STACK_TRACE_ELEMENT__LINE_NUMBER = 3;

	/**
	 * The feature id for the '<em><b>Native</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STACK_TRACE_ELEMENT__NATIVE = 4;

	/**
	 * The number of structural features of the '<em>Stack Trace Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STACK_TRACE_ELEMENT_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Stack Trace Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STACK_TRACE_ELEMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl <em>User Settings</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getUserSettings()
	 * @generated
	 */
	int USER_SETTINGS = 5;

	/**
	 * The feature id for the '<em><b>Reporter Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS__REPORTER_ID = 0;

	/**
	 * The feature id for the '<em><b>Reporter Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS__REPORTER_NAME = 1;

	/**
	 * The feature id for the '<em><b>Reporter Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS__REPORTER_EMAIL = 2;

	/**
	 * The feature id for the '<em><b>Anonymize Messages</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS__ANONYMIZE_MESSAGES = 3;

	/**
	 * The feature id for the '<em><b>Anonymize Stack Traces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS__ANONYMIZE_STACK_TRACES = 4;

	/**
	 * The feature id for the '<em><b>Disable Automatic Wiring Analysis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS = 5;

	/**
	 * The number of structural features of the '<em>User Settings</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>User Settings</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SETTINGS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl <em>System Settings</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSystemSettings()
	 * @generated
	 */
	int SYSTEM_SETTINGS = 6;

	/**
	 * The feature id for the '<em><b>Reporter Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__REPORTER_ID = USER_SETTINGS__REPORTER_ID;

	/**
	 * The feature id for the '<em><b>Reporter Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__REPORTER_NAME = USER_SETTINGS__REPORTER_NAME;

	/**
	 * The feature id for the '<em><b>Reporter Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__REPORTER_EMAIL = USER_SETTINGS__REPORTER_EMAIL;

	/**
	 * The feature id for the '<em><b>Anonymize Messages</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__ANONYMIZE_MESSAGES = USER_SETTINGS__ANONYMIZE_MESSAGES;

	/**
	 * The feature id for the '<em><b>Anonymize Stack Traces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__ANONYMIZE_STACK_TRACES = USER_SETTINGS__ANONYMIZE_STACK_TRACES;

	/**
	 * The feature id for the '<em><b>Disable Automatic Wiring Analysis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS = USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS;

	/**
	 * The feature id for the '<em><b>Send Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__SEND_MODE = USER_SETTINGS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Reset Send Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__RESET_SEND_MODE = USER_SETTINGS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reset Send Mode On</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__RESET_SEND_MODE_ON = USER_SETTINGS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Configured</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__CONFIGURED = USER_SETTINGS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Debug Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__DEBUG_ENABLED = USER_SETTINGS_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Anonymous Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS__ANONYMOUS_ID = USER_SETTINGS_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>System Settings</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS_FEATURE_COUNT = USER_SETTINGS_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>System Settings</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_SETTINGS_OPERATION_COUNT = USER_SETTINGS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.LinkImpl <em>Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.LinkImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getLink()
	 * @generated
	 */
	int LINK = 7;

	/**
	 * The feature id for the '<em><b>Rel</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK__REL = 0;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK__HREF = 1;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK__TITLE = 2;

	/**
	 * The number of structural features of the '<em>Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.LinkableImpl <em>Linkable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.LinkableImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getLinkable()
	 * @generated
	 */
	int LINKABLE = 11;

	/**
	 * The feature id for the '<em><b>Links</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKABLE__LINKS = 0;

	/**
	 * The number of structural features of the '<em>Linkable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKABLE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Linkable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.ProblemStateImpl <em>Problem State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.ProblemStateImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getProblemState()
	 * @generated
	 */
	int PROBLEM_STATE = 8;

	/**
	 * The feature id for the '<em><b>Links</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBLEM_STATE__LINKS = LINKABLE__LINKS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBLEM_STATE__STATUS = LINKABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBLEM_STATE__MESSAGE = LINKABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Needinfo</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBLEM_STATE__NEEDINFO = LINKABLE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Problem State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBLEM_STATE_FEATURE_COUNT = LINKABLE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Problem State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBLEM_STATE_OPERATION_COUNT = LINKABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.SendOptionsImpl <em>Send Options</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.SendOptionsImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSendOptions()
	 * @generated
	 */
	int SEND_OPTIONS = 9;

	/**
	 * The feature id for the '<em><b>Reporter Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__REPORTER_ID = USER_SETTINGS__REPORTER_ID;

	/**
	 * The feature id for the '<em><b>Reporter Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__REPORTER_NAME = USER_SETTINGS__REPORTER_NAME;

	/**
	 * The feature id for the '<em><b>Reporter Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__REPORTER_EMAIL = USER_SETTINGS__REPORTER_EMAIL;

	/**
	 * The feature id for the '<em><b>Anonymize Messages</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__ANONYMIZE_MESSAGES = USER_SETTINGS__ANONYMIZE_MESSAGES;

	/**
	 * The feature id for the '<em><b>Anonymize Stack Traces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__ANONYMIZE_STACK_TRACES = USER_SETTINGS__ANONYMIZE_STACK_TRACES;

	/**
	 * The feature id for the '<em><b>Disable Automatic Wiring Analysis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__DISABLE_AUTOMATIC_WIRING_ANALYSIS = USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__COMMENT = USER_SETTINGS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__SEVERITY = USER_SETTINGS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Enabled Processors</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS__ENABLED_PROCESSORS = USER_SETTINGS_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Send Options</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS_FEATURE_COUNT = USER_SETTINGS_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Send Options</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_OPTIONS_OPERATION_COUNT = USER_SETTINGS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.StringToLinkMapImpl <em>String To Link Map</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.StringToLinkMapImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStringToLinkMap()
	 * @generated
	 */
	int STRING_TO_LINK_MAP = 10;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_LINK_MAP__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_LINK_MAP__VALUE = 1;

	/**
	 * The number of structural features of the '<em>String To Link Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_LINK_MAP_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>String To Link Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_LINK_MAP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.impl.StringToStringMapImpl <em>String To String Map</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.impl.StringToStringMapImpl
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStringToStringMap()
	 * @generated
	 */
	int STRING_TO_STRING_MAP = 12;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP__VALUE = 1;

	/**
	 * The number of structural features of the '<em>String To String Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>String To String Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.SendMode <em>Send Mode</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.SendMode
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSendMode()
	 * @generated
	 */
	int SEND_MODE = 13;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.ResetSendMode <em>Reset Send Mode</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.ResetSendMode
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getResetSendMode()
	 * @generated
	 */
	int RESET_SEND_MODE = 14;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.Severity <em>Severity</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.Severity
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSeverity()
	 * @generated
	 */
	int SEVERITY = 15;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.logging.aeri.core.ProblemStatus <em>Problem Status</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.ProblemStatus
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getProblemStatus()
	 * @generated
	 */
	int PROBLEM_STATUS = 16;

	/**
	 * The meta object id for the '<em>IProgress Monitor</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.core.runtime.IProgressMonitor
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIProgressMonitor()
	 * @generated
	 */
	int IPROGRESS_MONITOR = 17;

	/**
	 * The meta object id for the '<em>Exception</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Exception
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getException()
	 * @generated
	 */
	int EXCEPTION = 18;

	/**
	 * The meta object id for the '<em>IEclipse Context</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.e4.core.contexts.IEclipseContext
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIEclipseContext()
	 * @generated
	 */
	int IECLIPSE_CONTEXT = 19;

	/**
	 * The meta object id for the '<em>IServer Connection</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.IServerConnection
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIServerConnection()
	 * @generated
	 */
	int ISERVER_CONNECTION = 20;

	/**
	 * The meta object id for the '<em>IReport Processor</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.logging.aeri.core.IReportProcessor
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIReportProcessor()
	 * @generated
	 */
	int IREPORT_PROCESSOR = 21;

	/**
	 * The meta object id for the '<em>IStatus</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.core.runtime.IStatus
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIStatus()
	 * @generated
	 */
	int ISTATUS = 22;

	/**
	 * The meta object id for the '<em>IConfiguration Element</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.core.runtime.IConfigurationElement
	 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIConfigurationElement()
	 * @generated
	 */
	int ICONFIGURATION_ELEMENT = 23;


	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.IReport <em>Report</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Report</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport
	 * @generated
	 */
	EClass getReport();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getAnonymousId <em>Anonymous Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Anonymous Id</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getAnonymousId()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_AnonymousId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getName()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getEmail <em>Email</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Email</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getEmail()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_Email();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getComment()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_Comment();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getEclipseBuildId <em>Eclipse Build Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Eclipse Build Id</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getEclipseBuildId()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_EclipseBuildId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getEclipseProduct <em>Eclipse Product</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Eclipse Product</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getEclipseProduct()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_EclipseProduct();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getJavaRuntimeVersion <em>Java Runtime Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Java Runtime Version</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getJavaRuntimeVersion()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_JavaRuntimeVersion();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiWs <em>Osgi Ws</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Osgi Ws</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getOsgiWs()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_OsgiWs();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiOs <em>Osgi Os</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Osgi Os</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getOsgiOs()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_OsgiOs();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiOsVersion <em>Osgi Os Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Osgi Os Version</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getOsgiOsVersion()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_OsgiOsVersion();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getOsgiArch <em>Osgi Arch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Osgi Arch</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getOsgiArch()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_OsgiArch();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.epp.logging.aeri.core.IReport#getPresentBundles <em>Present Bundles</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Present Bundles</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getPresentBundles()
	 * @see #getReport()
	 * @generated
	 */
	EReference getReport_PresentBundles();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.epp.logging.aeri.core.IReport#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Status</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getStatus()
	 * @see #getReport()
	 * @generated
	 */
	EReference getReport_Status();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IReport#getSeverity <em>Severity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Severity</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getSeverity()
	 * @see #getReport()
	 * @generated
	 */
	EAttribute getReport_Severity();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.epp.logging.aeri.core.IReport#getAuxiliaryInformation <em>Auxiliary Information</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Auxiliary Information</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReport#getAuxiliaryInformation()
	 * @see #getReport()
	 * @generated
	 */
	EReference getReport_AuxiliaryInformation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.IBundle <em>Bundle</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bundle</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IBundle
	 * @generated
	 */
	EClass getBundle();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IBundle#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IBundle#getName()
	 * @see #getBundle()
	 * @generated
	 */
	EAttribute getBundle_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IBundle#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IBundle#getVersion()
	 * @see #getBundle()
	 * @generated
	 */
	EAttribute getBundle_Version();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.IStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Status</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus
	 * @generated
	 */
	EClass getStatus();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStatus#getPluginId <em>Plugin Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Plugin Id</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getPluginId()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_PluginId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStatus#getPluginVersion <em>Plugin Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Plugin Version</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getPluginVersion()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_PluginVersion();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStatus#getCode <em>Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Code</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getCode()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_Code();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStatus#getSeverity <em>Severity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Severity</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getSeverity()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_Severity();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStatus#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Message</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getMessage()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_Message();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStatus#getFingerprint <em>Fingerprint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fingerprint</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getFingerprint()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_Fingerprint();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.epp.logging.aeri.core.IStatus#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getChildren()
	 * @see #getStatus()
	 * @generated
	 */
	EReference getStatus_Children();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.epp.logging.aeri.core.IStatus#getException <em>Exception</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Exception</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStatus#getException()
	 * @see #getStatus()
	 * @generated
	 */
	EReference getStatus_Exception();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.IThrowable <em>Throwable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Throwable</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IThrowable
	 * @generated
	 */
	EClass getThrowable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IThrowable#getClassName <em>Class Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class Name</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IThrowable#getClassName()
	 * @see #getThrowable()
	 * @generated
	 */
	EAttribute getThrowable_ClassName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IThrowable#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Message</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IThrowable#getMessage()
	 * @see #getThrowable()
	 * @generated
	 */
	EAttribute getThrowable_Message();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.epp.logging.aeri.core.IThrowable#getCause <em>Cause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cause</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IThrowable#getCause()
	 * @see #getThrowable()
	 * @generated
	 */
	EReference getThrowable_Cause();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.epp.logging.aeri.core.IThrowable#getStackTrace <em>Stack Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Stack Trace</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IThrowable#getStackTrace()
	 * @see #getThrowable()
	 * @generated
	 */
	EReference getThrowable_StackTrace();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.IStackTraceElement <em>Stack Trace Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Stack Trace Element</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStackTraceElement
	 * @generated
	 */
	EClass getStackTraceElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStackTraceElement#getFileName <em>File Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>File Name</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStackTraceElement#getFileName()
	 * @see #getStackTraceElement()
	 * @generated
	 */
	EAttribute getStackTraceElement_FileName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStackTraceElement#getClassName <em>Class Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class Name</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStackTraceElement#getClassName()
	 * @see #getStackTraceElement()
	 * @generated
	 */
	EAttribute getStackTraceElement_ClassName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStackTraceElement#getMethodName <em>Method Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Method Name</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStackTraceElement#getMethodName()
	 * @see #getStackTraceElement()
	 * @generated
	 */
	EAttribute getStackTraceElement_MethodName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStackTraceElement#getLineNumber <em>Line Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line Number</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStackTraceElement#getLineNumber()
	 * @see #getStackTraceElement()
	 * @generated
	 */
	EAttribute getStackTraceElement_LineNumber();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IStackTraceElement#isNative <em>Native</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Native</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IStackTraceElement#isNative()
	 * @see #getStackTraceElement()
	 * @generated
	 */
	EAttribute getStackTraceElement_Native();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.IUserSettings <em>User Settings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User Settings</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings
	 * @generated
	 */
	EClass getUserSettings();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterId <em>Reporter Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reporter Id</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterId()
	 * @see #getUserSettings()
	 * @generated
	 */
	EAttribute getUserSettings_ReporterId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterName <em>Reporter Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reporter Name</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterName()
	 * @see #getUserSettings()
	 * @generated
	 */
	EAttribute getUserSettings_ReporterName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterEmail <em>Reporter Email</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reporter Email</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterEmail()
	 * @see #getUserSettings()
	 * @generated
	 */
	EAttribute getUserSettings_ReporterEmail();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeMessages <em>Anonymize Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Anonymize Messages</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeMessages()
	 * @see #getUserSettings()
	 * @generated
	 */
	EAttribute getUserSettings_AnonymizeMessages();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeStackTraces <em>Anonymize Stack Traces</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Anonymize Stack Traces</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeStackTraces()
	 * @see #getUserSettings()
	 * @generated
	 */
	EAttribute getUserSettings_AnonymizeStackTraces();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isDisableAutomaticWiringAnalysis <em>Disable Automatic Wiring Analysis</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Disable Automatic Wiring Analysis</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings#isDisableAutomaticWiringAnalysis()
	 * @see #getUserSettings()
	 * @generated
	 */
	EAttribute getUserSettings_DisableAutomaticWiringAnalysis();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings <em>System Settings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>System Settings</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISystemSettings
	 * @generated
	 */
	EClass getSystemSettings();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getSendMode <em>Send Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Send Mode</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISystemSettings#getSendMode()
	 * @see #getSystemSettings()
	 * @generated
	 */
	EAttribute getSystemSettings_SendMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendMode <em>Reset Send Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reset Send Mode</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendMode()
	 * @see #getSystemSettings()
	 * @generated
	 */
	EAttribute getSystemSettings_ResetSendMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendModeOn <em>Reset Send Mode On</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reset Send Mode On</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendModeOn()
	 * @see #getSystemSettings()
	 * @generated
	 */
	EAttribute getSystemSettings_ResetSendModeOn();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#isConfigured <em>Configured</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Configured</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISystemSettings#isConfigured()
	 * @see #getSystemSettings()
	 * @generated
	 */
	EAttribute getSystemSettings_Configured();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#isDebugEnabled <em>Debug Enabled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Debug Enabled</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISystemSettings#isDebugEnabled()
	 * @see #getSystemSettings()
	 * @generated
	 */
	EAttribute getSystemSettings_DebugEnabled();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getAnonymousId <em>Anonymous Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Anonymous Id</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISystemSettings#getAnonymousId()
	 * @see #getSystemSettings()
	 * @generated
	 */
	EAttribute getSystemSettings_AnonymousId();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.ILink <em>Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Link</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ILink
	 * @generated
	 */
	EClass getLink();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ILink#getRel <em>Rel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rel</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ILink#getRel()
	 * @see #getLink()
	 * @generated
	 */
	EAttribute getLink_Rel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ILink#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ILink#getHref()
	 * @see #getLink()
	 * @generated
	 */
	EAttribute getLink_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ILink#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ILink#getTitle()
	 * @see #getLink()
	 * @generated
	 */
	EAttribute getLink_Title();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.IProblemState <em>Problem State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Problem State</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IProblemState
	 * @generated
	 */
	EClass getProblemState();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IProblemState#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IProblemState#getStatus()
	 * @see #getProblemState()
	 * @generated
	 */
	EAttribute getProblemState_Status();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.IProblemState#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Message</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IProblemState#getMessage()
	 * @see #getProblemState()
	 * @generated
	 */
	EAttribute getProblemState_Message();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.epp.logging.aeri.core.IProblemState#getNeedinfo <em>Needinfo</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Needinfo</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IProblemState#getNeedinfo()
	 * @see #getProblemState()
	 * @generated
	 */
	EAttribute getProblemState_Needinfo();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.ISendOptions <em>Send Options</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Send Options</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISendOptions
	 * @generated
	 */
	EClass getSendOptions();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISendOptions#getComment()
	 * @see #getSendOptions()
	 * @generated
	 */
	EAttribute getSendOptions_Comment();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getSeverity <em>Severity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Severity</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISendOptions#getSeverity()
	 * @see #getSendOptions()
	 * @generated
	 */
	EAttribute getSendOptions_Severity();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getEnabledProcessors <em>Enabled Processors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Enabled Processors</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ISendOptions#getEnabledProcessors()
	 * @see #getSendOptions()
	 * @generated
	 */
	EAttribute getSendOptions_EnabledProcessors();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>String To Link Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String To Link Map</em>'.
	 * @see java.util.Map.Entry
	 * @model keyDataType="org.eclipse.emf.ecore.EString"
	 *        valueType="org.eclipse.epp.logging.aeri.core.Link"
	 * @generated
	 */
	EClass getStringToLinkMap();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToLinkMap()
	 * @generated
	 */
	EAttribute getStringToLinkMap_Key();

	/**
	 * Returns the meta object for the reference '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToLinkMap()
	 * @generated
	 */
	EReference getStringToLinkMap_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.logging.aeri.core.ILinkable <em>Linkable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Linkable</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ILinkable
	 * @generated
	 */
	EClass getLinkable();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.epp.logging.aeri.core.ILinkable#getLinks <em>Links</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Links</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ILinkable#getLinks()
	 * @see #getLinkable()
	 * @generated
	 */
	EReference getLinkable_Links();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>String To String Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String To String Map</em>'.
	 * @see java.util.Map.Entry
	 * @model keyDataType="org.eclipse.emf.ecore.EString"
	 *        valueDefault="" valueDataType="org.eclipse.emf.ecore.EString"
	 * @generated
	 */
	EClass getStringToStringMap();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToStringMap()
	 * @generated
	 */
	EAttribute getStringToStringMap_Key();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToStringMap()
	 * @generated
	 */
	EAttribute getStringToStringMap_Value();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.epp.logging.aeri.core.SendMode <em>Send Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Send Mode</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.SendMode
	 * @generated
	 */
	EEnum getSendMode();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.epp.logging.aeri.core.ResetSendMode <em>Reset Send Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Reset Send Mode</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ResetSendMode
	 * @generated
	 */
	EEnum getResetSendMode();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.epp.logging.aeri.core.Severity <em>Severity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Severity</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.Severity
	 * @generated
	 */
	EEnum getSeverity();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.epp.logging.aeri.core.ProblemStatus <em>Problem Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Problem Status</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.ProblemStatus
	 * @generated
	 */
	EEnum getProblemStatus();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.core.runtime.IProgressMonitor <em>IProgress Monitor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>IProgress Monitor</em>'.
	 * @see org.eclipse.core.runtime.IProgressMonitor
	 * @model instanceClass="org.eclipse.core.runtime.IProgressMonitor"
	 * @generated
	 */
	EDataType getIProgressMonitor();

	/**
	 * Returns the meta object for data type '{@link java.lang.Exception <em>Exception</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Exception</em>'.
	 * @see java.lang.Exception
	 * @model instanceClass="java.lang.Exception"
	 * @generated
	 */
	EDataType getException();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.e4.core.contexts.IEclipseContext <em>IEclipse Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>IEclipse Context</em>'.
	 * @see org.eclipse.e4.core.contexts.IEclipseContext
	 * @model instanceClass="org.eclipse.e4.core.contexts.IEclipseContext"
	 * @generated
	 */
	EDataType getIEclipseContext();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.epp.logging.aeri.core.IServerConnection <em>IServer Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>IServer Connection</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IServerConnection
	 * @model instanceClass="org.eclipse.epp.logging.aeri.core.IServerConnection"
	 * @generated
	 */
	EDataType getIServerConnection();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.epp.logging.aeri.core.IReportProcessor <em>IReport Processor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>IReport Processor</em>'.
	 * @see org.eclipse.epp.logging.aeri.core.IReportProcessor
	 * @model instanceClass="org.eclipse.epp.logging.aeri.core.IReportProcessor"
	 * @generated
	 */
	EDataType getIReportProcessor();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.core.runtime.IStatus <em>IStatus</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>IStatus</em>'.
	 * @see org.eclipse.core.runtime.IStatus
	 * @model instanceClass="org.eclipse.core.runtime.IStatus"
	 * @generated
	 */
	EDataType getIStatus();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.core.runtime.IConfigurationElement <em>IConfiguration Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>IConfiguration Element</em>'.
	 * @see org.eclipse.core.runtime.IConfigurationElement
	 * @model instanceClass="org.eclipse.core.runtime.IConfigurationElement"
	 * @generated
	 */
	EDataType getIConfigurationElement();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	IModelFactory getModelFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl <em>Report</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.ReportImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getReport()
		 * @generated
		 */
		EClass REPORT = eINSTANCE.getReport();

		/**
		 * The meta object literal for the '<em><b>Anonymous Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__ANONYMOUS_ID = eINSTANCE.getReport_AnonymousId();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__NAME = eINSTANCE.getReport_Name();

		/**
		 * The meta object literal for the '<em><b>Email</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__EMAIL = eINSTANCE.getReport_Email();

		/**
		 * The meta object literal for the '<em><b>Comment</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__COMMENT = eINSTANCE.getReport_Comment();

		/**
		 * The meta object literal for the '<em><b>Eclipse Build Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__ECLIPSE_BUILD_ID = eINSTANCE.getReport_EclipseBuildId();

		/**
		 * The meta object literal for the '<em><b>Eclipse Product</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__ECLIPSE_PRODUCT = eINSTANCE.getReport_EclipseProduct();

		/**
		 * The meta object literal for the '<em><b>Java Runtime Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__JAVA_RUNTIME_VERSION = eINSTANCE.getReport_JavaRuntimeVersion();

		/**
		 * The meta object literal for the '<em><b>Osgi Ws</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__OSGI_WS = eINSTANCE.getReport_OsgiWs();

		/**
		 * The meta object literal for the '<em><b>Osgi Os</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__OSGI_OS = eINSTANCE.getReport_OsgiOs();

		/**
		 * The meta object literal for the '<em><b>Osgi Os Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__OSGI_OS_VERSION = eINSTANCE.getReport_OsgiOsVersion();

		/**
		 * The meta object literal for the '<em><b>Osgi Arch</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__OSGI_ARCH = eINSTANCE.getReport_OsgiArch();

		/**
		 * The meta object literal for the '<em><b>Present Bundles</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPORT__PRESENT_BUNDLES = eINSTANCE.getReport_PresentBundles();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPORT__STATUS = eINSTANCE.getReport_Status();

		/**
		 * The meta object literal for the '<em><b>Severity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REPORT__SEVERITY = eINSTANCE.getReport_Severity();

		/**
		 * The meta object literal for the '<em><b>Auxiliary Information</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPORT__AUXILIARY_INFORMATION = eINSTANCE.getReport_AuxiliaryInformation();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.BundleImpl <em>Bundle</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.BundleImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getBundle()
		 * @generated
		 */
		EClass BUNDLE = eINSTANCE.getBundle();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BUNDLE__NAME = eINSTANCE.getBundle_Name();

		/**
		 * The meta object literal for the '<em><b>Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BUNDLE__VERSION = eINSTANCE.getBundle_Version();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.StatusImpl <em>Status</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.StatusImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStatus()
		 * @generated
		 */
		EClass STATUS = eINSTANCE.getStatus();

		/**
		 * The meta object literal for the '<em><b>Plugin Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__PLUGIN_ID = eINSTANCE.getStatus_PluginId();

		/**
		 * The meta object literal for the '<em><b>Plugin Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__PLUGIN_VERSION = eINSTANCE.getStatus_PluginVersion();

		/**
		 * The meta object literal for the '<em><b>Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__CODE = eINSTANCE.getStatus_Code();

		/**
		 * The meta object literal for the '<em><b>Severity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__SEVERITY = eINSTANCE.getStatus_Severity();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__MESSAGE = eINSTANCE.getStatus_Message();

		/**
		 * The meta object literal for the '<em><b>Fingerprint</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__FINGERPRINT = eINSTANCE.getStatus_Fingerprint();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATUS__CHILDREN = eINSTANCE.getStatus_Children();

		/**
		 * The meta object literal for the '<em><b>Exception</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATUS__EXCEPTION = eINSTANCE.getStatus_Exception();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.ThrowableImpl <em>Throwable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.ThrowableImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getThrowable()
		 * @generated
		 */
		EClass THROWABLE = eINSTANCE.getThrowable();

		/**
		 * The meta object literal for the '<em><b>Class Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute THROWABLE__CLASS_NAME = eINSTANCE.getThrowable_ClassName();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute THROWABLE__MESSAGE = eINSTANCE.getThrowable_Message();

		/**
		 * The meta object literal for the '<em><b>Cause</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THROWABLE__CAUSE = eINSTANCE.getThrowable_Cause();

		/**
		 * The meta object literal for the '<em><b>Stack Trace</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THROWABLE__STACK_TRACE = eINSTANCE.getThrowable_StackTrace();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.StackTraceElementImpl <em>Stack Trace Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.StackTraceElementImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStackTraceElement()
		 * @generated
		 */
		EClass STACK_TRACE_ELEMENT = eINSTANCE.getStackTraceElement();

		/**
		 * The meta object literal for the '<em><b>File Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STACK_TRACE_ELEMENT__FILE_NAME = eINSTANCE.getStackTraceElement_FileName();

		/**
		 * The meta object literal for the '<em><b>Class Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STACK_TRACE_ELEMENT__CLASS_NAME = eINSTANCE.getStackTraceElement_ClassName();

		/**
		 * The meta object literal for the '<em><b>Method Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STACK_TRACE_ELEMENT__METHOD_NAME = eINSTANCE.getStackTraceElement_MethodName();

		/**
		 * The meta object literal for the '<em><b>Line Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STACK_TRACE_ELEMENT__LINE_NUMBER = eINSTANCE.getStackTraceElement_LineNumber();

		/**
		 * The meta object literal for the '<em><b>Native</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STACK_TRACE_ELEMENT__NATIVE = eINSTANCE.getStackTraceElement_Native();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl <em>User Settings</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getUserSettings()
		 * @generated
		 */
		EClass USER_SETTINGS = eINSTANCE.getUserSettings();

		/**
		 * The meta object literal for the '<em><b>Reporter Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_SETTINGS__REPORTER_ID = eINSTANCE.getUserSettings_ReporterId();

		/**
		 * The meta object literal for the '<em><b>Reporter Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_SETTINGS__REPORTER_NAME = eINSTANCE.getUserSettings_ReporterName();

		/**
		 * The meta object literal for the '<em><b>Reporter Email</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_SETTINGS__REPORTER_EMAIL = eINSTANCE.getUserSettings_ReporterEmail();

		/**
		 * The meta object literal for the '<em><b>Anonymize Messages</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_SETTINGS__ANONYMIZE_MESSAGES = eINSTANCE.getUserSettings_AnonymizeMessages();

		/**
		 * The meta object literal for the '<em><b>Anonymize Stack Traces</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_SETTINGS__ANONYMIZE_STACK_TRACES = eINSTANCE.getUserSettings_AnonymizeStackTraces();

		/**
		 * The meta object literal for the '<em><b>Disable Automatic Wiring Analysis</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS = eINSTANCE.getUserSettings_DisableAutomaticWiringAnalysis();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl <em>System Settings</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSystemSettings()
		 * @generated
		 */
		EClass SYSTEM_SETTINGS = eINSTANCE.getSystemSettings();

		/**
		 * The meta object literal for the '<em><b>Send Mode</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSTEM_SETTINGS__SEND_MODE = eINSTANCE.getSystemSettings_SendMode();

		/**
		 * The meta object literal for the '<em><b>Reset Send Mode</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSTEM_SETTINGS__RESET_SEND_MODE = eINSTANCE.getSystemSettings_ResetSendMode();

		/**
		 * The meta object literal for the '<em><b>Reset Send Mode On</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSTEM_SETTINGS__RESET_SEND_MODE_ON = eINSTANCE.getSystemSettings_ResetSendModeOn();

		/**
		 * The meta object literal for the '<em><b>Configured</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSTEM_SETTINGS__CONFIGURED = eINSTANCE.getSystemSettings_Configured();

		/**
		 * The meta object literal for the '<em><b>Debug Enabled</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSTEM_SETTINGS__DEBUG_ENABLED = eINSTANCE.getSystemSettings_DebugEnabled();

		/**
		 * The meta object literal for the '<em><b>Anonymous Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSTEM_SETTINGS__ANONYMOUS_ID = eINSTANCE.getSystemSettings_AnonymousId();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.LinkImpl <em>Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.LinkImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getLink()
		 * @generated
		 */
		EClass LINK = eINSTANCE.getLink();

		/**
		 * The meta object literal for the '<em><b>Rel</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINK__REL = eINSTANCE.getLink_Rel();

		/**
		 * The meta object literal for the '<em><b>Href</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINK__HREF = eINSTANCE.getLink_Href();

		/**
		 * The meta object literal for the '<em><b>Title</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINK__TITLE = eINSTANCE.getLink_Title();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.ProblemStateImpl <em>Problem State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.ProblemStateImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getProblemState()
		 * @generated
		 */
		EClass PROBLEM_STATE = eINSTANCE.getProblemState();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROBLEM_STATE__STATUS = eINSTANCE.getProblemState_Status();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROBLEM_STATE__MESSAGE = eINSTANCE.getProblemState_Message();

		/**
		 * The meta object literal for the '<em><b>Needinfo</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROBLEM_STATE__NEEDINFO = eINSTANCE.getProblemState_Needinfo();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.SendOptionsImpl <em>Send Options</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.SendOptionsImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSendOptions()
		 * @generated
		 */
		EClass SEND_OPTIONS = eINSTANCE.getSendOptions();

		/**
		 * The meta object literal for the '<em><b>Comment</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEND_OPTIONS__COMMENT = eINSTANCE.getSendOptions_Comment();

		/**
		 * The meta object literal for the '<em><b>Severity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEND_OPTIONS__SEVERITY = eINSTANCE.getSendOptions_Severity();

		/**
		 * The meta object literal for the '<em><b>Enabled Processors</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEND_OPTIONS__ENABLED_PROCESSORS = eINSTANCE.getSendOptions_EnabledProcessors();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.StringToLinkMapImpl <em>String To Link Map</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.StringToLinkMapImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStringToLinkMap()
		 * @generated
		 */
		EClass STRING_TO_LINK_MAP = eINSTANCE.getStringToLinkMap();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_TO_LINK_MAP__KEY = eINSTANCE.getStringToLinkMap_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRING_TO_LINK_MAP__VALUE = eINSTANCE.getStringToLinkMap_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.LinkableImpl <em>Linkable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.LinkableImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getLinkable()
		 * @generated
		 */
		EClass LINKABLE = eINSTANCE.getLinkable();

		/**
		 * The meta object literal for the '<em><b>Links</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LINKABLE__LINKS = eINSTANCE.getLinkable_Links();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.impl.StringToStringMapImpl <em>String To String Map</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.impl.StringToStringMapImpl
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getStringToStringMap()
		 * @generated
		 */
		EClass STRING_TO_STRING_MAP = eINSTANCE.getStringToStringMap();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_TO_STRING_MAP__KEY = eINSTANCE.getStringToStringMap_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_TO_STRING_MAP__VALUE = eINSTANCE.getStringToStringMap_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.SendMode <em>Send Mode</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.SendMode
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSendMode()
		 * @generated
		 */
		EEnum SEND_MODE = eINSTANCE.getSendMode();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.ResetSendMode <em>Reset Send Mode</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.ResetSendMode
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getResetSendMode()
		 * @generated
		 */
		EEnum RESET_SEND_MODE = eINSTANCE.getResetSendMode();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.Severity <em>Severity</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.Severity
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getSeverity()
		 * @generated
		 */
		EEnum SEVERITY = eINSTANCE.getSeverity();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.logging.aeri.core.ProblemStatus <em>Problem Status</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.ProblemStatus
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getProblemStatus()
		 * @generated
		 */
		EEnum PROBLEM_STATUS = eINSTANCE.getProblemStatus();

		/**
		 * The meta object literal for the '<em>IProgress Monitor</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.core.runtime.IProgressMonitor
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIProgressMonitor()
		 * @generated
		 */
		EDataType IPROGRESS_MONITOR = eINSTANCE.getIProgressMonitor();

		/**
		 * The meta object literal for the '<em>Exception</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see java.lang.Exception
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getException()
		 * @generated
		 */
		EDataType EXCEPTION = eINSTANCE.getException();

		/**
		 * The meta object literal for the '<em>IEclipse Context</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.e4.core.contexts.IEclipseContext
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIEclipseContext()
		 * @generated
		 */
		EDataType IECLIPSE_CONTEXT = eINSTANCE.getIEclipseContext();

		/**
		 * The meta object literal for the '<em>IServer Connection</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.IServerConnection
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIServerConnection()
		 * @generated
		 */
		EDataType ISERVER_CONNECTION = eINSTANCE.getIServerConnection();

		/**
		 * The meta object literal for the '<em>IReport Processor</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.logging.aeri.core.IReportProcessor
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIReportProcessor()
		 * @generated
		 */
		EDataType IREPORT_PROCESSOR = eINSTANCE.getIReportProcessor();

		/**
		 * The meta object literal for the '<em>IStatus</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.core.runtime.IStatus
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIStatus()
		 * @generated
		 */
		EDataType ISTATUS = eINSTANCE.getIStatus();

		/**
		 * The meta object literal for the '<em>IConfiguration Element</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.core.runtime.IConfigurationElement
		 * @see org.eclipse.epp.logging.aeri.core.impl.ModelPackageImpl#getIConfigurationElement()
		 * @generated
		 */
		EDataType ICONFIGURATION_ELEMENT = eINSTANCE.getIConfigurationElement();

	}

} //IModelPackage
