/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.UnresolvedProxyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandFactoryUtils {
    private CommandFactoryUtils() {
    }

    private static Set<ETypedElement> getAllETypedElement(Table table, List<Row> rowsToKeep, List<? extends FacetSet> nextLoadedFacets) {
        HashSet<ETypedElement> eTypedElements = new HashSet<ETypedElement>();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager((ResourceSet)new ResourceSetImpl());
        if (nextLoadedFacets == null) {
            facetManager.getManagedFacetSets().addAll(table.getFacetSets());
        } else {
            facetManager.getManagedFacetSets().addAll(nextLoadedFacets);
        }
        for (Row row : rowsToKeep) {
            EClass eClass = row.getElement().eClass();
            eTypedElements.addAll((Collection<ETypedElement>)eClass.getEAllStructuralFeatures());
            eTypedElements.addAll((Collection<ETypedElement>)eClass.getEAllOperations());
            try {
                Set facetTEs = FacetUtils.getETypedElements((EObject)row.getElement(), ETypedElement.class, (IFacetManager)facetManager);
                eTypedElements.addAll(facetTEs);
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (String)("An exception has occured while retrieving structural features of:" + row.getElement()), (Plugin)Activator.getDefault());
            }
        }
        return eTypedElements;
    }

    public static List<FeatureColumn> columnsToRemove(Table table, List<? extends FacetSet> newFacetSets, List<Row> rowsToKeep) {
        ArrayList<FeatureColumn> result = new ArrayList<FeatureColumn>();
        if (rowsToKeep.isEmpty()) {
            for (Column column : table.getColumns()) {
                if (!(column instanceof FeatureColumn)) continue;
                FeatureColumn featureColumn = (FeatureColumn)column;
                CommandFactoryUtils.addToListNotDefault(featureColumn, result, table);
            }
        } else {
            ArrayList<ETypedElement> eTypedElements = new ArrayList<ETypedElement>(CommandFactoryUtils.getAllETypedElement(table, rowsToKeep, newFacetSets));
            for (Column column : table.getColumns()) {
                if (!(column instanceof FeatureColumn)) continue;
                FeatureColumn featureColumn = (FeatureColumn)column;
                ETypedElement eTypedElement = featureColumn.getFeature();
                if ((eTypedElement = (ETypedElement)EcoreUtil.resolve((EObject)eTypedElement, (EObject)table)).eIsProxy()) {
                    throw new UnresolvedProxyException("The current structural feature should have been resolved. " + EcoreUtil.getURI((EObject)eTypedElement));
                }
                ETypedElement resolvedTE = (ETypedElement)IResolverManager.DEFAULT.resolve((Object)eTypedElement, ETypedElement.class);
                if (resolvedTE != null) {
                    eTypedElement = resolvedTE;
                }
                if (eTypedElements.contains(eTypedElement)) continue;
                CommandFactoryUtils.addToListNotDefault(featureColumn, result, table);
            }
        }
        return result;
    }

    private static void addToListNotDefault(FeatureColumn featureColumn, List<FeatureColumn> list, Table table) {
        TableConfiguration tableConfig = table.getTableConfiguration();
        if (tableConfig == null || !tableConfig.getDefaultColumns().contains((Object)featureColumn.getFeature())) {
            list.add(featureColumn);
        }
    }

    public static boolean isColumnAlreadyDeclared(Table table, EStructuralFeature structuralFeature) {
        boolean result = false;
        for (Column column : table.getColumns()) {
            FeatureColumn featureColumn;
            if (!(column instanceof FeatureColumn) || (featureColumn = (FeatureColumn)column).getFeature() != structuralFeature) continue;
            result = true;
            break;
        }
        return result;
    }
}

