/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCell;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCellSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableColumnSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableRectangleSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableRowSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.TableWidgetSelectionProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionService {
    private final TableWidgetSelectionProvider widgetSelectionP;
    private final IFacetManager facetManager;

    public SelectionService(TableWidgetSelectionProvider widgetSelectionP, IFacetManager facetManager) {
        this.widgetSelectionP = widgetSelectionP;
        this.facetManager = facetManager;
    }

    public boolean isSelectedCellEditable() {
        ITableCellSelection cellSelection;
        List<ITableCell> selectedCells;
        boolean result = false;
        ISelectionProvider controlSelectionP = this.widgetSelectionP.getControlSelectionProvider();
        ISelection selection = controlSelectionP.getSelection();
        if (selection instanceof ITableCellSelection && (selectedCells = (cellSelection = (ITableCellSelection)selection).getSelectedCells()).size() == 1) {
            ITableCell cell = selectedCells.get(0);
            Row row = cell.getRow();
            EObject eObject = row.getElement();
            Column column = cell.getColumn();
            result = FacetsUtils.isCellEditable(this.facetManager, eObject, column);
        }
        return result;
    }

    public final boolean isColumnSelected() {
        List<Column> columns = this.getSelectedColumns();
        return !columns.isEmpty();
    }

    public List<Column> getSelectedColumns() {
        List<Column> result = Collections.emptyList();
        ISelection selection = this.widgetSelectionP.getControlSelectionProvider().getSelection();
        if (selection instanceof ITableColumnSelection) {
            ITableColumnSelection tableColSelection = (ITableColumnSelection)selection;
            result = tableColSelection.getSelectedFullColumns();
        }
        return result;
    }

    public List<EObject> getSelectedRowEObjects() {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Row row : this.getSelectedRow()) {
            result.add(row.getElement());
        }
        return result;
    }

    public Collection<Row> getSelectedRow() {
        ArrayList<Row> result = new ArrayList<Row>();
        ISelectionProvider controlSelectionP = this.widgetSelectionP.getControlSelectionProvider();
        ISelection selection = controlSelectionP.getSelection();
        if (selection instanceof ITableRowSelection) {
            ITableRowSelection rowSelection = (ITableRowSelection)selection;
            List<Row> list = rowSelection.getSelectedFullRows();
            result.addAll(list);
        }
        return result;
    }

    public Set<EObject> getSelectedEObjects() {
        HashSet<EObject> selectedEObjects = new HashSet<EObject>();
        ISelection selection = this.widgetSelectionP.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            List list = structSelection.toList();
            for (Object object : list) {
                if (!(object instanceof EObject)) continue;
                EObject eObject = (EObject)object;
                selectedEObjects.add(eObject);
            }
        }
        return selectedEObjects;
    }

    public List<Object> getRawSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        ISelection selection = this.widgetSelectionP.getControlSelectionProvider().getSelection();
        if (selection instanceof ITableCellSelection) {
            ITableCellSelection cellSelection = (ITableCellSelection)selection;
            result.addAll(cellSelection.getSelectedCells());
        } else if (selection instanceof ITableRectangleSelection) {
            ITableRectangleSelection cellSelection = (ITableRectangleSelection)selection;
            result.addAll(cellSelection.getSelectedRows());
            result.addAll(cellSelection.getSelectedColumns());
        } else if (selection instanceof ITableRowSelection) {
            ITableRowSelection rowSelection = (ITableRowSelection)selection;
            result.addAll(rowSelection.getSelectedFullRows());
        } else if (selection instanceof ITableColumnSelection) {
            ITableColumnSelection columnSelection = (ITableColumnSelection)selection;
            result.addAll(columnSelection.getSelectedFullColumns());
        }
        return result;
    }
}

