/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.ui.internal.dialogs;

import java.util.TreeSet;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.common.ui.internal.widgets.AnywhereFilterMatcher;
import org.eclipse.emf.facet.util.emf.ui.internal.Activator;
import org.eclipse.emf.facet.util.emf.ui.internal.Messages;
import org.eclipse.emf.facet.util.emf.ui.internal.utils.ImageProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;

public class UriSelectionDialog
extends ElementListSelectionDialog {
    private static final String DIALOG_SETTINGS = "UriSelectionDialogSettings";
    private String uri = "";

    public UriSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new LabelProvider());
        this.setTitle(Messages.DialogUriSelection_title_OpenModelFromEMFRegistry);
        this.setMessage(Messages.DialogUriSelection_RegisteredEPackages);
        TreeSet<String> uris = new TreeSet<String>();
        for (Object name : EPackage.Registry.INSTANCE.keySet()) {
            uris.add(name.toString());
        }
        this.setElements(uris.toArray());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)new AnywhereFilterMatcher());
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
        if (this.getResult().length > 0) {
            this.uri = this.getResult()[0].toString();
        }
    }

    public String getUriSelected() {
        return this.uri;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImage(ImageProvider.getInstance().getEmfFacetLogo());
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getPlugin().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS);
        }
        return section;
    }
}

