/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.revision;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionValueVisitor;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.Predicate;
import org.eclipse.net4j.util.Predicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCDORevision
implements InternalCDORevision {
    private InternalCDOClassInfo classInfo;

    protected AbstractCDORevision(EClass eClass) {
        if (eClass != null) {
            if (eClass.isAbstract()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("AbstractCDORevision.0"), eClass));
            }
            this.initClassInfo(eClass);
        }
    }

    protected AbstractCDORevision(InternalCDOClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    @Override
    public final InternalCDOClassInfo getClassInfo() {
        return this.classInfo;
    }

    @Override
    public final EClass getEClass() {
        if (this.classInfo != null) {
            return this.classInfo.getEClass();
        }
        return null;
    }

    @Override
    public InternalCDORevision getRevisionForID(CDOID id) {
        if (id != null && id.equals(this.getID())) {
            throw new ImplementationError();
        }
        return this.classInfo.getRevisionForID(id);
    }

    @Override
    public InternalCDORevision getProperRevision() {
        return this;
    }

    @Override
    public boolean isResourceNode() {
        return this.classInfo.isResourceNode();
    }

    @Override
    public boolean isResourceFolder() {
        return this.classInfo.isResourceFolder();
    }

    @Override
    public boolean isResource() {
        return this.classInfo.isResource();
    }

    @Override
    public CDORevisionData data() {
        return this;
    }

    @Override
    public CDORevision revision() {
        return this;
    }

    @Override
    public boolean isHistorical() {
        return this.getRevised() != 0L;
    }

    @Override
    public boolean isValid(long timeStamp) {
        long startTime = this.getTimeStamp();
        long endTime = this.getRevised();
        return CDOCommonUtil.isValidTimeStamp(timeStamp, startTime, endTime);
    }

    @Override
    public boolean isValid(CDOBranchPoint branchPoint) {
        return this.getBranch() == branchPoint.getBranch() && this.isValid(branchPoint.getTimeStamp());
    }

    @Override
    public boolean isReadable() {
        return this.getPermission().isReadable();
    }

    @Override
    public boolean isWritable() {
        return this.getPermission().isWritable();
    }

    @Override
    public void accept(CDORevisionValueVisitor visitor) {
        this.accept(visitor, (Predicate<EStructuralFeature>)Predicates.alwaysTrue());
    }

    @Override
    public void accept(CDORevisionValueVisitor visitor, Predicate<EStructuralFeature> filter) {
        EStructuralFeature[] eStructuralFeatureArray = this.classInfo.getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (filter.apply((Object)feature)) {
                if (feature.isMany()) {
                    CDOList list = this.getListOrNull(feature);
                    if (list != null) {
                        int index = 0;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Object value = iterator.next();
                            visitor.visit(feature, value, index++);
                        }
                    }
                } else {
                    Object value = this.getValue(feature);
                    visitor.visit(feature, value, -1);
                }
            }
            ++n2;
        }
    }

    @Override
    public void adjustForCommit(CDOBranch branch, long timeStamp) {
        if (branch == this.getBranch()) {
            this.setVersion(this.getVersion() + 1);
        } else {
            this.setVersion(1);
        }
        this.setBranchPoint(branch.getPoint(timeStamp));
        this.setRevised(0L);
    }

    public int hashCode() {
        return ObjectUtil.hashCode((Object)this.getID()) ^ ObjectUtil.hashCode((Object)this.getBranch()) ^ this.getVersion();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDORevision) {
            CDORevision that = (CDORevision)obj;
            return this.getID() == that.getID() && this.getVersion() == that.getVersion() && this.getBranch() == that.getBranch();
        }
        return false;
    }

    public String toString() {
        EClass eClass = this.getEClass();
        String name = eClass == null ? "Revision" : eClass.getName();
        String string = String.valueOf(name) + "@" + this.getID();
        InternalCDOBranch branch = this.getBranch();
        if (branch != null) {
            string = String.valueOf(string) + ":" + branch.getID();
        }
        string = String.valueOf(string) + "v" + this.getVersion();
        if (this.isResourceNode()) {
            String resourceNodeName = this.getResourceNodeName();
            if (resourceNodeName == null) {
                resourceNodeName = "/";
            }
            string = String.valueOf(string) + "(\"" + resourceNodeName + "\")";
        }
        return string;
    }

    @Override
    @Deprecated
    public CDOList getList(EStructuralFeature feature) {
        return this.getOrCreateList(feature);
    }

    @Override
    @Deprecated
    public CDOList getList(EStructuralFeature feature, int initialCapacity) {
        return this.getOrCreateList(feature, initialCapacity);
    }

    protected void initClassInfo(EClass eClass) {
        this.classInfo = (InternalCDOClassInfo)CDOModelUtil.getClassInfo(eClass);
    }

    protected EStructuralFeature[] getAllPersistentFeatures() {
        return this.classInfo.getAllPersistentFeatures();
    }

    protected int getFeatureIndex(EStructuralFeature feature) {
        return this.classInfo.getPersistentFeatureIndex(feature);
    }
}

