/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.dialogs.PatternElementSelectionDialog;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.ContainerLibraryLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerLibrarySelectionDialog
extends PatternElementSelectionDialog {
    private TableViewer tableViewer;
    private Text text;
    private PatternLibrary patternLibrary;
    private String librayName;

    public ContainerLibrarySelectionDialog(Shell shell, PatternLibrary patternLibrary) {
        super(shell);
        this.patternLibrary = patternLibrary;
        if (patternLibrary != null) {
            this.librayName = patternLibrary.getName();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.checkContainerExist(this.librayName);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 380;
        container.setLayoutData((Object)gd);
        Label patternLabel = new Label(container, 0);
        patternLabel.setText(Messages.ContainerLibrarySelectionDialog_pattern_label);
        this.text = new Text(container, 2048);
        gd = new GridData(768);
        gd.widthHint = 550;
        this.text.setLayoutData((Object)gd);
        this.text.setText("");
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                List listAreaDisplay = ContainerLibrarySelectionDialog.this.getListAreaDisplay(ContainerLibrarySelectionDialog.this.text.getText());
                ContainerLibrarySelectionDialog.this.tableViewer.setInput((Object)listAreaDisplay);
                ContainerLibrarySelectionDialog.this.checkContainerExist(ContainerLibrarySelectionDialog.this.text.getText());
                ContainerLibrarySelectionDialog.this.getSelectDefault(listAreaDisplay);
            }
        });
        Label label = new Label(container, 0);
        label.setText(Messages.ContainerLibrarySelectionDialog_dialogArea_label);
        this.createListArea(container);
        return this.dialogArea;
    }

    private void createListArea(Composite container) {
        Table listTable = new Table(container, 2816);
        GridData gd = new GridData(1808);
        listTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(listTable, 0);
        tableColumn.setWidth(500);
        this.tableViewer = new TableViewer(listTable);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ContainerLibraryLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new CommonListContentProvider());
        List<PatternLibrary> listAreaDisplay = this.getListAreaDisplay(this.librayName);
        this.tableViewer.setInput(listAreaDisplay);
        this.getSelectDefault(listAreaDisplay);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof PatternLibrary) {
                    ContainerLibrarySelectionDialog.this.patternLibrary = (PatternLibrary)selection.getFirstElement();
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ContainerLibrarySelectionDialog.this.okPressed();
            }
        });
    }

    private List<PatternLibrary> getContainerLibraryList() {
        return PatternHelper.TRANSACTIONNAL_COLLECTOR.getAllLibraries();
    }

    private void checkContainerExist(String name) {
        Status fLastStatusErr = new Status(4, "org.eclipse.jdt.core", -1, "", null);
        Status fLastStatusOk = new Status(0, "org.eclipse.jface", 0, "", null);
        if (this.getListAreaDisplay(name).size() > 0) {
            this.updateStatus((IStatus)fLastStatusOk);
            return;
        }
        this.updateStatus((IStatus)fLastStatusErr);
    }

    private List<PatternLibrary> getListAreaDisplay(String name) {
        ArrayList<PatternLibrary> containerLibrarysNew = new ArrayList<PatternLibrary>();
        for (PatternLibrary containerLibrary : this.getContainerLibraryList()) {
            if (!ContainerLibrarySelectionDialog.searchContainer(containerLibrary.getName(), name)) continue;
            containerLibrarysNew.add(containerLibrary);
        }
        return containerLibrarysNew;
    }

    private void getSelectDefault(List<PatternLibrary> model) {
        Object selectEntry = this.selectDefault(model, this.tableViewer);
        if (selectEntry instanceof PatternLibrary) {
            this.patternLibrary = (PatternLibrary)selectEntry;
        }
    }

    public PatternLibrary getLibraryContainer() {
        return this.patternLibrary;
    }
}

