/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.IMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.jface.action.Action;

public class RemoveMemoryRenderingAction
extends Action {
    private IMemoryRenderingContainer fViewPane;

    public RemoveMemoryRenderingAction(IMemoryRenderingContainer viewPane) {
        super(DebugUIMessages.RemoveMemoryRenderingAction_Remove_rendering, 1);
        this.setText(DebugUIMessages.RemoveMemoryRenderingAction_Remove_rendering);
        this.setToolTipText(DebugUIMessages.RemoveMemoryRenderingAction_Remove_rendering);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_MEMORY"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_MEMORY"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_MEMORY"));
        this.fViewPane = viewPane;
    }

    public void run() {
        IMemoryRendering rendering;
        IMemoryViewTab topTab = this.getViewTab();
        if (topTab != null && (rendering = topTab.getRendering()) != null) {
            this.fViewPane.removeMemoryRendering(rendering);
        }
    }

    IMemoryViewTab getViewTab() {
        if (this.fViewPane instanceof IMemoryView) {
            return ((IMemoryView)((Object)this.fViewPane)).getTopMemoryTab();
        }
        return null;
    }
}

