/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.pro.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cdt.internal.qt.ui.pro.parser.QtProjectVariable;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class QtProjectFileParser
implements IDocumentListener {
    IDocument document;
    List<QtProjectVariable> variables;

    public QtProjectFileParser(IDocument doc) {
        if (doc == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
        this.document = doc;
        this.variables = this.parse();
        this.document.addDocumentListener((IDocumentListener)this);
    }

    public IDocument getDocument() {
        return this.document;
    }

    private List<QtProjectVariable> parse() {
        CopyOnWriteArrayList<QtProjectVariable> variables = new CopyOnWriteArrayList<QtProjectVariable>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(this.document.get());){
            QtProjectVariable next;
            while ((next = QtProjectVariable.findNextVariable(scanner)) != null) {
                variables.add(next);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return variables;
    }

    public QtProjectVariable getVariable(String name) {
        for (QtProjectVariable v : this.variables) {
            if (!v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public List<QtProjectVariable> getAllVariables() {
        return new ArrayList<QtProjectVariable>(this.variables);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.variables = this.parse();
    }

    protected void finalize() throws Throwable {
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
        }
    }
}

