/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.features.flow.MessageFlowFeatureContainer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ConnectionLayerClippingStrategy
implements IClippingStrategy {
    protected Diagram diagram;
    protected GraphicalViewer graphicalViewer;

    public static void applyTo(GraphicalViewer graphicalViewer) {
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)graphicalViewer.getRootEditPart();
        Figure connectionLayer = (Figure)rootEditPart.getLayer((Object)"Connection Layer");
        if (connectionLayer.getClippingStrategy() == null) {
            EditPart editPart = graphicalViewer.getContents();
            Diagram diagram = (Diagram)editPart.getModel();
            ConnectionLayerClippingStrategy clippingStrategy = new ConnectionLayerClippingStrategy(graphicalViewer, diagram);
            connectionLayer.setClippingStrategy((IClippingStrategy)clippingStrategy);
        }
    }

    public ConnectionLayerClippingStrategy(GraphicalViewer graphicalViewer, Diagram diagram) {
        this.diagram = diagram;
        this.graphicalViewer = graphicalViewer;
    }

    public Rectangle[] getClip(IFigure childFigure) {
        try {
            for (Object value : this.graphicalViewer.getEditPartRegistry().values()) {
                BPMNEdge bpmnEdge;
                Object model;
                GraphicalEditPart part = (GraphicalEditPart)value;
                if (part.getFigure() != childFigure || !((model = part.getModel()) instanceof Connection)) continue;
                Connection connection = (Connection)model;
                BaseElement businessObject = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
                if (businessObject instanceof MessageFlow) {
                    ContainerShape messageShape = MessageFlowFeatureContainer.findMessageShape(connection);
                    if (messageShape == null) continue;
                    Rectangle inner = this.getClip(messageShape)[0];
                    Rectangle outer = childFigure.getBounds();
                    return this.getClip(outer, inner);
                }
                if (businessObject == null) continue;
                AnchorContainer source = connection.getStart().getParent();
                AnchorContainer target = connection.getEnd().getParent();
                if (source.eContainer() != target.eContainer()) {
                    return new Rectangle[]{childFigure.getBounds()};
                }
                EObject container = businessObject.eContainer();
                if (!(container instanceof SubProcess) || (bpmnEdge = (BPMNEdge)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BPMNEdge.class)) == null) continue;
                for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(this.diagram, container)) {
                    BPMNShape bpmnShape;
                    if (!(pe instanceof ContainerShape) || (bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BPMNShape.class)) != null && bpmnShape.eContainer() != bpmnEdge.eContainer()) continue;
                    BaseElement sourceBo = BusinessObjectUtil.getFirstBaseElement((PictogramElement)source);
                    BaseElement targetBo = BusinessObjectUtil.getFirstBaseElement((PictogramElement)target);
                    if (sourceBo == container || targetBo == container) continue;
                    ContainerShape parent = ((ContainerShape)pe).getContainer();
                    while (!(parent instanceof Diagram)) {
                        if (BusinessObjectUtil.getFirstBaseElement((PictogramElement)parent) instanceof SubProcess) {
                            pe = parent;
                        }
                        parent = parent.getContainer();
                    }
                    return this.getClip((ContainerShape)pe);
                }
            }
        }
        catch (Exception exception) {}
        return new Rectangle[]{childFigure.getBounds()};
    }

    private Rectangle[] getClip(Rectangle outer, Rectangle inner) {
        if (outer.width > inner.width && outer.height > inner.height) {
            Rectangle[] clip = new Rectangle[]{new Rectangle(outer.x, outer.y, outer.width, inner.y - outer.y), new Rectangle(outer.x, inner.y, inner.x - outer.x, inner.height), new Rectangle(inner.x + inner.width, inner.y, outer.x + outer.width - (inner.x + inner.width), inner.height), new Rectangle(outer.x, inner.y + inner.height, outer.width, outer.y + outer.height - (inner.y + inner.height))};
            return clip;
        }
        return new Rectangle[]{outer};
    }

    private Rectangle[] getClip(ContainerShape pe) {
        ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)pe);
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pe);
        if (FeatureSupport.isExpandableElement((BaseElement)be) && !FeatureSupport.isElementExpanded((BaseElement)be)) {
            return new Rectangle[]{new Rectangle(loc.getX(), loc.getY(), 1, 1)};
        }
        return new Rectangle[]{new Rectangle(loc.getX(), loc.getY(), ga.getWidth(), ga.getHeight())};
    }
}

