/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.Date;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractParseState {
    protected String context;
    protected String elementName = null;
    protected StringBuffer text = new StringBuffer();

    public void setElementName(String name) {
        this.elementName = name;
    }

    public AbstractParseState jumpTo() {
        return null;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
    }

    public AbstractParseState startElement(String tagName) {
        ModuleParserHandler moduleHandler;
        XMLParserHandler handler = this.getHandler();
        boolean isSetWarning = false;
        if (handler instanceof ModuleParserHandler && (moduleHandler = (ModuleParserHandler)handler).isLaterVersion() && moduleHandler.getModule().getOptions() != null && moduleHandler.getModule().getOptions().isSupportedUnknownVersion()) {
            isSetWarning = true;
        }
        if (isSetWarning) {
            this.getHandler().getErrorHandler().semanticWarning(new XMLParserException("Error.XMLParserException.UNKNOWN_TAG"));
        } else {
            this.getHandler().getErrorHandler().semanticError(new XMLParserException("Error.XMLParserException.UNKNOWN_TAG"));
        }
        return new AnyElementState(this.getHandler());
    }

    public abstract XMLParserHandler getHandler();

    public void endElement(AbstractParseState state) {
    }

    public void end() throws SAXException {
    }

    public boolean getBooleanAttrib(Attributes attrs, String attrName, boolean defaultValue) {
        return this.parseBoolean(attrs.getValue(attrName), defaultValue);
    }

    public boolean parseBoolean(String value, boolean defaultValue) {
        if ((value = StringUtil.trimString(value)) == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        this.getHandler().getErrorHandler().semanticError(new XMLParserException("Error.XMLParserException.INVALID_BOOLEAN"));
        return defaultValue;
    }

    public int getIntAttrib(Attributes attrs, String attrName) {
        return this.getIntAttrib(attrs, attrName, 0);
    }

    public int getIntAttrib(Attributes attrs, String attrName, int defaultValue) {
        String value = attrs.getValue(attrName);
        if (value == null) {
            return defaultValue;
        }
        try {
            Integer result = Integer.decode(value);
            return result;
        }
        catch (NumberFormatException numberFormatException) {
            this.getHandler().getErrorHandler().semanticError(new XMLParserException("Error.XMLParserException.INVALID_INTEGER"));
            return 0;
        }
    }

    protected String getAttrib(Attributes attrs, String attrName) {
        return StringUtil.trimString(attrs.getValue(attrName));
    }

    protected Date getDateAttrib(Attributes attrs, String attrName) {
        assert (false);
        return null;
    }

    public void setIsCDataSection(boolean isCDataSection) {
    }
}

