/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.MathUtil;
import org.eclipse.birt.core.script.function.bre.Function_temp;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

class BirtMath
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_ID = "org.eclipse.birt.core.script.function.bre";
    private IScriptFunctionExecutor executor;

    BirtMath(String functionName) throws BirtException {
        if ("add".equals(functionName)) {
            this.executor = new Function_Add();
        } else if ("subtract".equals(functionName)) {
            this.executor = new Function_Subtract();
        } else if ("multiple".equals(functionName) || "multiply".equals(functionName)) {
            this.executor = new Function_Multiple();
        } else if ("divide".equals(functionName)) {
            this.executor = new Function_Divide();
        } else if ("round".equals(functionName)) {
            this.executor = new Function_Round();
        } else if ("roundUp".equals(functionName)) {
            this.executor = new Function_RoundUp();
        } else if ("roundDown".equals(functionName)) {
            this.executor = new Function_RoundDown();
        } else if ("ceiling".equals(functionName)) {
            this.executor = new Function_Ceiling();
        } else if ("mod".equals(functionName)) {
            this.executor = new Function_Mod();
        } else if ("safeDivide".equals(functionName)) {
            this.executor = new Function_SafeDivide();
        } else {
            throw new BirtException(PACKAGE_ID, null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "BirtMath." + functionName));
        }
    }

    private static double round(double value) {
        return BirtMath.round(value, 0);
    }

    private static double round(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(value * multiple) / multiple;
    }

    private static double roundUp(double value) {
        return BirtMath.roundUp(value, 0);
    }

    private static double roundUp(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(Math.ceil(value * multiple)) / multiple;
    }

    private static double getMultiple(int dec) {
        double multiple = 1.0;
        if (dec >= 0) {
            int i = 0;
            while (i < dec) {
                multiple *= 10.0;
                ++i;
            }
        } else {
            double adjustment = 1.0;
            int i = dec;
            while (i < 0) {
                multiple *= 0.1;
                adjustment *= 10.0;
                ++i;
            }
            multiple = (double)Math.round(multiple * adjustment) / adjustment;
        }
        return multiple;
    }

    private static double roundDown(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(Math.floor(value * multiple)) / multiple;
    }

    private static double roundDown(double value) {
        return BirtMath.roundDown(value, 0);
    }

    private static double ceiling(double n, double significance) {
        if (significance == 0.0 || n == 0.0) {
            return 0.0;
        }
        if (n * significance < 0.0) {
            throw new IllegalArgumentException(Messages.getFormattedString("error.BirtMath.ceiling.significance.notApplied", new Object[]{significance, n}));
        }
        if (Math.abs(n) < Math.abs(significance)) {
            return significance;
        }
        double multiple = Math.ceil(n / significance);
        long multiIntValue = Math.round(multiple);
        int divisor = 1;
        double temp = significance;
        double MIN_VALUE = 1.0E-10;
        int i = 1;
        while (i < 30) {
            if (Math.abs((double)Math.round(temp * (double)(divisor *= 10)) - temp * (double)divisor) <= MIN_VALUE) break;
            ++i;
        }
        return (double)multiIntValue * (significance * (double)divisor) / (double)divisor;
    }

    private static double mod(double n, double div) {
        if (div == 0.0) {
            throw new IllegalArgumentException(Messages.getString("error.BirtMath.mod.invalid.divisor"));
        }
        return n - div * Math.floor(n / div);
    }

    private static double toDoubleValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return o == null ? 0.0 : Double.valueOf(o.toString());
    }

    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        return this.executor.execute(arguments, context);
    }

    private static class Function_Add
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Add() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            return MathUtil.add((Object)args[0], (Object)args[1]);
        }
    }

    private static class Function_Ceiling
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Ceiling() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            return new Double(BirtMath.ceiling(BirtMath.toDoubleValue(args[0]), BirtMath.toDoubleValue(args[1])));
        }
    }

    private static class Function_Divide
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Divide() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            try {
                return MathUtil.divide((Object)args[0], (Object)args[1]);
            }
            catch (ArithmeticException arithmeticException) {
                return Double.NaN;
            }
        }
    }

    private static class Function_Mod
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Mod() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            return new Double(BirtMath.mod(BirtMath.toDoubleValue(args[0]), BirtMath.toDoubleValue(args[1])));
        }
    }

    private static class Function_Multiple
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Multiple() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            return MathUtil.multiply((Object)args[0], (Object)args[1]);
        }
    }

    private static class Function_Round
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Round() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return new Double(BirtMath.round(BirtMath.toDoubleValue(args[0])));
            }
            return new Double(BirtMath.round(BirtMath.toDoubleValue(args[0]), (int)BirtMath.toDoubleValue(args[1])));
        }
    }

    private static class Function_RoundDown
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_RoundDown() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return new Double(BirtMath.roundDown(BirtMath.toDoubleValue(args[0])));
            }
            return new Double(BirtMath.roundDown(BirtMath.toDoubleValue(args[0]), (int)BirtMath.toDoubleValue(args[1])));
        }
    }

    private static class Function_RoundUp
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_RoundUp() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return new Double(BirtMath.roundUp(BirtMath.toDoubleValue(args[0])));
            }
            return new Double(BirtMath.roundUp(BirtMath.toDoubleValue(args[0]), (int)BirtMath.toDoubleValue(args[1])));
        }
    }

    private static class Function_SafeDivide
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_SafeDivide() {
            this.minParamCount = 3;
            this.maxParamCount = 3;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            return MathUtil.safeDivide((Object)args[0], (Object)args[1], (Object)args[2]);
        }
    }

    private static class Function_Subtract
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Subtract() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            return MathUtil.subtract((Object)args[0], (Object)args[1]);
        }
    }
}

