/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.command;

import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupReorderLayer;
import net.sourceforge.nattable.group.ColumnGroupUtils;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.reorder.command.ColumnReorderCommand;
import net.sourceforge.nattable.selection.SelectionLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupColumnReorderCommandHandler
extends AbstractLayerCommandHandler<ColumnReorderCommand> {
    private final ColumnGroupReorderLayer columnGroupReorderLayer;
    private final ColumnGroupModel model;

    public GroupColumnReorderCommandHandler(ColumnGroupReorderLayer columnGroupReorderLayer) {
        this.columnGroupReorderLayer = columnGroupReorderLayer;
        this.model = columnGroupReorderLayer.getModel();
    }

    @Override
    public Class<ColumnReorderCommand> getCommandClass() {
        return ColumnReorderCommand.class;
    }

    @Override
    protected boolean doCommand(ColumnReorderCommand command) {
        int fromColumnPosition = command.getFromColumnPosition();
        int toColumnPosition = command.getToColumnPosition();
        if (fromColumnPosition == -1 || toColumnPosition == -1) {
            System.err.println("Invalid reorder positions, fromPosition: " + fromColumnPosition + ", toPosition: " + toColumnPosition);
        }
        ILayer underlyingLayer = this.columnGroupReorderLayer.getUnderlyingLayer();
        int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
        int toColumnIndex = underlyingLayer.getColumnIndexByPosition(toColumnPosition);
        SelectionLayer.MoveDirectionEnum moveDirection = ColumnGroupUtils.getMoveDirection(fromColumnPosition, toColumnPosition);
        String leftEdgeGroupName = null;
        String rightEdgeGroupName = null;
        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
            rightEdgeGroupName = this.movedToLeftEdgeOfAGroup(toColumnPosition, toColumnIndex);
        }
        if (SelectionLayer.MoveDirectionEnum.LEFT == moveDirection) {
            leftEdgeGroupName = this.movedToRightEdgeOfAGroup(toColumnPosition, toColumnIndex);
        }
        if (this.updateModel(fromColumnIndex, toColumnIndex, leftEdgeGroupName, rightEdgeGroupName)) {
            return underlyingLayer.doCommand(command);
        }
        return false;
    }

    private boolean updateModel(int fromColumnIndex, int toColumnIndex, String leftEdgeGroupName, String rightEdgeGroupName) {
        if (rightEdgeGroupName != null) {
            return this.model.isPartOfAGroup(fromColumnIndex) ? this.model.removeColumnFromGroup(fromColumnIndex) : true;
        }
        if (leftEdgeGroupName != null) {
            boolean removed = true;
            if (this.model.isPartOfAGroup(fromColumnIndex)) {
                removed = this.model.removeColumnFromGroup(fromColumnIndex);
            }
            return removed && this.model.insertColumnIndexes(leftEdgeGroupName, fromColumnIndex);
        }
        if (this.model.isPartOfAGroup(toColumnIndex) && !this.model.isPartOfAGroup(fromColumnIndex)) {
            String groupName = this.model.getColumnGroupNameForIndex(toColumnIndex);
            return this.model.insertColumnIndexes(groupName, fromColumnIndex);
        }
        if (this.model.isPartOfAGroup(fromColumnIndex) && !this.model.isPartOfAGroup(toColumnIndex)) {
            return this.model.removeColumnFromGroup(fromColumnIndex);
        }
        if (this.model.isPartOfAGroup(toColumnIndex) && this.model.isPartOfAGroup(fromColumnIndex)) {
            String toGroupName = this.model.getColumnGroupNameForIndex(toColumnIndex);
            String fromGroupName = this.model.getColumnGroupNameForIndex(fromColumnIndex);
            if (fromGroupName.equals(toGroupName)) {
                return true;
            }
            return this.model.removeColumnFromGroup(fromColumnIndex) && this.model.insertColumnIndexes(toGroupName, fromColumnIndex);
        }
        return true;
    }

    private String movedToRightEdgeOfAGroup(int dropColumnPosition, int dropColumnIndex) {
        if (ColumnGroupUtils.isRightEdgeOfAColumnGroup(this.columnGroupReorderLayer, dropColumnPosition, dropColumnIndex, this.model)) {
            return this.model.getColumnGroupNameForIndex(dropColumnIndex);
        }
        return null;
    }

    private String movedToLeftEdgeOfAGroup(int dropColumnPosition, int dropColumnIndex) {
        if (ColumnGroupUtils.isLeftEdgeOfAColumnGroup(this.columnGroupReorderLayer, dropColumnPosition, dropColumnIndex, this.model)) {
            return this.model.getColumnGroupNameForIndex(dropColumnIndex);
        }
        return null;
    }
}

