/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.editor;

import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ICellEditHandler;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.style.IStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCellEditor
implements ICellEditor {
    private boolean closed;
    private Composite parent;
    private ICellEditHandler editHandler;
    private IDisplayConverter displayConverter;
    private IStyle cellStyle;
    private IDataValidator dataValidator;
    private int columnIndex;
    private int rowIndex;

    public final Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue, IDisplayConverter displayConverter, IStyle cellStyle, IDataValidator dataValidator, ICellEditHandler editHandler, int columnIndex, int rowIndex) {
        this.closed = false;
        this.parent = parent;
        this.editHandler = editHandler;
        this.displayConverter = displayConverter;
        this.cellStyle = cellStyle;
        this.dataValidator = dataValidator;
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        return this.activateCell(parent, originalCanonicalValue, initialEditValue);
    }

    protected abstract Control activateCell(Composite var1, Object var2, Character var3);

    protected boolean validateCanonicalValue() {
        if (this.dataValidator != null) {
            return this.dataValidator.validate(this.columnIndex, this.rowIndex, this.getCanonicalValue());
        }
        return true;
    }

    protected IDisplayConverter getDataTypeConverter() {
        return this.displayConverter;
    }

    protected IStyle getCellStyle() {
        return this.cellStyle;
    }

    protected IDataValidator getDataValidator() {
        return this.dataValidator;
    }

    protected final boolean commit(SelectionLayer.MoveDirectionEnum direction) {
        return this.commit(direction, true);
    }

    protected final boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        if (this.editHandler != null && this.validateCanonicalValue()) {
            return this.editHandler.commit(direction, closeAfterCommit);
        }
        return false;
    }

    public void close() {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.forceFocus();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

