/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.transformation.batch;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.api.GenericQueryGroup;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ConflictSetIterator;
import org.eclipse.viatra.transformation.evm.api.IExecutor;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ScopedConflictSet;
import org.eclipse.viatra.transformation.runtime.emf.filters.MatchParameterFilter;
import org.eclipse.viatra.transformation.runtime.emf.rules.BatchTransformationRuleGroup;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformation;

public class BatchTransformationStatements {
    private static final String FIRE_ONE_TRANSACTION_FILTER_RULE_NAME = "Fire_one_transaction_filter_ruleName: ";
    private static final String FIRE_ONE_TRANSACTION_RULE_NAME = "Fire_one_transaction_ruleName: ";
    private static final String FIRE_UNTIL_TRANSACTION_CONDITION_RULE_NAME = "Fire_until_transaction_condition_ruleName: ";
    private static final String FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME = "Fire_until_transaction_filter_condition_ruleName: ";
    private static final String FIRE_UNTIL_TRANSACTION_CONDITION_RULE_GROUP = "Fire_until_transaction_condition_ruleGroup";
    private static final String FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_NAME = "Fire_while_possible_transaction_ruleName: ";
    private static final String FIRE_WHILE_POSSIBLE_TRANSACTION_FILTER_RULE_NAME = "Fire_while_possible_transaction_filter_ruleName: ";
    private static final String FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_GROUP = "Fire_while_possible_transaction_ruleGroup";
    private static final String FIRE_ALL_CURRENT_TRANSACTION_RULE_NAME = "Fire_all_current_transaction_ruleName: ";
    private static final String FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME = "Fire_all_current_transaction_filter_ruleName: ";
    private final ViatraQueryEngine queryEngine;
    private final RuleEngine ruleEngine;
    private final IExecutor executor;

    BatchTransformationStatements(BatchTransformation transformation, IExecutor executor) {
        this.ruleEngine = transformation.ruleEngine;
        this.executor = executor;
        this.queryEngine = transformation.queryEngine;
    }

    public <Match extends IPatternMatch> void fireUntil(BatchTransformationRule<Match, ?> rule, Predicate<Match> breakCondition) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_NAME + rule.getName());
        this.fireUntil(rule.getRuleSpecification(), breakCondition, rule.getRuleSpecification().createEmptyFilter());
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_NAME + rule.getName());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> void fireUntil(BatchTransformationRule<Match, ?> rule, Predicate<Match> breakCondition, Map.Entry<String, ?> ... filterParameters) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
        this.fireUntil(rule.getRuleSpecification(), breakCondition, new MatchParameterFilter(filterParameters));
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireUntil(BatchTransformationRule<Match, ?> rule, Predicate<Match> breakCondition, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
        this.fireUntil(rule.getRuleSpecification(), breakCondition, filter);
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
    }

    public void fireUntil(BatchTransformationRuleGroup rules, Predicate<IPatternMatch> breakCondition) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_GROUP);
        this.registerRules(rules);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(rules.getFilteredRuleMap());
        this.fireUntil(conflictSet, breakCondition);
        conflictSet.dispose();
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_GROUP);
    }

    public <Match extends IPatternMatch> void fireWhilePossible(BatchTransformationRule<Match, ?> rule) {
        this.executor.startExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_NAME + rule.getName());
        this.fireUntil(rule, (Match it) -> false);
        this.executor.endExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireWhilePossible(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireUntil(rule, (Match it) -> false, filter);
        this.executor.endExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    public void fireWhilePossible(BatchTransformationRuleGroup rules) {
        this.executor.startExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_GROUP);
        this.fireUntil(rules, (IPatternMatch it) -> false);
        this.executor.endExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_GROUP);
    }

    public <Match extends IPatternMatch> void fireAllCurrent(BatchTransformationRule<Match, ?> rule) {
        this.executor.startExecution(FIRE_ALL_CURRENT_TRANSACTION_RULE_NAME + rule.getName());
        this.fireAllCurrent(rule.getRuleSpecification(), rule.getRuleSpecification().createEmptyFilter());
        this.executor.endExecution(FIRE_ALL_CURRENT_TRANSACTION_RULE_NAME + rule.getName());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> void fireAllCurrent(BatchTransformationRule<Match, ?> rule, Map.Entry<String, ?> ... parameterFilter) {
        this.executor.startExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireAllCurrent(rule.getRuleSpecification(), new MatchParameterFilter(parameterFilter));
        this.executor.endExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireAllCurrent(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireAllCurrent(rule.getRuleSpecification(), filter);
        this.executor.endExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> boolean registerRule(RuleSpecification<Match> ruleSpecification) {
        return this.registerRule(ruleSpecification, ruleSpecification.createEmptyFilter());
    }

    public <Match extends IPatternMatch> boolean registerRule(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        return this.ruleEngine.addRule(ruleSpecification, filter);
    }

    public void registerRules(BatchTransformationRuleGroup rules) {
        Set preconditions = rules.stream().filter(Objects::nonNull).map(BatchTransformationRule::getPrecondition).collect(Collectors.toSet());
        GenericQueryGroup.of(preconditions).prepare(this.queryEngine);
        rules.stream().filter(Objects::nonNull).forEach(it -> {
            boolean bl = this.ruleEngine.addRule(it.getRuleSpecification(), it.getFilter());
        });
    }

    public <Match extends IPatternMatch> int countAllCurrent(BatchTransformationRule<Match, ?> rule) {
        return this.countAllCurrent(rule.getRuleSpecification(), rule.getRuleSpecification().createEmptyFilter());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> int countAllCurrent(BatchTransformationRule<Match, ?> rule, Map.Entry<String, ?> ... parameterFilter) {
        return this.countAllCurrent(rule.getRuleSpecification(), new MatchParameterFilter(parameterFilter));
    }

    public <Match extends IPatternMatch> int countAllCurrent(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        return this.countAllCurrent(rule.getRuleSpecification(), filter);
    }

    public <Match extends IPatternMatch> boolean disposeRule(RuleSpecification<Match> ruleSpecification) {
        return this.disposeRule(ruleSpecification, ruleSpecification.createEmptyFilter());
    }

    public <Match extends IPatternMatch> boolean disposeRule(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        return this.ruleEngine.removeRule(ruleSpecification, filter);
    }

    public void disposeRules(BatchTransformationRuleGroup rules) {
        rules.stream().filter(Objects::nonNull).forEach(it -> {
            boolean bl = this.ruleEngine.removeRule(it.getRuleSpecification(), it.getFilter());
        });
    }

    public <Match extends IPatternMatch> void fireOne(BatchTransformationRule<Match, ?> rule) {
        this.executor.startExecution(FIRE_ONE_TRANSACTION_RULE_NAME + rule.getName());
        this.fireOne(rule.getRuleSpecification(), rule.getRuleSpecification().createEmptyFilter());
        this.executor.endExecution(FIRE_ONE_TRANSACTION_RULE_NAME + rule.getName());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> void fireOne(BatchTransformationRule<Match, ?> rule, Map.Entry<String, ?> ... parameterFilter) {
        this.executor.startExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireOne(rule.getRuleSpecification(), new MatchParameterFilter(parameterFilter));
        this.executor.endExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireOne(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireOne(rule.getRuleSpecification(), filter);
        this.executor.endExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    private <Match extends IPatternMatch> boolean fireOne(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        this.registerRule(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        conflictSet.getConflictingActivations().stream().findFirst().ifPresent(head -> this.executor.execute(Collections.singleton(head).iterator()));
        conflictSet.dispose();
        return this.disposeRule(ruleSpecification, filter);
    }

    private <Match extends IPatternMatch> boolean fireAllCurrent(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        this.registerRule(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        this.executor.execute(conflictSet.getConflictingActivations().iterator());
        conflictSet.dispose();
        return this.disposeRule(ruleSpecification, filter);
    }

    private <Match extends IPatternMatch> int countAllCurrent(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        this.registerRule(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        int count = conflictSet.getConflictingActivations().size();
        conflictSet.dispose();
        this.disposeRule(ruleSpecification, filter);
        return count;
    }

    private <Match extends IPatternMatch> boolean fireUntil(RuleSpecification<Match> ruleSpecification, Predicate<Match> breakCondition, EventFilter<? super Match> filter) {
        this.registerRule(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        this.executor.execute((Iterator)new ConflictSetIterator((ConflictSet)this.ruleEngine.createScopedConflictSet(ruleSpecification, filter), breakCondition));
        conflictSet.dispose();
        return this.disposeRule(ruleSpecification, filter);
    }

    private <Match extends IPatternMatch> void fireUntil(ScopedConflictSet conflictSet, Predicate<Match> breakCondition) {
        this.executor.execute((Iterator)new ConflictSetIterator((ConflictSet)conflictSet, breakCondition));
    }
}

