/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.browser.ViatraQueryToolingBrowserPlugin;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
public class QueryRegistryTreeEntry {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final QueryRegistryTreePackage parent;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final IQuerySpecificationRegistryEntry entry;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean isLoaded = false;

    public boolean load() {
        boolean _not;
        boolean _isLoaded = this.isLoaded();
        boolean bl = _not = !_isLoaded;
        if (_not) {
            try {
                IQuerySpecification specification = (IQuerySpecification)this.entry.get();
                if (specification != null) {
                    this.isLoaded = true;
                }
                return true;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    String logMessage = String.format("Query Registry has encountered an error during loading of query %s: %s", this.entry.getFullyQualifiedName(), ex.getMessage());
                    ILog _log = ViatraQueryToolingBrowserPlugin.getDefault().getLog();
                    String _symbolicName = ViatraQueryGUIPlugin.getDefault().getBundle().getSymbolicName();
                    Status _status = new Status(4, _symbolicName, logMessage, (Throwable)ex);
                    _log.log((IStatus)_status);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return false;
    }

    public String getSimpleName() {
        String _xblockexpression = null;
        String fqn = this.entry.getFullyQualifiedName();
        int lastDotIndex = fqn.lastIndexOf(".");
        String _xifexpression = null;
        if (lastDotIndex <= 0 || lastDotIndex >= fqn.length()) {
            return fqn;
        }
        _xifexpression = fqn.substring(lastDotIndex + 1, fqn.length());
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getPackageName() {
        String _xblockexpression = null;
        String fqn = this.entry.getFullyQualifiedName();
        int lastDotIndex = fqn.lastIndexOf(".");
        String _xifexpression = null;
        if (lastDotIndex <= 0 || lastDotIndex >= fqn.length()) {
            return fqn;
        }
        _xifexpression = fqn.substring(0, fqn.lastIndexOf("."));
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Pure
    public QueryRegistryTreePackage getParent() {
        return this.parent;
    }

    @Pure
    public IQuerySpecificationRegistryEntry getEntry() {
        return this.entry;
    }

    @Pure
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public QueryRegistryTreeEntry(QueryRegistryTreePackage parent, IQuerySpecificationRegistryEntry entry) {
        this.parent = parent;
        this.entry = entry;
    }
}

