/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.addon.validation.core.ValidationEngine;
import org.eclipse.viatra.addon.validation.core.api.IConstraint;
import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;
import org.eclipse.viatra.addon.validation.core.api.IValidationEngine;
import org.eclipse.viatra.addon.validation.core.api.IViolation;
import org.eclipse.viatra.addon.validation.core.listeners.ConstraintListener;
import org.eclipse.viatra.addon.validation.runtime.ConstraintExtensionRegistry;
import org.eclipse.viatra.addon.validation.runtime.MarkerManagerViolationListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class ConstraintAdapter {
    private Map<IPatternMatch, IMarker> markerMap;
    private Map<IViolation, IMarker> violationMarkerMap;
    private IResource resourceForEditor;
    private IValidationEngine engine;
    private Logger logger;

    public ConstraintAdapter(IEditorPart editorPart, Notifier notifier, Logger logger) {
        this.logger = logger;
        this.resourceForEditor = this.getIResourceForEditor(editorPart);
        this.markerMap = new HashMap<IPatternMatch, IMarker>();
        this.violationMarkerMap = new HashMap<IViolation, IMarker>();
        try {
            ViatraQueryEngine queryEngine = ViatraQueryEngine.on((QueryScope)new EMFScope(notifier));
            this.engine = ValidationEngine.builder().setEngine(queryEngine).setLogger(logger).build();
            this.engine.initialize();
            MarkerManagerViolationListener markerManagerViolationListener = new MarkerManagerViolationListener(logger, this);
            Set<IConstraintSpecification> constraintSpecificationsForEditorId = ConstraintExtensionRegistry.getConstraintSpecificationsForEditorId(editorPart.getSite().getId());
            for (IConstraintSpecification constraint : constraintSpecificationsForEditorId) {
                IConstraint coreConstraint = this.engine.addConstraintSpecification(constraint);
                coreConstraint.addListener((ConstraintListener)markerManagerViolationListener);
            }
        }
        catch (ViatraQueryException e) {
            logger.error((Object)String.format("Exception occured during validation initialization: %s", e.getMessage()), (Throwable)e);
        }
    }

    private IResource getIResourceForEditor(IEditorPart editorPart) {
        Object o;
        IEditorInput input = editorPart.getEditorInput();
        IResource resource = null;
        if (input != null && (o = input.getAdapter(IFile.class)) instanceof IResource) {
            resource = (IResource)o;
        }
        return resource;
    }

    public void dispose() {
        for (IMarker marker : this.violationMarkerMap.values()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                this.logger.error((Object)String.format("Exception occured when removing a marker on dispose: %s", e.getMessage()), (Throwable)e);
            }
        }
        this.engine.dispose();
    }

    public IMarker getMarker(IPatternMatch match) {
        return this.markerMap.get(match);
    }

    public IMarker addMarker(IPatternMatch match, IMarker marker) {
        return this.markerMap.put(match, marker);
    }

    public IMarker removeMarker(IPatternMatch match) {
        return this.markerMap.remove(match);
    }

    public IMarker getMarker(IViolation violation) {
        return this.violationMarkerMap.get(violation);
    }

    public IMarker addMarker(IViolation violation, IMarker marker) {
        return this.violationMarkerMap.put(violation, marker);
    }

    public IMarker removeMarker(IViolation violation) {
        return this.violationMarkerMap.remove(violation);
    }

    protected IResource getResourceForEditor() {
        return this.resourceForEditor;
    }
}

