/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.DownloadTraceHttpHelper;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceDownloadStatus;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceFileSystemElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceValidateAndImportOperation;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class HttpTraceImportOperation
extends WorkspaceModifyOperation {
    private static final String TRACE_HTTP_IMPORT_TEMP_FOLDER = ".traceHttpImport";
    private final Collection<String> fSourceUrl;
    private final TmfTraceFolder fDestinationFolder;

    public HttpTraceImportOperation(String sourceUrl, TmfTraceFolder destFolder) {
        this.fSourceUrl = Collections.singletonList(sourceUrl);
        this.fDestinationFolder = destFolder;
    }

    public HttpTraceImportOperation(Collection<String> sourceUrl, TmfTraceFolder destFolder) {
        this.fSourceUrl = sourceUrl;
        this.fDestinationFolder = destFolder;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        int importOptionFlags = 26;
        IFolder tempDestination = this.fDestinationFolder.getProject().getResource().getFolder(TRACE_HTTP_IMPORT_TEMP_FOLDER);
        String tempDestinationFolderPath = tempDestination.getLocation().toOSString();
        if (tempDestination.exists()) {
            tempDestination.delete(true, monitor);
        }
        tempDestination.create(4096, true, monitor);
        ArrayList<File> downloadedTraceList = new ArrayList<File>();
        TraceDownloadStatus status = DownloadTraceHttpHelper.downloadTraces(this.fSourceUrl, tempDestinationFolderPath);
        if (status.isOk()) {
            List<TraceDownloadStatus> children = status.getChildren();
            for (TraceDownloadStatus traceDownloadStatus : children) {
                downloadedTraceList.add(traceDownloadStatus.getDownloadedFile());
            }
        } else if (status.isTimeout()) {
            if (tempDestination.exists()) {
                tempDestination.delete(true, monitor);
            }
            throw new InterruptedException();
        }
        boolean isArchive = false;
        if (!downloadedTraceList.isEmpty()) {
            isArchive = ArchiveUtil.isArchiveFile((File)downloadedTraceList.get(0));
        }
        FileSystemObjectImportStructureProvider provider = null;
        IFileSystemObject object = null;
        String archiveFolderName = null;
        if (isArchive) {
            File downloadedTrace = (File)downloadedTraceList.get(0);
            Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> rootObjectAndProvider = ArchiveUtil.getRootObjectAndProvider(downloadedTrace, null);
            provider = (FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond();
            object = (IFileSystemObject)rootObjectAndProvider.getFirst();
            archiveFolderName = downloadedTrace.getName();
        } else {
            provider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
            object = provider.getIFileSystemObject(new File(tempDestinationFolderPath));
        }
        TraceFileSystemElement root = TraceFileSystemElement.createRootTraceFileElement(object, provider);
        ArrayList<TraceFileSystemElement> fileSystemElements = new ArrayList<TraceFileSystemElement>();
        root.getAllChildren(fileSystemElements);
        Path sourceContainerPath = new Path(tempDestinationFolderPath);
        IPath destinationContainerPath = this.fDestinationFolder.getPath();
        TraceValidateAndImportOperation validateAndImportOperation = new TraceValidateAndImportOperation(null, fileSystemElements, null, (IPath)sourceContainerPath, destinationContainerPath, isArchive, importOptionFlags, this.fDestinationFolder, null, null, archiveFolderName, false);
        validateAndImportOperation.run(monitor);
        if (tempDestination.exists()) {
            tempDestination.delete(true, monitor);
        }
    }
}

