/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.ITmfXmlSchemaParser;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfAnalysisModuleHelperXml;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleSource;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlAnalysisModuleSource
implements IAnalysisModuleSource {
    private static final IPath XML_DIRECTORY_LEGACY = Activator.getDefault().getStateLocation().removeLastSegments(1).append("org.eclipse.linuxtools.tmf.analysis.xml.core").append("xml_files");
    private static List<@NonNull IAnalysisModuleHelper> fModules = null;

    public synchronized Iterable<IAnalysisModuleHelper> getAnalysisModules() {
        List<@NonNull IAnalysisModuleHelper> modules = fModules;
        if (modules == null) {
            fModules = modules = new ArrayList<IAnalysisModuleHelper>();
            XmlAnalysisModuleSource.populateBuiltinModules();
            XmlAnalysisModuleSource.populateAnalysisModules();
        }
        return modules;
    }

    private static void processFile(@NonNull File xmlFile) {
        if (!XmlUtils.xmlValidate(xmlFile).isOK()) {
            return;
        }
        try {
            Document doc = XmlUtils.getDocumentFromFile(xmlFile);
            NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
            int i = 0;
            while (i < stateproviderNodes.getLength()) {
                Element node = (Element)stateproviderNodes.item(i);
                TmfAnalysisModuleHelperXml helper = new TmfAnalysisModuleHelperXml(xmlFile, node, TmfAnalysisModuleHelperXml.XmlAnalysisModuleType.STATE_SYSTEM);
                fModules.add(helper);
                ++i;
            }
            NodeList patternNodes = doc.getElementsByTagName("pattern");
            int i2 = 0;
            while (i2 < patternNodes.getLength()) {
                Element node = (Element)patternNodes.item(i2);
                TmfAnalysisModuleHelperXml helper = new TmfAnalysisModuleHelperXml(xmlFile, node, TmfAnalysisModuleHelperXml.XmlAnalysisModuleType.PATTERN);
                fModules.add(helper);
                ++i2;
            }
            Collection<ITmfXmlSchemaParser> extraSchemaParsers = XmlUtils.getExtraSchemaParsers();
            for (ITmfXmlSchemaParser parser : extraSchemaParsers) {
                fModules.addAll(parser.getModuleHelpers(xmlFile, doc));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError("Error opening XML file", e);
        }
    }

    private static void populateBuiltinModules() {
        Map<String, IPath> files = XmlUtils.listBuiltinFiles();
        for (IPath xmlPath : files.values()) {
            XmlAnalysisModuleSource.processFile((File)NonNullUtils.checkNotNull((Object)xmlPath.toFile()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void populateAnalysisModules() {
        IPath pathToFiles = XmlUtils.getXmlFilesPath();
        File folder = pathToFiles.toFile();
        if (!folder.isDirectory()) return;
        if (!folder.exists()) {
            return;
        }
        File oldFolder = XML_DIRECTORY_LEGACY.toFile();
        File[] oldAnalysisFiles = oldFolder.listFiles();
        if (oldAnalysisFiles != null) {
            File[] fileArray = oldAnalysisFiles;
            int n = oldAnalysisFiles.length;
            int n2 = 0;
            while (n2 < n) {
                block33: {
                    File fromFile = fileArray[n2];
                    File toFile = pathToFiles.append(fromFile.getName()).toFile();
                    if (!toFile.exists() && !fromFile.isDirectory()) {
                        try {
                            Throwable throwable = null;
                            Object var10_14 = null;
                            try {
                                FileInputStream fis = new FileInputStream(fromFile);
                                try {
                                    block32: {
                                        FileOutputStream fos = new FileOutputStream(toFile);
                                        try {
                                            block31: {
                                                FileChannel source = fis.getChannel();
                                                try {
                                                    try (FileChannel destination = fos.getChannel();){
                                                        destination.transferFrom(source, 0L, source.size());
                                                    }
                                                    if (source == null) break block31;
                                                }
                                                catch (Throwable throwable2) {
                                                    if (throwable == null) {
                                                        throwable = throwable2;
                                                    } else if (throwable != throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                    if (source == null) throw throwable;
                                                    source.close();
                                                    throw throwable;
                                                }
                                                source.close();
                                            }
                                            if (fos == null) break block32;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable == null) {
                                                throwable = throwable3;
                                            } else if (throwable != throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            if (fos == null) throw throwable;
                                            fos.close();
                                            throw throwable;
                                        }
                                        fos.close();
                                    }
                                    if (fis == null) break block33;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    if (fis == null) throw throwable;
                                    fis.close();
                                    throw throwable;
                                }
                                fis.close();
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                    throw throwable;
                                }
                                if (throwable == throwable5) throw throwable;
                                throwable.addSuppressed(throwable5);
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            String error = Messages.XmlUtils_ErrorCopyingFile;
                            Activator.logError(error, e);
                        }
                    }
                }
                ++n2;
            }
        }
        Map<String, @NonNull File> files = XmlUtils.getEnabledFiles();
        Iterator<File> iterator = files.values().iterator();
        while (iterator.hasNext()) {
            File xmlFile = iterator.next();
            XmlAnalysisModuleSource.processFile(xmlFile);
        }
        return;
    }

    public static void notifyModuleChange() {
        fModules = null;
        TmfAnalysisManager.refreshModules();
    }
}

