/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathAlgorithmException;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.AbstractCriticalPathAlgorithm;

public class CriticalPathAlgorithmBounded
extends AbstractCriticalPathAlgorithm {
    public CriticalPathAlgorithmBounded(TmfGraph graph) {
        super(graph);
    }

    @Override
    public TmfGraph compute(TmfVertex start, @Nullable TmfVertex end) throws CriticalPathAlgorithmException {
        TmfGraph criticalPath = new TmfGraph();
        TmfGraph graph = this.getGraph();
        IGraphWorker parent = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(start));
        criticalPath.add(parent, new TmfVertex(start));
        TmfVertex currentVertex = start;
        TmfEdge nextEdge = currentVertex.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        long endTime = Long.MAX_VALUE;
        if (end != null) {
            endTime = end.getTs();
        }
        while (nextEdge != null) {
            TmfVertex nextVertex = nextEdge.getVertexTo();
            if (nextVertex.getTs() >= endTime) break;
            switch (nextEdge.getType()) {
                case RUNNING: 
                case INTERRUPTED: 
                case PREEMPTED: 
                case TIMER: 
                case USER_INPUT: 
                case BLOCK_DEVICE: 
                case IPI: {
                    IGraphWorker parentTo = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(nextEdge.getVertexTo()));
                    if (parentTo != parent) {
                        throw new CriticalPathAlgorithmException("no, the parents of horizontal edges are not always identical... shouldn't they be?");
                    }
                    criticalPath.append(parentTo, new TmfVertex(nextEdge.getVertexTo()), nextEdge.getType(), nextEdge.getLinkQualifier());
                    break;
                }
                case BLOCKED: 
                case NETWORK: {
                    List<TmfEdge> links = this.resolveBlockingBounded(nextEdge, nextEdge.getVertexFrom());
                    Collections.reverse(links);
                    this.appendPathComponent(criticalPath, graph, currentVertex, links);
                    break;
                }
                case EPS: {
                    if (nextEdge.getDuration() == 0L) break;
                    throw new CriticalPathAlgorithmException("epsilon duration is not zero " + nextEdge);
                }
                case DEFAULT: {
                    throw new CriticalPathAlgorithmException("Illegal link type " + (Object)((Object)nextEdge.getType()));
                }
            }
            currentVertex = nextVertex;
            nextEdge = currentVertex.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        }
        return criticalPath;
    }

    private void appendPathComponent(TmfGraph criticalPath, TmfGraph graph, TmfVertex currentVertex, List<TmfEdge> links) {
        IGraphWorker currentActor = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(currentVertex));
        if (links.isEmpty()) {
            TmfEdge next = currentVertex.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
            if (next == null) {
                return;
            }
            criticalPath.append(currentActor, new TmfVertex(next.getVertexTo()), next.getType(), next.getLinkQualifier());
            return;
        }
        TmfVertex b1 = (TmfVertex)NonNullUtils.checkNotNull((Object)criticalPath.getTail(currentActor));
        TmfEdge lnk = links.get(0);
        TmfVertex anchor = null;
        IGraphWorker objSrc = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(lnk.getVertexFrom()));
        if (objSrc.equals(currentActor)) {
            anchor = b1;
        } else {
            anchor = new TmfVertex(currentVertex);
            criticalPath.add(objSrc, anchor);
            b1.linkVertical(anchor);
            if (lnk.getVertexFrom().compareTo(anchor) > 0) {
                anchor = new TmfVertex(lnk.getVertexFrom());
                TmfEdge edge = (TmfEdge)NonNullUtils.checkNotNull((Object)criticalPath.append(objSrc, anchor));
                edge.setType(TmfEdge.EdgeType.UNKNOWN);
            }
        }
        TmfEdge prev = null;
        for (TmfEdge link : links) {
            if (prev != null && prev.getVertexTo() != link.getVertexFrom()) {
                anchor = this.copyLink(criticalPath, graph, anchor, prev.getVertexTo(), link.getVertexFrom(), prev.getVertexTo().getTs(), TmfEdge.EdgeType.DEFAULT, link.getLinkQualifier());
            }
            anchor = this.copyLink(criticalPath, graph, anchor, link.getVertexFrom(), link.getVertexTo(), link.getVertexTo().getTs(), link.getType(), link.getLinkQualifier());
            prev = link;
        }
    }

    private List<TmfEdge> resolveBlockingBounded(TmfEdge blocking, TmfVertex bound) {
        LinkedList<TmfEdge> subPath = new LinkedList<TmfEdge>();
        TmfVertex junction = CriticalPathAlgorithmBounded.findIncoming(blocking.getVertexTo(), TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        if (junction == null) {
            return subPath;
        }
        TmfEdge down = (TmfEdge)NonNullUtils.checkNotNull((Object)junction.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
        subPath.add(down);
        TmfVertex vertexFrom = down.getVertexFrom();
        TmfVertex currentBound = bound.compareTo(blocking.getVertexFrom()) < 0 ? blocking.getVertexFrom() : bound;
        Stack<TmfVertex> stack = new Stack<TmfVertex>();
        while (vertexFrom != null && vertexFrom.compareTo(currentBound) > 0) {
            TmfEdge inVerticalEdge = vertexFrom.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
            if (inVerticalEdge != null && inVerticalEdge.getVertexFrom().compareTo(currentBound) <= 0) {
                subPath.add(inVerticalEdge);
                break;
            }
            TmfEdge incomingEdge = vertexFrom.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
            if (inVerticalEdge != null && (incomingEdge == null || incomingEdge.getType() != TmfEdge.EdgeType.BLOCKED && incomingEdge.getType() != TmfEdge.EdgeType.NETWORK)) {
                stack.push(vertexFrom);
            }
            if (incomingEdge != null) {
                if (incomingEdge.getType() == TmfEdge.EdgeType.BLOCKED || incomingEdge.getType() == TmfEdge.EdgeType.NETWORK) {
                    subPath.addAll(this.resolveBlockingBounded(incomingEdge, currentBound));
                } else {
                    subPath.add(incomingEdge);
                }
                vertexFrom = incomingEdge.getVertexFrom();
                continue;
            }
            if (!stack.isEmpty()) {
                TmfVertex v = (TmfVertex)stack.pop();
                while (!subPath.isEmpty() && subPath.getLast().getVertexFrom() != v) {
                    subPath.removeLast();
                }
                TmfEdge edge = v.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
                if (edge != null) {
                    subPath.add(edge);
                    vertexFrom = edge.getVertexFrom();
                    continue;
                }
            }
            vertexFrom = null;
        }
        return subPath;
    }
}

