/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.base.relations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sirius.ext.base.Messages;
import org.eclipse.sirius.ext.base.relations.Relation;

public class TransitiveClosure<T>
implements Relation<T> {
    private final Relation<T> relation;

    public TransitiveClosure(Relation<T> relation) {
        this.relation = (Relation)Preconditions.checkNotNull(relation);
    }

    @Override
    public Set<T> apply(T from) {
        Preconditions.checkNotNull(from);
        HashSet result = Sets.newHashSet(this.relation.apply(from));
        Object startingPoints = ImmutableSet.copyOf((Collection)result);
        while (!startingPoints.isEmpty()) {
            HashSet<T> newDependencies = new HashSet<T>();
            for (Object startPoint : startingPoints) {
                newDependencies.addAll(this.relation.apply(startPoint));
            }
            newDependencies.removeAll(result);
            result.addAll(newDependencies);
            startingPoints = newDependencies;
        }
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        return MessageFormat.format(Messages.TransitiveClosure_message, this.relation);
    }
}

