/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.keyboard;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.keyboard.internal.ModifierKeysBinding;

public class DefaultKeyboardLayout {
    private static DefaultKeyboardLayout instance = null;
    private static Map<Character, int[]> keyMap;
    private static Toolkit toolkit;

    public DefaultKeyboardLayout() {
        ClassLoader classLoader = DefaultKeyboardLayout.class.getClassLoader();
        InputStream in = classLoader.getResourceAsStream(String.valueOf(this.toFolder(String.valueOf(this.myPackage()) + "/default")) + ".keyboard");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SWTLayerException("Unable to parse keyboard layout config file", e);
        }
        try {
            this.loadKeyboardLayoutFile(br);
        }
        catch (IOException e) {
            throw new SWTLayerException("Unable to parse keyboard layout config file", e);
        }
    }

    public static DefaultKeyboardLayout getInstance() {
        if (instance == null) {
            instance = new DefaultKeyboardLayout();
        }
        return instance;
    }

    public int[] getKeyCombination(char c) {
        if (c > '`' && c < '{') {
            if (DefaultKeyboardLayout.isCapsLockOn()) {
                return new int[]{131072, c};
            }
            return new int[]{c};
        }
        if (c > '@' && c < '[') {
            if (DefaultKeyboardLayout.isCapsLockOn()) {
                return new int[]{c + 32};
            }
            return new int[]{131072, c + 32};
        }
        if (keyMap.containsKey(Character.valueOf(c))) {
            return keyMap.get(Character.valueOf(c));
        }
        return new int[]{c};
    }

    private void loadKeyboardLayoutFile(BufferedReader in) throws IOException {
        String line;
        keyMap = new HashMap<Character, int[]>();
        while ((line = in.readLine()) != null) {
            char ch = line.charAt(0);
            String keystrokeString = line.substring(2).replaceAll("\\s+", "");
            int[] keyStroke = this.getKeyStroke(keystrokeString);
            keyMap.put(Character.valueOf(ch), keyStroke);
        }
        in.close();
    }

    private int[] getKeyStroke(String keystrokeString) {
        String[] split = keystrokeString.split("\\+");
        int modifierKeys = 0;
        ModifierKeysBinding modifierKeysBinding = new ModifierKeysBinding();
        int i = 0;
        while (i < split.length - 1) {
            modifierKeys |= modifierKeysBinding.getModifierKeyFromString(split[i]).intValue();
            ++i;
        }
        char naturalKey = split[split.length - 1].charAt(0);
        return new int[]{modifierKeys, naturalKey};
    }

    private String myPackage() {
        return DefaultKeyboardLayout.class.getPackage().getName();
    }

    private String toFolder(String layoutName) {
        return layoutName.replaceAll("\\.", "/");
    }

    private static boolean isCapsLockOn() {
        boolean isOn = false;
        if (toolkit == null) {
            toolkit = Toolkit.getDefaultToolkit();
        }
        try {
            isOn = toolkit.getLockingKeyState(20);
        }
        catch (HeadlessException headlessException) {}
        return isOn;
    }
}

