/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.validators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.internal.validators.ScriptValidator;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class TestCaseECLValidator
implements IQ7Validator {
    @Override
    public void validate(IQ7NamedElement element, IQ7ProblemReporter reporter, IProgressMonitor monitor) {
        block5: {
            if (!(element instanceof ITestCase)) {
                return;
            }
            if (element.exists()) {
                try {
                    Script ecl;
                    Scenario scenario = (Scenario)((ITestCase)element).getNamedElement();
                    if (scenario != null && (ecl = Scenarios.getEcl((Scenario)scenario)) != null && ecl.getContent() != null) {
                        String eclCode = ecl.getContent();
                        ScriptValidator.validateErrors(eclCode, reporter, (IFile)element.getResource());
                        ScriptValidator.validateWarnings(eclCode, reporter, (IFile)element.getResource());
                    }
                }
                catch (Throwable e) {
                    if (e instanceof IllegalArgumentException) break block5;
                    RcpttPlugin.log((Throwable)e);
                }
            }
        }
    }

    @Override
    public void reconcile(IQ7NamedElement content, String eclCode, IQ7ProblemReporter reporter, IProgressMonitor nullProgressMonitor) {
        ScriptValidator.validateErrors(eclCode, reporter, null);
        ScriptValidator.validateWarnings(eclCode, reporter, null);
    }
}

