/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleHeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculatingPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

abstract class AbstractPartialPartition
extends AbstractPartition {
    protected final boolean hasSynthesizedTrace;
    protected final @NonNull String name;
    private final @NonNull Map<@NonNull Node, @NonNull Role> node2nodeRole = new HashMap<Node, Role>();
    private final @NonNull List<@NonNull Node> nodes = new ArrayList<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull Role> edge2edgeRole = new HashMap<Edge, Role>();
    private final @NonNull ReachabilityForest reachabilityForest;
    private final @NonNull List<@NonNull Partition> explicitPredecessors = new ArrayList<Partition>();
    private @Nullable MicroMappingRegion microMappingRegion = null;

    protected AbstractPartialPartition(@NonNull MappingPartitioner partitioner, @NonNull ReachabilityForest reachabilityForest, @NonNull String suffix) {
        super(partitioner);
        this.hasSynthesizedTrace = this.scheduleManager.useActivators();
        this.name = String.valueOf(QVTscheduleUtil.getName((Nameable)this.region)) + suffix;
        this.reachabilityForest = reachabilityForest;
    }

    private void addEdge(@NonNull Edge edge, @NonNull Role newEdgeRole) {
        assert (edge.getOwningRegion() == this.region);
        Role oldEdgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        switch (oldEdgeRole) {
            case CONSTANT: {
                assert (newEdgeRole == Role.CONSTANT);
                break;
            }
            case LOADED: {
                assert (newEdgeRole == Role.LOADED);
                break;
            }
            case PREDICATED: {
                assert (newEdgeRole == Role.PREDICATED || newEdgeRole == Role.SPECULATED);
                break;
            }
            case REALIZED: {
                if (!this.partitioner.hasRealizedEdge(edge) ? !$assertionsDisabled && newEdgeRole != Role.REALIZED : (this instanceof SpeculatingPartition ? !$assertionsDisabled && newEdgeRole != Role.PREDICATED && newEdgeRole != Role.SPECULATED : !$assertionsDisabled && newEdgeRole != Role.PREDICATED)) {
                    throw new AssertionError();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".addEdge " + edge);
            }
        }
        this.partitioner.addEdge(edge, newEdgeRole, this);
        Role displacedEdgeRole = this.edge2edgeRole.put(edge, newEdgeRole);
        assert (displacedEdgeRole == null || displacedEdgeRole == newEdgeRole);
    }

    public void addExplicitPredecessor(@NonNull Partition speculationPartition) {
        this.explicitPredecessors.add(speculationPartition);
    }

    protected void addNode(@NonNull Node node) {
        Role oldNodeRole = QVTscheduleUtil.getNodeRole((Node)node);
        this.addNode(node, oldNodeRole);
    }

    protected void addNode(@NonNull Node node, @NonNull Role newNodeRole) {
        assert (node.getOwningRegion() == this.region);
        Role oldNodeRole = QVTscheduleUtil.getNodeRole((Node)node);
        switch (oldNodeRole) {
            case CONSTANT: {
                assert (newNodeRole == Role.CONSTANT);
                break;
            }
            case LOADED: {
                assert (newNodeRole == Role.LOADED);
                break;
            }
            case SPECULATED: {
                assert (newNodeRole == Role.PREDICATED || newNodeRole == Role.SPECULATED);
                break;
            }
            case PREDICATED: {
                assert (newNodeRole == Role.PREDICATED || newNodeRole == Role.SPECULATED);
                this.partitioner.addPredicatedNode(node);
                break;
            }
            case REALIZED: {
                if (!this.partitioner.hasRealizedNode(node)) {
                    this.partitioner.addRealizedNode(node);
                    break;
                }
                if (newNodeRole == Role.REALIZED || newNodeRole == Role.SPECULATION) {
                    assert (false);
                    return;
                }
                assert (newNodeRole == Role.PREDICATED || newNodeRole == Role.SPECULATED);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".addNode " + node);
            }
        }
        Role displacedNodeRole = this.node2nodeRole.put(node, newNodeRole);
        assert (displacedNodeRole == null || displacedNodeRole == newNodeRole);
        this.nodes.add(node);
    }

    protected boolean allPredecessorsAreAvailable(@NonNull Node targetNode) {
        ArrayList<@NonNull Node> requiredNodes = new ArrayList<Node>(this.nodes);
        requiredNodes.add(targetNode);
        HashMap<@NonNull Node, @NonNull Role> requiredNode2nodeRole = new HashMap<Node, Role>();
        int i = 0;
        while (i < requiredNodes.size()) {
            Node node = (Node)requiredNodes.get(i);
            assert (node != null);
            Edge traceEdge = this.partitioner.getTraceEdge(node);
            if (traceEdge == null || !this.partitioner.hasRealizedEdge(traceEdge)) {
                for (Node precedingNode : this.getPredecessors(node)) {
                    if (!this.isAvailable(node)) {
                        return false;
                    }
                    if (requiredNode2nodeRole.containsKey(precedingNode)) continue;
                    requiredNode2nodeRole.put(precedingNode, QVTscheduleUtil.getNodeRole((Node)precedingNode));
                    requiredNodes.add(precedingNode);
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void check(@NonNull MicroMappingRegion region) {
        HashSet<@NonNull Node> reachableNodes = new HashSet<Node>();
        for (Node node : QVTscheduleUtil.getHeadNodes((Region)region)) {
            this.checkGatherReachables(reachableNodes, node);
        }
        @NonNull HashSet allNodes = Sets.newHashSet((Iterable)QVTscheduleUtil.getOwnedNodes((Region)region));
        if (!reachableNodes.equals(allNodes)) {
            @NonNull HashSet extraNodesSet = Sets.newHashSet(reachableNodes);
            CompilerUtil.removeAll(extraNodesSet, allNodes);
            for (Node node : extraNodesSet) {
                this.partitioner.addProblem(CompilerUtil.createRegionWarning((Region)region, "unexpected " + node, new Object[0]));
            }
            @NonNull HashSet missingNodesSet = Sets.newHashSet((Iterable)allNodes);
            missingNodesSet.removeAll(reachableNodes);
            for (Node node : missingNodesSet) {
                if (node.isConstant() || node.isUnconditional()) continue;
                node.isUnconditional();
                this.partitioner.addProblem(CompilerUtil.createRegionWarning((Region)region, "unreachable " + node, new Object[0]));
            }
        }
    }

    private void checkGatherReachables(@NonNull Set<@NonNull Node> reachableNodes, @NonNull Node node) {
        if (node instanceof OperationNode) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isComputation() || edge.isConstant() || reachableNodes.contains(edge.getEdgeSource())) continue;
                return;
            }
        }
        if (reachableNodes.add(node)) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isCast() && !edge.isNavigation()) continue;
                this.checkGatherReachables(reachableNodes, edge.getEdgeSource());
            }
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                if (!edge.isComputation() && !edge.isCast() && !edge.isNavigation()) continue;
                this.checkGatherReachables(reachableNodes, edge.getEdgeTarget());
            }
        }
    }

    protected @NonNull MicroMappingRegion createMicroMappingRegion(@NonNull String namePrefix, @NonNull String symbolSuffix) {
        assert (this.microMappingRegion == null);
        assert (!(this.region instanceof MicroMappingRegion));
        MicroMappingRegion partialRegion = this.createPartialRegion(namePrefix, symbolSuffix);
        PartitioningVisitor partitioningVisitor = this.createPartitioningVisitor(partialRegion);
        this.region.accept((Visitor)partitioningVisitor);
        MicroMappingRegion microMappingRegion = partialRegion;
        Iterable<@NonNull Node> preferredHeadNodes = this.getPreferredHeadNodes();
        ArrayList<Node> partialPreferredHeadNodes = null;
        if (preferredHeadNodes != null) {
            partialPreferredHeadNodes = new ArrayList<Node>();
            for (Node preferredNode : preferredHeadNodes) {
                partialPreferredHeadNodes.add(partitioningVisitor.getNode(preferredNode));
            }
        }
        Iterable<@NonNull Node> headNodes = RuleHeadAnalysis.computeRuleHeadNodes(this.scheduleManager, (MappingRegion)microMappingRegion, partialPreferredHeadNodes);
        Iterables.addAll((Collection)QVTscheduleUtil.Internal.getHeadNodesList((Region)microMappingRegion), headNodes);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)microMappingRegion, null);
        }
        this.check(microMappingRegion);
        this.microMappingRegion = microMappingRegion;
        return microMappingRegion;
    }

    protected @NonNull MicroMappingRegion createPartialRegion(@NonNull String namePrefix, @NonNull String symbolSuffix) {
        MicroMappingRegion partialRegion = QVTscheduleFactory.eINSTANCE.createMicroMappingRegion();
        this.scheduleManager.addMappingRegion((MappingRegion)partialRegion);
        partialRegion.setMappingRegion((MappingRegion)this.region);
        partialRegion.setNamePrefix(namePrefix);
        partialRegion.setSymbolNameSuffix(symbolSuffix);
        partialRegion.setName(String.valueOf(namePrefix) + " " + this.region.getName());
        return partialRegion;
    }

    protected @NonNull PartitioningVisitor createPartitioningVisitor(@NonNull MicroMappingRegion partialRegion) {
        return new PartitioningVisitor(new RegionHelper<MicroMappingRegion>(this.scheduleManager, partialRegion), this);
    }

    @Override
    public @NonNull List<@NonNull Partition> getExplicitPredecessors() {
        return this.explicitPredecessors;
    }

    @Override
    public @NonNull MappingRegion getMicroMappingRegion() {
        return (MappingRegion)ClassUtil.nonNullState((Object)this.microMappingRegion);
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    protected @NonNull Iterable<@NonNull Node> getNodes() {
        return this.node2nodeRole.keySet();
    }

    @Override
    protected @NonNull Iterable<@NonNull Edge> getPartialEdges() {
        return this.edge2edgeRole.keySet();
    }

    @Override
    protected @NonNull Iterable<@NonNull Node> getPartialNodes() {
        return this.getNodes();
    }

    protected @NonNull Iterable<@NonNull Node> getPredecessors(@NonNull Node targetNode) {
        return this.reachabilityForest.getPredecessors(targetNode);
    }

    protected @Nullable Iterable<@NonNull Node> getPreferredHeadNodes() {
        return this.partitioner.getTraceNodes();
    }

    @Override
    public @Nullable Role getRole(@NonNull Edge edge) {
        return this.edge2edgeRole.get(edge);
    }

    @Override
    public @Nullable Role getRole(@NonNull Node node) {
        return this.node2nodeRole.get(node);
    }

    private boolean hasEdge(@NonNull Edge edge) {
        return this.edge2edgeRole.containsKey(edge);
    }

    protected boolean hasNode(@NonNull Node node) {
        return this.node2nodeRole.containsKey(node);
    }

    protected boolean isAvailable(@NonNull Edge edge) {
        return edge.isOld();
    }

    protected boolean isAvailable(@NonNull Node node) {
        return node.isOld();
    }

    @Override
    protected boolean isConstant(@NonNull Edge edge) {
        Role role = this.getRole(edge);
        return role != null ? role.isConstant() : false;
    }

    @Override
    protected boolean isConstant(@NonNull Node node) {
        Role role = this.getRole(node);
        return role != null ? role.isConstant() : false;
    }

    @Override
    protected boolean isLoaded(@NonNull Edge edge) {
        Role role = this.getRole(edge);
        return role != null ? role.isLoaded() : false;
    }

    @Override
    protected boolean isLoaded(@NonNull Node node) {
        Role role = this.getRole(node);
        return role != null ? role.isLoaded() : false;
    }

    @Override
    protected boolean isPredicated(@NonNull Edge edge) {
        Role role = this.getRole(edge);
        return role != null ? role.isPredicated() : false;
    }

    @Override
    protected boolean isPredicated(@NonNull Node node) {
        Role role = this.getRole(node);
        return role != null ? role.isPredicated() : false;
    }

    @Override
    protected boolean isRealized(@NonNull Edge edge) {
        Role role = this.getRole(edge);
        return role != null ? role.isRealized() : false;
    }

    @Override
    protected boolean isRealized(@NonNull Node node) {
        Role role = this.getRole(node);
        return role != null ? role.isRealized() : false;
    }

    @Override
    protected boolean isSpeculated(@NonNull Edge edge) {
        Role role = this.getRole(edge);
        return role != null ? role.isSpeculated() : false;
    }

    @Override
    protected boolean isSpeculated(@NonNull Node node) {
        Role role = this.getRole(node);
        return role != null ? role.isSpeculated() : false;
    }

    @Override
    protected boolean isSpeculation(@NonNull Node node) {
        Role role = this.getRole(node);
        return role != null ? role.isSpeculation() : false;
    }

    @Override
    public @NonNull String toString() {
        return this.getName();
    }

    protected void resolveDisambiguations() {
        for (Node traceNode : this.partitioner.getTraceNodes()) {
            TraceClassAnalysis<@NonNull RegionAnalysis> traceClassAnalysis = this.partitioner.getTraceClassAnalysis(traceNode);
            Iterable<@NonNull Property> discriminatingProperties = traceClassAnalysis.getDiscriminatingProperties();
            if (discriminatingProperties == null) continue;
            for (Property property : discriminatingProperties) {
                Node targetNode = traceNode.getNavigableTarget(property);
                assert (targetNode != null);
                if (this.hasNode(targetNode)) continue;
                this.addNode(targetNode);
            }
        }
    }

    protected abstract @Nullable Role resolveEdgeRole(@NonNull Role var1, @NonNull Edge var2, @NonNull Role var3);

    protected void resolveEdges() {
        for (Node node : this.node2nodeRole.keySet()) {
            Role edgeRole;
            Role targetNodeRole;
            Edge edge2;
            if (node.isOperation()) {
                for (Edge edge2 : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Role edgeRole2;
                    Role targetNodeRole2;
                    Role sourceNodeRole;
                    if (!edge2.isExpression() && !edge2.isNavigation() || this.hasEdge(edge2) || (sourceNodeRole = this.node2nodeRole.get(edge2.getEdgeSource())) == null || (targetNodeRole2 = this.node2nodeRole.get(edge2.getEdgeTarget())) == null || (edgeRole2 = this.resolveEdgeRole(sourceNodeRole, edge2, targetNodeRole2)) == null) continue;
                    if (edgeRole2 == Role.REALIZED && this.partitioner.hasRealizedEdge(edge2)) {
                        edgeRole2 = null;
                    }
                    if (edgeRole2 == null) continue;
                    this.addEdge(edge2, edgeRole2);
                }
                continue;
            }
            edge2 = this.reachabilityForest.getReachingEdge(node);
            if (edge2 == null || this.hasEdge(edge2)) continue;
            assert (!this.hasEdge(edge2));
            Role sourceNodeRole = this.node2nodeRole.get(edge2.getEdgeSource());
            if (sourceNodeRole == null || (targetNodeRole = this.node2nodeRole.get(edge2.getEdgeTarget())) == null || (edgeRole = this.resolveEdgeRole(sourceNodeRole, edge2, targetNodeRole)) == null) continue;
            if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge2)) {
                edgeRole = null;
            }
            if (edgeRole == null) continue;
            this.addEdge(edge2, edgeRole);
        }
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            Role edgeRole;
            Role targetNodeRole;
            Role sourceNodeRole;
            if (edge.isSecondary() || this.hasEdge(edge) || (sourceNodeRole = this.node2nodeRole.get(edge.getEdgeSource())) == null || (targetNodeRole = this.node2nodeRole.get(edge.getEdgeTarget())) == null || (edgeRole = this.resolveEdgeRole(sourceNodeRole, edge, targetNodeRole)) == null) continue;
            if (edgeRole == Role.REALIZED) {
                if (this.partitioner.hasRealizedEdge(edge)) {
                    edgeRole = null;
                }
            } else if (edge.isCast() || edge.isNavigation()) {
                if (this.partitioner.hasRealizedEdge(edge)) {
                    edgeRole = null;
                } else if (this.partitioner.hasPredicatedEdge(edge)) {
                    edgeRole = null;
                } else if (this.partitioner.hasLoadedEdge(edge)) {
                    edgeRole = null;
                } else if (this.partitioner.hasConstantEdge(edge)) {
                    edgeRole = null;
                }
            }
            if (edgeRole == null) continue;
            this.addEdge(edge, edgeRole);
        }
    }

    protected void resolvePrecedingNodes() {
        int i = 0;
        while (i < this.nodes.size()) {
            boolean hasSourceNode;
            Node node = this.nodes.get(i);
            assert (node != null);
            Edge traceEdge = this.partitioner.getTraceEdge(node);
            Node sourceNode = traceEdge != null ? QVTscheduleUtil.getSourceNode((Edge)traceEdge) : null;
            boolean bl = hasSourceNode = sourceNode != null && this.hasNode(sourceNode);
            if (traceEdge == null || !this.partitioner.hasRealizedEdge(traceEdge) || !hasSourceNode) {
                boolean gotOne = false;
                for (Node precedingNode : this.getPredecessors(node)) {
                    gotOne = true;
                    if (this.hasNode(precedingNode)) continue;
                    this.addNode(precedingNode, this.partitioner.hasRealizedNode(precedingNode) ? Role.PREDICATED : QVTscheduleUtil.getNodeRole((Node)precedingNode));
                }
                if (!gotOne && traceEdge != null && traceEdge.isRealized()) {
                    gotOne = true;
                    if (!hasSourceNode) {
                        assert (sourceNode != null);
                        this.addNode(sourceNode);
                    }
                }
            }
            ++i;
        }
    }
}

