/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractQVTb2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTcoreScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EarlyMerger;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class QVTm2QVTs
extends AbstractQVTb2QVTs {
    public QVTm2QVTs(@NonNull ProblemHandler problemHandler, @NonNull EnvironmentFactory environmentFactory, @Nullable CompilerOptions.StepOptions schedulerOptions) {
        super(new QVTcoreScheduleManager(environmentFactory, problemHandler, schedulerOptions), problemHandler);
    }

    public @NonNull Map<@NonNull ScheduledRegion, Iterable<@NonNull MappingRegion>> transform() throws IOException {
        this.scheduleManager.analyzeSourceModel();
        Iterable<@NonNull TransformationAnalysis> transformationAnalyses = this.scheduleManager.getOrderedTransformationAnalyses();
        for (TransformationAnalysis transformationAnalysis : transformationAnalyses) {
            transformationAnalysis.analyzeMappingRegions();
        }
        ContentsAnalysis<@NonNull RuleRegion> originalContentsAnalysis = this.scheduleManager.analyzeOriginalContents();
        Map<@NonNull ScheduledRegion, @NonNull Iterable<@NonNull RuleRegion>> scheduledRegion2activeRegions = this.scheduleManager.analyzeTransformations();
        for (MappingRegion ruleRegion : QVTscheduleUtil.getOwnedMappingRegions((ScheduleModel)this.scheduleManager.getScheduleModel())) {
            this.scheduleManager.writeDebugGraphs((Graphable)ruleRegion, null);
        }
        HashMap<@NonNull ScheduledRegion, @NonNull Iterable<@NonNull MappingRegion>> scheduledRegion2mergedRegions = new HashMap<ScheduledRegion, Iterable<MappingRegion>>();
        if (!this.scheduleManager.isNoEarlyMerge()) {
            for (ScheduledRegion scheduledRegion : scheduledRegion2activeRegions.keySet()) {
                Iterable<@NonNull RuleRegion> activeRegions = scheduledRegion2activeRegions.get(scheduledRegion);
                assert (activeRegions != null);
                ArrayList<@NonNull MappingRegion> mergedRegions = new ArrayList<MappingRegion>(EarlyMerger.merge(this.scheduleManager, activeRegions));
                scheduledRegion2mergedRegions.put(scheduledRegion, mergedRegions);
            }
        } else {
            for (ScheduledRegion scheduledRegion : scheduledRegion2activeRegions.keySet()) {
                Iterable<@NonNull RuleRegion> activeRegions = scheduledRegion2activeRegions.get(scheduledRegion);
                assert (activeRegions != null);
                scheduledRegion2mergedRegions.put(scheduledRegion, Lists.newArrayList(activeRegions));
            }
        }
        return scheduledRegion2mergedRegions;
    }
}

