/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.reindenter;

import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.reindenter.ReindentingVisitor;
import org.eclipse.photran.internal.core.reindenter.StartOfLine;

final class ReindentEachLineVisitor
extends ReindentingVisitor {
    private StartOfLine previousLine;
    private String previousIndentation;

    protected ReindentEachLineVisitor(IFortranAST ast, Token firstTokenInRegion, Token lastTokenInRegion) {
        super(ast, firstTokenInRegion, lastTokenInRegion);
        this.previousLine = StartOfLine.createForLastNonemptyLineAbove(this.getFirstLineToReindent(), this.ast);
        this.previousIndentation = this.previousLine == null ? "" : this.previousLine.getIndentation();
    }

    @Override
    protected void updateIndentation(StartOfLine currentLine) {
        String currentIndentation = currentLine.getIndentation();
        String newIndentation = this.computeNewIndentation(currentLine);
        currentLine.reindent(currentIndentation, newIndentation);
        if ((!currentLine.hasLabel() || this.previousLine == null || this.previousLine.startsIndentedRegion() || currentLine.endsIndentedRegion()) && !currentLine.isContinuationLine()) {
            this.previousIndentation = currentLine.getIndentation();
        }
        this.previousLine = currentLine;
    }

    private String computeNewIndentation(StartOfLine currentLine) {
        if (this.previousLine == null) {
            return "";
        }
        if (currentLine.isContinuationLine()) {
            return String.valueOf(StartOfLine.getIncreasedIndentation(this.previousIndentation)) + currentLine.getContinuationPrefix();
        }
        if (this.previousLine.startsIndentedRegion() && !currentLine.isContinuationLine() && !currentLine.endsIndentedRegion()) {
            return StartOfLine.getIncreasedIndentation(this.previousIndentation);
        }
        if (currentLine.endsDoublyIndentedRegion() && !this.previousLine.startsIndentedRegion()) {
            return StartOfLine.getDecreasedIndentation(StartOfLine.getDecreasedIndentation(this.previousIndentation));
        }
        if (currentLine.isEndDoStmt() && this.previousLine.isContinueStmt()) {
            return this.previousIndentation;
        }
        if (currentLine.endsIndentedRegion() && !this.previousLine.startsIndentedRegion() || currentLine.endsDoublyIndentedRegion() && this.previousLine.startsIndentedRegion()) {
            return StartOfLine.getDecreasedIndentation(this.previousIndentation);
        }
        return this.previousIndentation;
    }
}

