/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.AttributeNameCompletionProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.AttributeValueCompletionProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.TagCompletionProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.TagValueCompletionProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;

public class TargetDefinitionContentAssist
implements IContentAssistProcessor {
    private static final String PREVIOUS_TAGS_MATCH = "(\\s*<(.|\\n)*>\\s*)*";
    private static final String ATTRIBUTE_NAME_SEARCH_TERM_MATCH = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*\\w*(\\s*\\w*\\s*=\\s*\".*?\")*\\s+(?<searchTerm>\\w*)");
    private static final String TAG_SEARCH_TERM_MATCH = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*(?<searchTerm>\\w*)");
    private static final String ATTRIBUTE_VALUE_MATCH_REGEXP = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*\\w*(\\s+\\w+\\s*=\\s*\"(.|\\n)*?\")*\\s+\\w+\\s*=\\s*\"[^\"]*");
    private static final String ATTRIBUTE_VALUE_ACKEY_MATCH = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*\\w*(\\s+\\w+\\s*=\\s*\".*?\")*\\s+(?<ackey>\\w+)\\s*=\\s*\"[^\"]*");
    private static final String ATTRIBUTE_VALUE_SEARCH_TERM_MATCH = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*\\w*(\\s+\\w+\\s*=\\s*\".*?\")*\\s+\\w+\\s*=\\s*\"(?<searchTerm>[^\"]*)");
    private static final String ATTRIBUTE_NAME_MATCH_REGEXP = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*\\w*(\\s*\\w+\\s*=\\s*\"(.|\\n)*?\")*\\s+\\w*");
    private static final String ATTRIBUTE_NAME_ACKEY_MATCH = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*(?<ackey>\\w*)(\\s*\\w+\\s*=\\s*\".*?\")*\\s+\\w*");
    private static final String TAG_MATCH_REGEXP = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*\\w*");
    private static final String TAG_VALUE_MATCH_REGEXP = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<\\s*\\w+[^<]*>\\s*\\w*");
    private static final String TAG_VALUE_SEARCH_TERM_MATCH = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*(?<searchTerm>\\w*)");
    private static final String TAG_VALUE_ACKEY_MATCH = "(\\s*<(.|\\n)*>\\s*)*".concat("\\s*<(?<ackey>\\w*).*");
    private static final int COMPLETION_TYPE_TAG = 0;
    private static final int COMPLETION_TYPE_ATTRIBUTE_NAME = 1;
    private static final int COMPLETION_TYPE_ATTRIBUTE_VALUE = 2;
    private static final int COMPLETION_TYPE_HEADER = 4;
    private static final int COMPLETION_TYPE_TAG_VALUE = 5;
    private static final int COMPLETION_TYPE_UNKNOWN = 6;
    private static final Pattern TAG_SEARCH_TERM_PATTERN = Pattern.compile(TAG_SEARCH_TERM_MATCH, 32);
    private static final Pattern ATT_NAME_SEARCH_TERM_PATTERN = Pattern.compile(ATTRIBUTE_NAME_SEARCH_TERM_MATCH, 32);
    private static final Pattern ATTR_NAME_ACKEY_MATCH = Pattern.compile(ATTRIBUTE_NAME_ACKEY_MATCH, 32);
    private static final Pattern ATTR_VALUE_SEARCH_TERM_PATTERN = Pattern.compile(ATTRIBUTE_VALUE_SEARCH_TERM_MATCH, 32);
    private static final Pattern ATTR_VALUE_ACKEY_PATTERN = Pattern.compile(ATTRIBUTE_VALUE_ACKEY_MATCH, 32);
    private static final Pattern TAG_VALUE_SEARCH_TERM_PATTERN = Pattern.compile(TAG_VALUE_SEARCH_TERM_MATCH, 32);
    private static final Pattern TAG_VALUE_ACKEY_PATTERN = Pattern.compile(TAG_VALUE_ACKEY_MATCH, 32);
    private String searchTerm = "";
    private String acKey;
    private static StyledString.Styler bold = new BoldStylerProvider(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont")).getBoldStyler();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        String text = document.get();
        try {
            Parser.getDefault().parse(document);
        }
        catch (XMLStreamException xMLStreamException) {}
        int completionType = this.detectCompletionType(document, text, offset);
        if (completionType == 6) {
            return new ICompletionProposal[0];
        }
        if (completionType == 0) {
            TagCompletionProcessor processor = new TagCompletionProcessor(this.searchTerm, this.acKey, offset);
            return processor.getCompletionProposals();
        }
        if (completionType == 1) {
            AttributeNameCompletionProcessor processor = new AttributeNameCompletionProcessor(this.searchTerm, this.acKey, offset, text);
            return processor.getCompletionProposals();
        }
        if (completionType == 2) {
            AttributeValueCompletionProcessor processor = new AttributeValueCompletionProcessor(this.searchTerm, this.acKey, offset);
            return processor.getCompletionProposals();
        }
        if (completionType == 5) {
            TagValueCompletionProcessor processor = new TagValueCompletionProcessor(this.searchTerm, this.acKey, offset);
            return processor.getCompletionProposals();
        }
        return new ICompletionProposal[0];
    }

    private int detectCompletionType(IDocument doc, String text, int offset) {
        if (offset == 0) {
            return 4;
        }
        try {
            doc.getLineInformationOfOffset(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 6;
        }
        int indexOfLastTagStart = text.lastIndexOf(60, offset - 1);
        String tagText = text.substring(Math.max(0, indexOfLastTagStart), offset);
        if (tagText.matches(TAG_MATCH_REGEXP)) {
            Matcher matcher = TAG_SEARCH_TERM_PATTERN.matcher(tagText);
            matcher.matches();
            this.searchTerm = matcher.group("searchTerm");
            return 0;
        }
        if (tagText.matches(ATTRIBUTE_NAME_MATCH_REGEXP)) {
            Matcher matcher = ATT_NAME_SEARCH_TERM_PATTERN.matcher(tagText);
            matcher.matches();
            this.searchTerm = matcher.group("searchTerm");
            matcher = ATTR_NAME_ACKEY_MATCH.matcher(tagText);
            matcher.matches();
            this.acKey = matcher.group("ackey");
            return 1;
        }
        if (tagText.matches(ATTRIBUTE_VALUE_MATCH_REGEXP)) {
            Matcher matcher = ATTR_VALUE_SEARCH_TERM_PATTERN.matcher(tagText);
            matcher.matches();
            this.searchTerm = matcher.group("searchTerm");
            matcher = ATTR_VALUE_ACKEY_PATTERN.matcher(tagText);
            matcher.matches();
            this.acKey = matcher.group("ackey");
            return 2;
        }
        if (tagText.matches(TAG_VALUE_MATCH_REGEXP)) {
            Matcher matcher = TAG_VALUE_SEARCH_TERM_PATTERN.matcher(tagText);
            matcher.matches();
            this.searchTerm = matcher.group("searchTerm");
            matcher = TAG_VALUE_ACKEY_PATTERN.matcher(tagText);
            matcher.matches();
            this.acKey = matcher.group("ackey");
            return 5;
        }
        return 6;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static StyledString getFilteredStyledString(String string, String searchTerm) {
        if (string == null) {
            return null;
        }
        if (searchTerm.isEmpty()) {
            return new StyledString(string);
        }
        if (string.toLowerCase().contains(searchTerm.toLowerCase())) {
            index = string.toLowerCase().indexOf(searchTerm.toLowerCase());
            len = searchTerm.length();
            styledString = new StyledString(string.substring(0, index));
            styledString.append(string.substring(index, index + len), TargetDefinitionContentAssist.bold);
            return styledString.append(string.substring(index + len, string.length()));
        }
        searchCharIndex = 0;
        subStringCharIndex = 0;
        stringParts = string.split("((?=[A-Z])|(?<=[._])|(?=[0-9])(?<![0-9]))");
        styledString = new StyledString();
        while (searchCharIndex < searchTerm.length()) {
            var9_12 = stringParts;
            var8_11 = stringParts.length;
            var7_10 = 0;
            while (var7_10 < var8_11) {
                block10: {
                    subString = var9_12[var7_10];
                    if (searchCharIndex != searchTerm.length()) ** GOTO lbl29
                    styledString.append(subString);
                    break block10;
                    while (subString.charAt(subStringCharIndex) == searchTerm.charAt(searchCharIndex)) {
                        ++searchCharIndex;
                        ++subStringCharIndex;
lbl29:
                        // 2 sources

                        if (searchCharIndex < searchTerm.length() && subStringCharIndex < subString.length()) continue;
                    }
                    if (subStringCharIndex > 0) {
                        styledString.append(subString.substring(0, subStringCharIndex), TargetDefinitionContentAssist.bold);
                        styledString.append(subString.substring(subStringCharIndex));
                        subStringCharIndex = 0;
                    } else {
                        styledString.append(subString);
                    }
                }
                ++var7_10;
            }
            if (searchCharIndex == searchTerm.length()) {
                return styledString;
            }
            if (stringParts.length == 0) {
                return null;
            }
            searchCharIndex = 0;
            subStringCharIndex = 0;
            stringParts = Arrays.copyOfRange(stringParts, 1, stringParts.length);
            styledString = new StyledString();
        }
        return null;
    }
}

