/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.OwnedAttributeHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class OwnerObservableValue
extends ReferenceCountedObservable.Value
implements IChangeListener,
AggregatedObservable,
CommandBasedObservableValue,
IObserving {
    private Property memberEnd;
    private EditingDomain domain;
    private String currentValue;
    private final IObservableList navigableEndsObservableList;
    public static final String CLASSIFIER = "Classifier";
    public static final String ASSOCIATION = "Association";

    public OwnerObservableValue(EObject source, EditingDomain domain) {
        this.memberEnd = (Property)source;
        this.domain = domain;
        this.navigableEndsObservableList = EMFProperties.list((EStructuralFeature)UMLPackage.eINSTANCE.getAssociation_NavigableOwnedEnd()).observe((Object)this.memberEnd.getAssociation());
        this.navigableEndsObservableList.addChangeListener((IChangeListener)this);
    }

    public void handleChange(ChangeEvent event) {
        this.fireValueChange(Diffs.createValueDiff((Object)this.currentValue, (Object)this.doGetValue()));
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        return this.memberEnd.getAssociation().getOwnedEnds().contains((Object)this.memberEnd) ? ASSOCIATION : CLASSIFIER;
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    public Object getObserved() {
        return this.memberEnd;
    }

    public synchronized void dispose() {
        super.dispose();
        this.navigableEndsObservableList.removeChangeListener((IChangeListener)this);
        this.navigableEndsObservableList.dispose();
    }

    public Command getCommand(Object value) {
        if (value instanceof String) {
            String owner = (String)value;
            boolean isOwnedByAssociation = ASSOCIATION.equals(owner);
            Association association = this.memberEnd.getAssociation();
            if (association.getMemberEnds().size() > 2) {
                Activator.log.warn("Cannot change End owner for n-ary associations");
                return UnexecutableCommand.INSTANCE;
            }
            ICommand command = null;
            if (isOwnedByAssociation) {
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)association);
                if (provider != null) {
                    EReference feature = UMLPackage.eINSTANCE.getAssociation_OwnedEnd();
                    ArrayList<Property> attributeList = new ArrayList<Property>();
                    attributeList.addAll((Collection<Property>)association.getOwnedEnds());
                    attributeList.add(this.memberEnd);
                    SetRequest request = new SetRequest((EObject)association, (EStructuralFeature)feature, attributeList);
                    command = provider.getEditCommand((IEditCommandRequest)request);
                }
            } else {
                command = OwnedAttributeHelper.getSetTypeOwnerForAssociationAttributeCommand(association, this.memberEnd);
            }
            if (command != null) {
                this.currentValue = owner;
                return new GMFtoEMFCommandWrapper(command);
            }
            Activator.log.warn("Cannot modify the memberEnd owner");
        }
        return UnexecutableCommand.INSTANCE;
    }

    public AggregatedObservable aggregate(IObservable observable) {
        try {
            return new AggregatedPapyrusObservableValue(this.domain, new IObservable[]{this, observable});
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

