/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.ui.emf.providers.DependentEMFLabelProvider;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.graphics.Image;

public class ViewPrototypeLabelProvider
extends DependentEMFLabelProvider {
    protected Image getImage(EObject element) {
        ViewPrototype proto = ViewPrototype.get(element);
        Image result = proto != null ? proto.getIcon() : super.getImage(element);
        return result;
    }

    protected String getText(EObject element) {
        String result = super.getText(element);
        ViewPrototype proto = ViewPrototype.get(element);
        if (!proto.isUnavailable()) {
            EObject context = proto.getRootOf(element);
            result = this.getName(element);
            if (result != null && !result.isEmpty()) {
                if (context != null) {
                    this.unsubscribe(context, element);
                }
            } else {
                if (context != null) {
                    String contextLabel = this.getText(context);
                    result = NLS.bind((String)"({0} of {1})", (Object)proto.getLabel(), (Object)contextLabel);
                    this.subscribe(context, element);
                } else {
                    result = NLS.bind((String)"({1})", (Object)proto.getLabel());
                }
                if (result == null || result.isEmpty()) {
                    result = "(unnamed)";
                }
            }
        }
        return result;
    }

    protected String getName(EObject object) {
        String value = null;
        if (object instanceof Diagram) {
            value = LabelInternationalization.getInstance().getDiagramLabel((Diagram)object);
        }
        return value != null ? value : EMFCoreUtil.getName((EObject)object);
    }
}

