/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.nattable.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.viewpoints.policy.AbstractViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableCommandHelper
extends AbstractViewTypeHelper<PapyrusTable> {
    public TableCommandHelper() {
        super(PapyrusTable.class);
    }

    public boolean isSupported(EClass type) {
        return type == RepresentationPackage.eINSTANCE.getPapyrusTable();
    }

    public boolean isSupported(EObject view) {
        if (!(view instanceof Table)) {
            return false;
        }
        Table table = (Table)view;
        return table.getTableKindId() != null || table.getTableConfiguration() != null;
    }

    protected ViewPrototype doGetPrototypeFor(PapyrusTable papyrusTable) {
        return new TableViewPrototype(papyrusTable);
    }

    protected ViewPrototype doGetPrototypeOf(EObject view) {
        PolicyChecker checker = this.getPolicyChecker(view);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        PapyrusTable repKind = (PapyrusTable)manager.getRepresentationKindById(((Table)view).getTableKindId());
        if (repKind != null && checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
            return this.getPrototypeFor((PapyrusRepresentationKind)repKind);
        }
        return ViewPrototype.UNAVAILABLE_VIEW;
    }
}

