/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.AbstractPapyrusGmfCreateDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.AbstractViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.osgi.framework.Bundle;

public class GMFDiagramViewTypeHelper
extends AbstractViewTypeHelper<PapyrusDiagram> {
    public GMFDiagramViewTypeHelper() {
        super(PapyrusDiagram.class);
    }

    public boolean isSupported(EObject view) {
        return view instanceof Diagram;
    }

    protected ViewPrototype doGetPrototypeFor(PapyrusDiagram diagramKind) {
        String commandClassName = diagramKind.getCreationCommandClass();
        if (commandClassName != null) {
            Class creationCommandClass = null;
            URI uri = diagramKind.eResource().getURI();
            if (uri.isPlatformPlugin()) {
                String bundleName = uri.segment(1);
                Bundle bundle = Platform.getBundle((String)bundleName);
                try {
                    creationCommandClass = bundle.loadClass(diagramKind.getCreationCommandClass());
                }
                catch (ClassNotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            if (creationCommandClass != null) {
                AbstractPapyrusGmfCreateDiagramCommandHandler command;
                try {
                    command = (AbstractPapyrusGmfCreateDiagramCommandHandler)((Object)creationCommandClass.newInstance());
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
                String language = diagramKind.getLanguage().getId();
                return new DiagramPrototype(diagramKind, language, command);
            }
        }
        return null;
    }

    protected ViewPrototype doGetPrototypeOf(EObject view) {
        Diagram diagram = (Diagram)view;
        PolicyChecker checker = this.getPolicyChecker((EObject)diagram);
        return DiagramUtils.getPrototype(diagram, checker);
    }
}

