/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.om.OMPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TrackableTimerTask
extends TimerTask {
    public static final boolean TRACK_TIMER_TASKS = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.concurrent.TrackTimerTasks");
    private static final Map<TrackableTimerTask, ConstructionInfo> CONSTRUCTION_INFOS = TRACK_TIMER_TASKS ? new WeakHashMap() : null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TrackableTimerTask() {
        if (TRACK_TIMER_TASKS) {
            Map<TrackableTimerTask, ConstructionInfo> map = CONSTRUCTION_INFOS;
            synchronized (map) {
                CONSTRUCTION_INFOS.put(this, new ConstructionInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        if (TRACK_TIMER_TASKS) {
            Map<TrackableTimerTask, ConstructionInfo> map = CONSTRUCTION_INFOS;
            synchronized (map) {
                CONSTRUCTION_INFOS.remove(this);
            }
        }
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Exception> getConstructionStackTraces(long minLifeTimeMillis) {
        if (!TRACK_TIMER_TASKS) {
            return Collections.emptyList();
        }
        long maxTimeStamp = System.currentTimeMillis() - minLifeTimeMillis;
        ArrayList<Exception> result = new ArrayList<Exception>();
        Map<TrackableTimerTask, ConstructionInfo> map = CONSTRUCTION_INFOS;
        synchronized (map) {
            for (ConstructionInfo constructionInfo : CONSTRUCTION_INFOS.values()) {
                if (constructionInfo.timeStamp >= maxTimeStamp) continue;
                result.add(constructionInfo.stackTrace);
            }
        }
        return result;
    }

    public static void logConstructionStackTraces(long minLifeTimeMillis) {
        Collection<Exception> constructionStackTraces;
        if (TRACK_TIMER_TASKS && !(constructionStackTraces = TrackableTimerTask.getConstructionStackTraces(minLifeTimeMillis)).isEmpty()) {
            for (Exception exception : constructionStackTraces) {
                OM.LOG.info(exception);
            }
        }
    }

    private final class ConstructionInfo {
        public final long timeStamp = System.currentTimeMillis();
        public final Exception stackTrace = this.getStackTrace();

        private ConstructionInfo() {
        }

        private Exception getStackTrace() {
            try {
                throw new Exception("The timer task " + TrackableTimerTask.this + " has been constructed here:");
            }
            catch (Exception ex) {
                return ex;
            }
        }
    }
}

