/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;

public class Sleeper {
    private static final int DEFAULT_INTERVAL = 10;
    private long start;
    private int interval;

    public Sleeper() {
        this(10);
    }

    public Sleeper(int interval) {
        this.interval = interval;
        this.restart();
    }

    public int getInterval() {
        return this.interval;
    }

    public long getStart() {
        return this.start;
    }

    public void restart() {
        this.start = System.currentTimeMillis();
    }

    public void sleep(long millis) {
        while (System.currentTimeMillis() < this.start + millis) {
            ConcurrencyUtil.sleep(this.interval);
        }
    }

    public void resleep(long millis) {
        this.restart();
        this.sleep(millis);
    }
}

