/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.issue;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.github.core.issue.IssueAttribute;
import org.eclipse.mylyn.internal.github.ui.issue.IssueLabelAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorSection;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.UpdateRepositoryConfigurationAction;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.IProgressConstants2;

public class IssueAttributePart
extends AbstractTaskEditorSection {
    private List<AbstractAttributeEditor> attributeEditors;
    private boolean hasIncoming;
    private Composite attributesComposite;

    public IssueAttributePart() {
        this.setPartName(Messages.TaskEditorAttributePart_Attributes);
    }

    protected AbstractAttributeEditor createAttributeEditor(TaskAttribute attribute) {
        if (IssueAttribute.LABELS.getMetadata().getId().equals(attribute.getId())) {
            return new IssueLabelAttributeEditor(this.getModel(), attribute);
        }
        if (IssueAttribute.MILESTONE.getMetadata().getId().equals(attribute.getId())) {
            return super.createAttributeEditor(attribute);
        }
        return null;
    }

    private void createAttributeControls(Composite attributesComposite, FormToolkit toolkit, int columnCount) {
        for (AbstractAttributeEditor attributeEditor : this.attributeEditors) {
            if (attributeEditor.hasLabel()) {
                attributeEditor.createLabelControl(attributesComposite, toolkit);
            }
            attributeEditor.createControl(attributesComposite, toolkit);
            Object data = attributeEditor.getControl().getLayoutData();
            if (data == null) {
                data = GridDataFactory.swtDefaults().create();
                attributeEditor.getControl().setLayoutData(data);
            }
            if (data instanceof GridData) {
                ((GridData)data).widthHint = 140;
            }
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.initialize();
        super.createControl(parent, toolkit);
    }

    protected String getInfoOverlayText() {
        return null;
    }

    protected boolean shouldExpandOnCreate() {
        return this.getTaskData().isNew() || this.hasIncoming;
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        this.attributesComposite = toolkit.createComposite(parent);
        this.attributesComposite.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control focus = event.display.getFocusControl();
                if (focus instanceof Text && !((Text)focus).getEditable()) {
                    IssueAttributePart.this.getManagedForm().getForm().setFocus();
                }
            }
        });
        GridLayout attributesLayout = EditorUtil.createSectionClientLayout();
        attributesLayout.numColumns = 2;
        attributesLayout.horizontalSpacing = 7;
        attributesLayout.verticalSpacing = 6;
        this.attributesComposite.setLayout((Layout)attributesLayout);
        GridData attributesData = new GridData(1808);
        attributesData.horizontalSpan = 1;
        attributesData.grabExcessVerticalSpace = false;
        this.attributesComposite.setLayoutData((Object)attributesData);
        this.createAttributeControls(this.attributesComposite, toolkit, attributesLayout.numColumns);
        toolkit.paintBordersFor(this.attributesComposite);
        return this.attributesComposite;
    }

    protected void fillToolBar(ToolBarManager toolBar) {
        UpdateRepositoryConfigurationAction repositoryConfigRefresh = new UpdateRepositoryConfigurationAction(){

            public void run() {
                IssueAttributePart.this.getTaskEditorPage().showEditorBusy(true);
                final TaskJob job = TasksUiInternal.getJobFactory().createUpdateRepositoryConfigurationJob(IssueAttributePart.this.getTaskEditorPage().getConnector(), IssueAttributePart.this.getTaskEditorPage().getTaskRepository(), IssueAttributePart.this.getTaskEditorPage().getTask());
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                            IssueAttributePart.this.getTaskEditorPage().showEditorBusy(false);
                            if (job.getStatus() != null) {
                                IssueAttributePart.this.getTaskEditorPage().getTaskEditor().setStatus(Messages.TaskEditorAttributePart_Updating_of_repository_configuration_failed, Messages.TaskEditorAttributePart_Update_Failed, job.getStatus());
                            } else {
                                IssueAttributePart.this.getTaskEditorPage().refresh();
                            }
                        });
                    }
                });
                job.setUser(true);
                job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
                job.setPriority(10);
                job.schedule();
            }
        };
        repositoryConfigRefresh.setImageDescriptor(TasksUiImages.REPOSITORY_SYNCHRONIZE_SMALL);
        repositoryConfigRefresh.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditorPage().getTaskRepository()));
        repositoryConfigRefresh.setToolTipText(Messages.TaskEditorAttributePart_Refresh_Attributes);
        toolBar.add((IAction)repositoryConfigRefresh);
    }

    private void initialize() {
        TaskAttribute labels;
        this.attributeEditors = new ArrayList<AbstractAttributeEditor>();
        this.hasIncoming = false;
        TaskAttribute root = this.getTaskData().getRoot();
        LinkedList<TaskAttribute> attributes = new LinkedList<TaskAttribute>();
        TaskAttribute milestones = root.getAttribute(IssueAttribute.MILESTONE.getMetadata().getId());
        if (milestones != null) {
            attributes.add(milestones);
        }
        if ((labels = root.getAttribute(IssueAttribute.LABELS.getMetadata().getId())) != null) {
            attributes.add(labels);
        }
        for (TaskAttribute attribute : attributes) {
            AbstractAttributeEditor attributeEditor = this.createAttributeEditor(attribute);
            if (attributeEditor == null) continue;
            this.attributeEditors.add(attributeEditor);
            if (!this.getModel().hasIncomingChanges(attribute)) continue;
            this.hasIncoming = true;
        }
    }

    public boolean setFormInput(Object input) {
        if (input instanceof String) {
            String text = (String)input;
            Map attributes = this.getTaskData().getRoot().getAttributes();
            for (TaskAttribute attribute : attributes.values()) {
                TaskAttributeMetaData properties;
                if (!text.equals(attribute.getId()) || !"task.common.kind.default".equals((properties = attribute.getMetaData()).getKind())) continue;
                this.selectReveal(attribute);
            }
        }
        return super.setFormInput(input);
    }

    public void selectReveal(TaskAttribute attribute) {
        if (attribute == null) {
            return;
        }
        if (!this.getSection().isExpanded()) {
            CommonFormUtil.setExpanded((ExpandableComposite)this.getSection(), (boolean)true);
        }
        EditorUtil.reveal((ScrolledForm)this.getTaskEditorPage().getManagedForm().getForm(), (String)attribute.getId());
    }
}

