/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.osgi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.ReferenceQuery;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.inspections.osgi.model.Bundle;
import org.eclipse.mat.inspections.osgi.model.BundleDescriptor;
import org.eclipse.mat.inspections.osgi.model.BundleFragment;
import org.eclipse.mat.inspections.osgi.model.IBundleReader;
import org.eclipse.mat.inspections.osgi.model.OSGiModel;
import org.eclipse.mat.inspections.osgi.model.Service;
import org.eclipse.mat.inspections.osgi.model.eclipse.ConfigurationElement;
import org.eclipse.mat.inspections.osgi.model.eclipse.Extension;
import org.eclipse.mat.inspections.osgi.model.eclipse.ExtensionPoint;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxBundleReader2
implements IBundleReader {
    private Map<String, Bundle> bundles = new HashMap<String, Bundle>();
    private ISnapshot snapshot;
    private Map<BundleDescriptor, List<Service>> registeredServices = new HashMap<BundleDescriptor, List<Service>>();
    private Map<BundleDescriptor, List<Service>> usedServices = new HashMap<BundleDescriptor, List<Service>>();
    private Map<Long, BundleDescriptor> bundleDescriptors = new HashMap<Long, BundleDescriptor>();
    private Map<BundleDescriptor, List<ExtensionPoint>> extensionPointsByBundle = new HashMap<BundleDescriptor, List<ExtensionPoint>>();
    private Map<BundleDescriptor, List<Extension>> extensionsByBundle = new HashMap<BundleDescriptor, List<Extension>>();
    private Map<BundleDescriptor, List<BundleDescriptor>> bundleDependencies = new HashMap<BundleDescriptor, List<BundleDescriptor>>();
    private Map<BundleDescriptor, List<BundleDescriptor>> bundleDependents = new HashMap<BundleDescriptor, List<BundleDescriptor>>();
    private static final int STEPS = 1000000;
    private int maxWarnings = 100;

    public EquinoxBundleReader2(ISnapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public OSGiModel readOSGiModel(IProgressListener listener) throws SnapshotException {
        listener.beginTask(Messages.EquinoxBundleReader_ProcessListenerBundles, 4000000);
        List<BundleDescriptor> descriptors = this.getBundleDescriptors(listener);
        this.collectDependencies(listener);
        List<Service> services = this.collectServiceInfo(listener);
        List<ExtensionPoint> extensionPoints = this.collectExtensionsInfo(listener);
        OSGiModel model = new OSGiModel(this, descriptors, services, extensionPoints);
        listener.done();
        return model;
    }

    private List<BundleDescriptor> getBundleDescriptors(IProgressListener listener) throws SnapshotException {
        listener.subTask(Messages.EquinoxBundleReader_ReadingBundles);
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.osgi.internal.framework.EquinoxBundle", true);
        ArrayList<BundleDescriptor> bundleDescriptors = new ArrayList<BundleDescriptor>();
        if (classes == null || classes.isEmpty()) {
            return bundleDescriptors;
        }
        int nobjs = 0;
        for (IClass clazz : classes) {
            nobjs += clazz.getNumberOfObjects();
        }
        for (IClass clazz : classes) {
            int[] objs = clazz.getObjectIds();
            int i = 0;
            while (i < objs.length) {
                IInstance obj = (IInstance)this.snapshot.getObject(objs[i]);
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                IInstance bundleObject = obj;
                BundleDescriptor.Type type = BundleDescriptor.Type.BUNDLE;
                if (this.isFragment(bundleObject)) {
                    type = BundleDescriptor.Type.FRAGMENT;
                }
                BundleDescriptor descriptor = this.getBundleDescriptor(bundleObject, type);
                bundleDescriptors.add(descriptor);
                listener.worked(1000000 / nobjs);
                ++i;
            }
        }
        return bundleDescriptors;
    }

    private boolean isFragment(IObject bundleHostObject) throws SnapshotException {
        IObject revs = (IObject)bundleHostObject.resolveValue("module.revisions.revisions");
        if (revs == null) {
            return false;
        }
        Iterator<IObject> it1 = CollectionExtractionUtils.extractList(revs).iterator();
        if (!it1.hasNext()) {
            return false;
        }
        IObject rev = it1.next();
        IObject caps = (IObject)rev.resolveValue("capabilities");
        if (caps == null) {
            return false;
        }
        for (IObject o : CollectionExtractionUtils.extractList(caps)) {
            if (!"equinox.fragment".equals(((IObject)o.resolveValue("namespace")).getClassSpecificName())) continue;
            return true;
        }
        return false;
    }

    private List<BundleDescriptor> getBundleFragments(IObject bundleHostObject) throws SnapshotException {
        ArrayList<BundleDescriptor> fragments = new ArrayList<BundleDescriptor>();
        for (BundleDescriptor bd : this.bundleDescriptors.values()) {
            BundleDescriptor bd2;
            if (!bd.getType().equals((Object)BundleDescriptor.Type.FRAGMENT) || (bd2 = this.getFragmentHost(this.snapshot.getObject(bd.getObjectId()))) == null || bd2.getObjectId() != bundleHostObject.getObjectId()) continue;
            fragments.add(bd);
        }
        return fragments;
    }

    private List<Service> collectServiceInfo(IProgressListener listener) throws SnapshotException {
        listener.subTask(Messages.EquinoxBundleReader_ReadingServices);
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.osgi.internal.serviceregistry.ServiceRegistry", false);
        if (classes == null || classes.isEmpty()) {
            classes = this.snapshot.getClassesByName("org.eclipse.osgi.framework.internal.core.ServiceRegistryImpl", false);
        }
        ArrayList<Service> services = new ArrayList<Service>();
        if (classes == null || classes.isEmpty()) {
            return services;
        }
        int nobjs = 0;
        for (IClass clazz : classes) {
            nobjs += clazz.getNumberOfObjects();
        }
        for (IClass clazz : classes) {
            int[] objs = clazz.getObjectIds();
            int i = 0;
            while (i < objs.length) {
                IObject obj = this.snapshot.getObject(objs[i]);
                IObject publishedServices = (IObject)obj.resolveValue("allPublishedServices");
                for (IObject serviceInstance : CollectionExtractionUtils.extractList(publishedServices)) {
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    IObject bundleObj = (IObject)serviceInstance.resolveValue("bundle");
                    BundleDescriptor bundleDescriptor = this.getBundleDescriptor(bundleObj, BundleDescriptor.Type.BUNDLE);
                    ArrayList<BundleDescriptor> bundlesUsing = null;
                    IObject bundlesList = (IObject)serviceInstance.resolveValue("contextsUsing");
                    ExtractedCollection bunds = CollectionExtractionUtils.extractList(bundlesList);
                    Integer size = bunds.size();
                    bundlesUsing = new ArrayList<BundleDescriptor>(size != null ? size : 0);
                    for (IObject bundleInstance : bunds) {
                        IObject bundleObject = (IObject)bundleInstance.resolveValue("bundle");
                        if (bundleObject == null) continue;
                        BundleDescriptor usingBundleDescriptor = this.getBundleDescriptor(bundleObject, BundleDescriptor.Type.BUNDLE);
                        bundlesUsing.add(usingBundleDescriptor);
                    }
                    IObjectArray clazzes = (IObjectArray)serviceInstance.resolveValue("clazzes");
                    Iterator<IObject> it = CollectionExtractionUtils.extractList(clazzes).iterator();
                    String serviceName = it.next().getClassSpecificName();
                    IObject propertiesObject = (IObject)serviceInstance.resolveValue("properties");
                    String[] keys = null;
                    String[] values = null;
                    if (propertiesObject != null) {
                        ExtractedMap em = CollectionExtractionUtils.extractMap(propertiesObject);
                        if (em != null && em.hasSize()) {
                            keys = new String[em.size().intValue()];
                            values = new String[em.size().intValue()];
                            int i1 = 0;
                            for (Map.Entry<IObject, IObject> en : em) {
                                keys[i1] = ((IObject)en.getKey().resolveValue("key")).getClassSpecificName();
                                values[i1] = en.getValue().getClassSpecificName();
                                ++i1;
                            }
                        } else {
                            long[] valueAddresses;
                            IObjectArray valuesArray;
                            long[] keyAddresses;
                            IObjectArray keysArray = (IObjectArray)propertiesObject.resolveValue("headers");
                            if (keysArray != null && (keyAddresses = keysArray.getReferenceArray()) != null) {
                                keys = this.getServiceProperties(new String[keyAddresses.length], keyAddresses);
                            }
                            if ((valuesArray = (IObjectArray)propertiesObject.resolveValue("values")) != null && (valueAddresses = valuesArray.getReferenceArray()) != null) {
                                values = this.getServiceProperties(new String[valueAddresses.length], valueAddresses);
                            }
                        }
                    }
                    services.add(new Service(serviceName, serviceInstance.getObjectId(), bundleDescriptor, bundlesUsing, keys, values));
                }
                listener.worked(1000000 / nobjs);
                ++i;
            }
        }
        if (services.size() > 0) {
            this.updateServiceMap(services);
        }
        return services;
    }

    private String[] getServiceProperties(String[] values, long[] valueAddresses) {
        int j = 0;
        while (j < valueAddresses.length) {
            block7: {
                if (valueAddresses[j] != 0L) {
                    try {
                        int valueId = this.snapshot.mapAddressToId(valueAddresses[j]);
                        IObject valueObject = this.snapshot.getObject(valueId);
                        if (valueObject == null) break block7;
                        if (valueObject.getClazz().isArrayType()) {
                            long[] addresses = ((IObjectArray)valueObject).getReferenceArray();
                            int k = 0;
                            while (k < addresses.length) {
                                int id;
                                IObject object;
                                if (valueAddresses[k] != 0L && (object = this.snapshot.getObject(id = this.snapshot.mapAddressToId(addresses[k]))) != null) {
                                    values[j] = object.getClassSpecificName();
                                    break block7;
                                }
                                ++k;
                            }
                            break block7;
                        }
                        values[j] = valueObject.getClassSpecificName();
                    }
                    catch (SnapshotException e) {
                        values[j] = null;
                        MATPlugin.log(e, MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ServiceProperty, (Object[])new Object[]{Long.toHexString(valueAddresses[j])}));
                    }
                }
            }
            ++j;
        }
        return values;
    }

    private void updateServiceMap(List<Service> services) {
        for (Service service : services) {
            BundleDescriptor contributedBy = service.getBundleDescriptor();
            this.doUpdate(service, contributedBy, this.registeredServices);
            List<BundleDescriptor> bundlesUsing = service.getBundlesUsing();
            if (bundlesUsing == null) continue;
            for (BundleDescriptor descriptor : bundlesUsing) {
                this.doUpdate(service, descriptor, this.usedServices);
            }
        }
    }

    private void doUpdate(Service service, BundleDescriptor bundleDescriptor, Map<BundleDescriptor, List<Service>> serviceMap) {
        List<Service> listOfServices = serviceMap.get(bundleDescriptor);
        if (listOfServices == null) {
            ArrayList<Service> bundleServices = new ArrayList<Service>(1);
            bundleServices.add(service);
            serviceMap.put(bundleDescriptor, bundleServices);
        } else if (!listOfServices.contains(service)) {
            listOfServices.add(service);
        }
    }

    private BundleDescriptor getBundleDescriptor(IObject bundleHostObject, BundleDescriptor.Type type) throws SnapshotException {
        BundleDescriptor bundleDescriptor;
        IInstance bundleData = (IInstance)bundleHostObject.resolveValue("module");
        IInstance bundleData2 = (IInstance)bundleData.resolveValue("id");
        Field idField = bundleData2.getField("value");
        Long id = null;
        if (idField != null) {
            id = (Long)idField.getValue();
        }
        if ((bundleDescriptor = this.bundleDescriptors.get(id)) != null) {
            return bundleDescriptor;
        }
        String bundleName = this.extractBundleName(bundleData);
        String state = this.getState(bundleHostObject);
        BundleDescriptor descriptor = new BundleDescriptor(bundleHostObject.getObjectId(), id, bundleName, state, type);
        this.bundleDescriptors.put(id, descriptor);
        return descriptor;
    }

    private String extractBundleName(IObject bundleData) throws SnapshotException {
        IObject revs = (IObject)bundleData.resolveValue("revisions.revisions");
        IObject rev = CollectionExtractionUtils.extractList(revs).iterator().next();
        IObject name = (IObject)rev.resolveValue("symbolicName");
        String symbolicName = name.getClassSpecificName();
        IObject versionObj = (IObject)rev.resolveValue("version.qualifier");
        String version = null;
        if (versionObj != null) {
            version = rev.resolveValue("version.major") + "." + rev.resolveValue("version.minor") + "." + rev.resolveValue("version.micro") + "." + versionObj.getClassSpecificName();
        }
        String bundleName = version == null || version.equals("") ? symbolicName : String.valueOf(symbolicName) + " (" + version + ")";
        return bundleName;
    }

    @Override
    public Bundle getBundle(BundleDescriptor descriptor) throws SnapshotException {
        Bundle bundle = this.bundles.get(descriptor.getBundleName());
        if (bundle == null) {
            bundle = this.load(descriptor);
        }
        return bundle;
    }

    private Bundle load(BundleDescriptor descriptor) throws SnapshotException {
        int objectId = descriptor.getObjectId();
        IInstance obj = (IInstance)this.snapshot.getObject(objectId);
        IObject locationObj = (IObject)obj.resolveValue("module.location");
        String location = null;
        if (locationObj != null) {
            location = locationObj.getClassSpecificName();
        }
        if (descriptor.getType().equals((Object)BundleDescriptor.Type.FRAGMENT)) {
            BundleDescriptor host = this.getFragmentHost(obj);
            return new BundleFragment(descriptor, location, host);
        }
        List<BundleDescriptor> dependencies = null;
        List<BundleDescriptor> dependents = null;
        dependencies = this.bundleDependencies.get(descriptor);
        dependents = this.bundleDependents.get(descriptor);
        List<Extension> extensions = this.extensionsByBundle.get(descriptor);
        List<ExtensionPoint> extensionPoints = this.extensionPointsByBundle.get(descriptor);
        List<Service> registeredServices = this.registeredServices.get(descriptor);
        List<Service> usedServices = this.usedServices.get(descriptor);
        List<BundleDescriptor> fragments = this.getBundleFragments(obj);
        return new Bundle(descriptor, location, dependencies, dependents, extensionPoints, extensions, registeredServices, usedServices, fragments);
    }

    private BundleDescriptor getFragmentHost(IObject bundleFragmentObject) throws SnapshotException {
        IObject revs = (IObject)bundleFragmentObject.resolveValue("module.revisions.revisions");
        IObject rev = CollectionExtractionUtils.extractList(revs).iterator().next();
        IObject caps = (IObject)rev.resolveValue("capabilities");
        for (IObject o : CollectionExtractionUtils.extractList(caps)) {
            if (!"equinox.fragment".equals(((IObject)o.resolveValue("namespace")).getClassSpecificName())) continue;
            IObject attribs = (IObject)o.resolveValue("attributes");
            ExtractedMap kvs = CollectionExtractionUtils.extractMap(attribs);
            for (Map.Entry<IObject, IObject> et : kvs) {
                String hostName;
                if (!"equinox.fragment".equals(et.getKey().getClassSpecificName()) || (hostName = et.getValue().getClassSpecificName()) == null) continue;
                for (BundleDescriptor bd : this.bundleDescriptors.values()) {
                    if (!bd.getBundleName().equals(hostName) && !bd.getBundleName().startsWith(String.valueOf(hostName) + " (")) continue;
                    return bd;
                }
            }
        }
        MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_BundleNotFound, (Object[])new Object[]{Long.toHexString(bundleFragmentObject.getObjectAddress())}));
        return null;
    }

    private String getState(IObject obj) throws SnapshotException {
        IInstance bundleHostObject = (IInstance)obj.resolveValue("module.state");
        Field stateField = bundleHostObject.getField("ordinal");
        if (stateField == null) {
            return Messages.EquinoxBundleReader_NotApplicable;
        }
        int state = (Integer)stateField.getValue();
        BundleState[] bundleStateArray = BundleState.values();
        int n = bundleStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleState stateType = bundleStateArray[n2];
            if (stateType.getValue() == state) {
                return stateType.getLabel();
            }
            ++n2;
        }
        return Messages.EquinoxBundleReader_NotApplicable;
    }

    private List<BundleDescriptor> getDependencies(ISnapshot snapshot, IObject resolvedValue) throws SnapshotException {
        ArrayList<BundleDescriptor> dependencyDescriptors = null;
        ExtractedCollection coll = CollectionExtractionUtils.extractList(resolvedValue);
        if (coll != null) {
            Integer size = coll.size();
            dependencyDescriptors = new ArrayList<BundleDescriptor>(size != null ? size : 0);
            for (IObject bundleDescriptionObject : coll) {
                IObject bundleHostObject = (IObject)bundleDescriptionObject.resolveValue("userObject.bundle");
                if (bundleHostObject == null) continue;
                BundleDescriptor.Type type = BundleDescriptor.Type.BUNDLE;
                if (bundleHostObject.getClazz().getName().equals("org.eclipse.osgi.framework.internal.core.BundleFragment")) {
                    type = BundleDescriptor.Type.FRAGMENT;
                }
                BundleDescriptor descriptor = this.getBundleDescriptor(bundleHostObject, type);
                dependencyDescriptors.add(descriptor);
            }
        }
        return dependencyDescriptors;
    }

    private void collectDependencies(IProgressListener listener) throws SnapshotException {
        listener.subTask(Messages.EquinoxBundleReader_ReadingDependencies);
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.osgi.container.ModuleWire", false);
        if (classes != null) {
            int nobjs = 0;
            for (IClass clazz : classes) {
                nobjs += clazz.getNumberOfObjects();
            }
            for (IClass clazz : classes) {
                int[] objs = clazz.getObjectIds();
                int i = 0;
                while (i < objs.length) {
                    IInstance obj = (IInstance)this.snapshot.getObject(objs[i]);
                    IObject providerBundleHostObject = (IObject)obj.resolveValue("hostingProvider.revisions.module.this$0");
                    if (providerBundleHostObject != null) {
                        BundleDescriptor.Type providerType = BundleDescriptor.Type.BUNDLE;
                        if (this.isFragment(providerBundleHostObject)) {
                            providerType = BundleDescriptor.Type.FRAGMENT;
                        }
                        BundleDescriptor providerDescriptor = this.getBundleDescriptor(providerBundleHostObject, providerType);
                        IObject requirerBundleHostObject = (IObject)obj.resolveValue("hostingRequirer.revisions.module.this$0");
                        if (requirerBundleHostObject != null) {
                            BundleDescriptor.Type requirerType = BundleDescriptor.Type.BUNDLE;
                            if (this.isFragment(providerBundleHostObject)) {
                                requirerType = BundleDescriptor.Type.FRAGMENT;
                            }
                            BundleDescriptor requirerDescriptor = this.getBundleDescriptor(requirerBundleHostObject, requirerType);
                            List<BundleDescriptor> dependents = this.bundleDependents.get(providerDescriptor);
                            if (dependents == null) {
                                dependents = new ArrayList<BundleDescriptor>();
                                dependents.add(requirerDescriptor);
                                this.bundleDependents.put(providerDescriptor, dependents);
                            } else if (!dependents.contains(requirerDescriptor)) {
                                dependents.add(requirerDescriptor);
                            }
                            List<BundleDescriptor> dependencies = this.bundleDependencies.get(requirerDescriptor);
                            if (dependencies == null) {
                                dependencies = new ArrayList<BundleDescriptor>();
                                dependencies.add(providerDescriptor);
                                this.bundleDependencies.put(requirerDescriptor, dependencies);
                            } else if (!dependencies.contains(providerDescriptor)) {
                                dependencies.add(providerDescriptor);
                            }
                            listener.worked(1000000 / nobjs);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private List<ExtensionPoint> collectExtensionsInfo(IProgressListener listener) throws SnapshotException {
        listener.subTask(Messages.EquinoxBundleReader_ReadingExtensions);
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.core.internal.registry.ExtensionRegistry", false);
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        HashMap<String, ExtensionPoint> extensionPoints = new HashMap<String, ExtensionPoint>();
        HashMap<Integer, Extension> extensions = new HashMap<Integer, Extension>();
        HashMap<Integer, ConfigurationElement> configElements = new HashMap<Integer, ConfigurationElement>();
        int nobjs = 0;
        for (IClass clazz : classes) {
            nobjs += clazz.getNumberOfObjects();
        }
        for (IClass clazz : classes) {
            Object objs = clazz.getObjectIds();
            int i = 0;
            while (i < ((Object)objs).length) {
                int work = 1000000 / nobjs;
                IInstance obj = (IInstance)this.snapshot.getObject((int)objs[i]);
                IObjectArray heldObjectsArray = (IObjectArray)obj.resolveValue("registryObjects.heldObjects.elements");
                ExtractedCollection heldObjects = CollectionExtractionUtils.extractList(heldObjectsArray);
                if (heldObjects != null) {
                    Integer size1 = heldObjects.size();
                    for (IObject instance : heldObjects) {
                        if (listener.isCanceled()) {
                            throw new IProgressListener.OperationCanceledException();
                        }
                        this.extractElements(instance, extensionPoints, extensions, configElements, listener);
                        if (size1 == null) continue;
                        listener.worked(work / size1 / 2);
                    }
                    if (size1 == null) {
                        listener.worked(work / 2);
                    }
                }
                IObjectArray cachedObjectsArray = (IObjectArray)obj.resolveValue("registryObjects.cache.table");
                boolean useCachedObjects = true;
                if (useCachedObjects && cachedObjectsArray != null) {
                    ExtractedCollection refList = CollectionExtractionUtils.extractList(cachedObjectsArray);
                    Integer size2 = refList.size();
                    for (IObject instance : refList) {
                        if (listener.isCanceled()) {
                            throw new IProgressListener.OperationCanceledException();
                        }
                        ObjectReference ref = ReferenceQuery.getReferent((IInstance)instance);
                        if (ref != null) {
                            instance = ref.getObject();
                        }
                        this.extractElements(instance, extensionPoints, extensions, configElements, listener);
                        if (size2 == null) continue;
                        listener.worked(work / size2 / 2);
                    }
                    if (size2 == null) {
                        listener.worked(work / 2);
                    }
                }
                ++i;
            }
        }
        Set configElementSet = configElements.entrySet();
        for (Map.Entry entry : configElementSet) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            ConfigurationElement element = (ConfigurationElement)entry.getValue();
            Extension extension = (Extension)extensions.get(element.getParentId());
            if (extension == null) {
                ConfigurationElement configElement = (ConfigurationElement)configElements.get(element.getParentId());
                if (configElement == null) continue;
                configElement.addConfigurationElement(element);
                continue;
            }
            extension.addConfigurationElement(element);
        }
        Set set = extensions.entrySet();
        for (Map.Entry entry : set) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            Extension extension = (Extension)entry.getValue();
            String name = extension.getName();
            ExtensionPoint extensionPoint = (ExtensionPoint)extensionPoints.get(name);
            if (extensionPoint == null) continue;
            extensionPoint.addExtension(extension);
        }
        Set extensionsSet = extensions.entrySet();
        for (Map.Entry entry : extensionsSet) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            Extension extension = (Extension)entry.getValue();
            BundleDescriptor bundleDescriptor = extension.getContributedBy();
            List<Extension> listOfExtensions = this.extensionsByBundle.get(bundleDescriptor);
            if (listOfExtensions == null) {
                ArrayList<Object> extensionList = new ArrayList<Object>(1);
                extensionList.add(extension);
                this.extensionsByBundle.put(bundleDescriptor, extensionList);
                continue;
            }
            if (listOfExtensions.contains(extension)) continue;
            listOfExtensions.add(extension);
        }
        Set pointsSet = extensionPoints.entrySet();
        for (Map.Entry entry : pointsSet) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            ExtensionPoint point = (ExtensionPoint)entry.getValue();
            BundleDescriptor bundleDescriptor = point.getContributedBy();
            List<ExtensionPoint> listOfExtensions = this.extensionPointsByBundle.get(bundleDescriptor);
            if (listOfExtensions == null) {
                ArrayList<ExtensionPoint> bundleExtensions = new ArrayList<ExtensionPoint>(1);
                bundleExtensions.add(point);
                this.extensionPointsByBundle.put(bundleDescriptor, bundleExtensions);
                continue;
            }
            if (listOfExtensions.contains(point)) continue;
            listOfExtensions.add(point);
        }
        Set<Map.Entry<BundleDescriptor, List<ExtensionPoint>>> extensionPointSet = this.extensionPointsByBundle.entrySet();
        ArrayList<ExtensionPoint> points = new ArrayList<ExtensionPoint>();
        for (Map.Entry<BundleDescriptor, List<ExtensionPoint>> entry : extensionPointSet) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            List<ExtensionPoint> list = entry.getValue();
            for (ExtensionPoint extensionPoint : list) {
                if (points.contains(extensionPoint)) continue;
                points.add(extensionPoint);
            }
        }
        return points;
    }

    private void extractElements(IObject instance, Map<String, ExtensionPoint> extensionPoints, Map<Integer, Extension> extensions, Map<Integer, ConfigurationElement> configElements, IProgressListener listener) throws SnapshotException {
        String className = instance.getClazz().getName();
        if (instance.getClazz().doesExtend("java.lang.ref.SoftReference")) {
            ObjectReference ref = ReferenceQuery.getReferent((IInstance)instance);
            if (ref != null) {
                instance = ref.getObject();
                className = instance.getClazz().getName();
            } else {
                return;
            }
        }
        if (className.equals("org.eclipse.core.internal.registry.ExtensionPoint")) {
            ExtensionPoint extensionPoint = this.extractExtensionPointInfo(instance);
            if (extensionPoint != null && !extensionPoints.containsValue(extensionPoint)) {
                extensionPoints.put(extensionPoint.getName(), extensionPoint);
            } else if (extensionPoint != null && instance.getObjectId() != extensionPoint.getObjectId()) {
                MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_DuplicateExtensionPoint, (Object[])new Object[]{extensionPoint.getName(), Long.toHexString(this.snapshot.mapIdToAddress(extensionPoint.getObjectId())), Long.toHexString(instance.getObjectAddress())}));
            }
        } else if (className.equals("org.eclipse.core.internal.registry.ConfigurationElement")) {
            ConfigurationElement configElement = this.extractConfigurationElementInfo(instance, listener);
            if (configElement != null && !configElements.containsValue(configElement)) {
                configElements.put(configElement.getElementId(), configElement);
            } else if (configElement != null && instance.getObjectId() != configElement.getObjectId()) {
                MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_DuplicateConfigurationElement, (Object[])new Object[]{configElement.getName(), Long.toHexString(this.snapshot.mapIdToAddress(configElement.getObjectId())), Long.toHexString(instance.getObjectAddress())}));
            }
        } else if (className.equals("org.eclipse.core.internal.registry.Extension")) {
            Extension extension = this.extractExtensionInfo(instance);
            if (extension != null && !extensions.containsValue(extension)) {
                extensions.put(extension.getExtensionId(), extension);
            } else if (extension != null && instance.getObjectId() != extension.getObjectId()) {
                MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_DuplicateExtension, (Object[])new Object[]{extension.getName(), Long.toHexString(this.snapshot.mapIdToAddress(extension.getObjectId())), Long.toHexString(instance.getObjectAddress())}));
            }
        } else {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_UnknownElementType, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress()), instance.getClazz().getName()}));
        }
    }

    private ConfigurationElement extractConfigurationElementInfo(IObject instance, IProgressListener listener) throws SnapshotException {
        IObject nameObject;
        Field idField = ((IInstance)instance).getField("parentId");
        if (idField == null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ExpectedFieldParent, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
            return null;
        }
        Integer parentId = (Integer)idField.getValue();
        Field objectIdField = ((IInstance)instance).getField("objectId");
        if (objectIdField == null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ExpectedFieldObjectId, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
            return null;
        }
        Integer objectId = (Integer)objectIdField.getValue();
        IObject contributorObject = (IObject)instance.resolveValue("contributorId");
        if (contributorObject == null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ExpectedFieldContributorId, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
            return null;
        }
        Long contributorId = null;
        BundleDescriptor contributedBy = null;
        String contributorIdString = contributorObject.getClassSpecificName();
        try {
            contributorId = Long.valueOf(contributorIdString);
        }
        catch (NumberFormatException e) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_CannotFindContributorID, (Object[])new Object[]{contributorIdString}));
        }
        if (contributorId != null) {
            contributedBy = this.bundleDescriptors.get(contributorId);
        }
        if ((nameObject = (IObject)instance.resolveValue("name")) == null) {
            return null;
        }
        String name = nameObject.getClassSpecificName();
        IObject propertiesObject = (IObject)instance.resolveValue("propertiesAndValue");
        if (propertiesObject == null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ExpectedFieldPropertiesAndValues, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
        } else {
            if (propertiesObject.getClazz().isArrayType()) {
                long[] addresses = ((IObjectArray)propertiesObject).getReferenceArray();
                String[] propertiesAndValues = new String[addresses.length];
                int i = 0;
                while (i < addresses.length) {
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    if (addresses[i] != 0L) {
                        try {
                            int id = this.snapshot.mapAddressToId(addresses[i]);
                            IObject object = this.snapshot.getObject(id);
                            propertiesAndValues[i] = object.getClassSpecificName();
                        }
                        catch (SnapshotException e) {
                            if (this.maxWarnings-- > 0) {
                                MATPlugin.log(e, MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ReadingProperty, (Object[])new Object[]{Long.toHexString(addresses[i])}));
                            }
                            propertiesAndValues[i] = null;
                        }
                    }
                    ++i;
                }
                return new ConfigurationElement(instance.getObjectId(), name, parentId, objectId, contributedBy, propertiesAndValues);
            }
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ExpectedStringArray, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
        }
        return new ConfigurationElement(instance.getObjectId(), name, parentId, objectId, contributedBy, null);
    }

    private Extension extractExtensionInfo(IObject instance) throws SnapshotException {
        String[] properties = this.getExtensionProperties(instance);
        if (properties == null) {
            return null;
        }
        Field id = ((IInstance)instance).getField("objectId");
        if (id == null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ExpectedFieldObjectId, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
            return null;
        }
        Integer extensionId = (Integer)id.getValue();
        Extension extension = new Extension(instance.getObjectId(), extensionId, properties);
        Long contributorId = null;
        String contributorIdString = extension.getContributorId();
        try {
            contributorId = Long.valueOf(contributorIdString);
        }
        catch (NumberFormatException e) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_CannotFindContributorID, (Object[])new Object[]{contributorIdString}));
        }
        if (contributorId != null) {
            BundleDescriptor contributedBy = this.bundleDescriptors.get(contributorId);
            extension.setContributedBy(contributedBy);
        }
        return extension;
    }

    private String[] getExtensionProperties(IObject instance) throws SnapshotException {
        ObjectReference ref;
        IObject extraInfoObject = (IObject)instance.resolveValue("extraInformation");
        if (extraInfoObject == null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ExpectedFieldExtraInformation, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
            return null;
        }
        if (extraInfoObject instanceof IInstance && (ref = ReferenceQuery.getReferent((IInstance)extraInfoObject)) != null) {
            extraInfoObject = ref.getObject();
        }
        if (extraInfoObject.getClazz().isArrayType()) {
            long[] addresses = ((IObjectArray)extraInfoObject).getReferenceArray();
            String[] properties = new String[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                if (addresses[i] != 0L) {
                    int id = this.snapshot.mapAddressToId(addresses[i]);
                    IObject object = this.snapshot.getObject(id);
                    properties[i] = object.getClassSpecificName();
                }
                ++i;
            }
            return properties;
        }
        IObject referentObject = (IObject)extraInfoObject.resolveValue("referent");
        if (referentObject != null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_SoftReferencesNotHandled, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
        }
        return null;
    }

    private ExtensionPoint extractExtensionPointInfo(IObject instance) throws SnapshotException {
        String[] properties = this.getExtensionProperties(instance);
        if (properties == null) {
            return null;
        }
        Field id = ((IInstance)instance).getField("objectId");
        if (id == null) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_ErrorMsg_ExpectedFieldObjectId, (Object[])new Object[]{Long.toHexString(instance.getObjectAddress())}));
            return null;
        }
        Integer extensionPointId = (Integer)id.getValue();
        ExtensionPoint extensionPoint = new ExtensionPoint(instance.getObjectId(), extensionPointId, properties);
        Long contributorId = null;
        String contributorIdString = extensionPoint.getContributorId();
        try {
            contributorId = Long.valueOf(contributorIdString);
        }
        catch (NumberFormatException e) {
            MATPlugin.log(MessageUtil.format((String)Messages.EquinoxBundleReader_CannotFindContributorID, (Object[])new Object[]{contributorIdString}));
        }
        if (contributorId != null) {
            BundleDescriptor contributedBy = this.bundleDescriptors.get(contributorId);
            extensionPoint.setContributedBy(contributedBy);
        }
        return extensionPoint;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BundleState {
        ACTIVE(Messages.EquinoxBundleReader_State_Active, 4),
        INSTALLED(Messages.EquinoxBundleReader_State_Installed, 0),
        RESOLVED(Messages.EquinoxBundleReader_State_Resolved, 1),
        LAZY_STARTING(Messages.EquinoxBundleReader_State_LazyStarting, 2),
        STARTING(Messages.EquinoxBundleReader_State_Starting, 3),
        STOPPING(Messages.EquinoxBundleReader_State_Stopping, 5),
        UNINSTALLED(Messages.EquinoxBundleReader_State_Uninstalled, -1);

        private String label;
        private int value;

        private BundleState(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public int getValue() {
            return this.value;
        }
    }
}

