/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;

public class MavenSourcePathComputer
implements ISourcePathComputer {
    public String getId() {
        return "org.eclipse.m2e.launching.MavenSourceComputer";
    }

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        final ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>();
        IRuntimeClasspathEntry jreEntry = JavaRuntime.computeJREEntry((ILaunchConfiguration)configuration);
        if (jreEntry != null) {
            entries.add(jreEntry);
        }
        AbstractMavenRuntime runtime = MavenLaunchUtils.getMavenRuntime(configuration);
        IMavenLauncherConfiguration collector = new IMavenLauncherConfiguration(){

            public void addArchiveEntry(String entry) {
                MavenSourcePathComputer.this.addArchiveRuntimeClasspathEntry(entries, entry);
            }

            public void addProjectEntry(IMavenProjectFacade facade) {
                IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
                if (javaProject != null) {
                    entries.add(JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)javaProject));
                }
            }

            public void addRealm(String world) {
            }

            public void setMainType(String type, String world) {
            }
        };
        for (String entry : MavenLaunchUtils.getCliResolver(runtime)) {
            collector.addArchiveEntry(entry);
        }
        runtime.createLauncherConfiguration(collector, monitor);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries.toArray(new IRuntimeClasspathEntry[entries.size()]), (ILaunchConfiguration)configuration);
        return JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
    }

    protected void addArchiveRuntimeClasspathEntry(List<IRuntimeClasspathEntry> entries, String entryPath) {
        File entryFile = new File(entryPath);
        if (!entryFile.exists()) {
            return;
        }
        if (entryFile.isDirectory()) {
            String[] files;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(entryFile);
            ds.setIncludes(new String[]{"META-INF/maven/*/*/pom.properties"});
            ds.scan();
            String[] stringArray = files = ds.getIncludedFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(entryFile, file)));){
                    this.addArchiveRuntimeClasspathEntry(entries, entryPath, is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n2;
            }
        } else {
            try (JarFile jar = new JarFile(entryFile);){
                Enumeration<JarEntry> zes = jar.entries();
                while (zes.hasMoreElements()) {
                    JarEntry ze = zes.nextElement();
                    String name = ze.getName();
                    if (ze.isDirectory() || !name.startsWith("META-INF/maven/") || !name.endsWith("pom.properties")) continue;
                    this.addArchiveRuntimeClasspathEntry(entries, entryPath, jar.getInputStream(ze));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addArchiveRuntimeClasspathEntry(List<IRuntimeClasspathEntry> entries, String entryPath, InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        String groupId = p.getProperty("groupId");
        String artifactId = p.getProperty("artifactId");
        String version = p.getProperty("version");
        File sourcesJar = this.getSourcesJar(groupId, artifactId, version);
        if (sourcesJar != null) {
            IRuntimeClasspathEntry entry = null;
            entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)Path.fromOSString((String)entryPath));
            entry.setSourceAttachmentPath(Path.fromOSString((String)sourcesJar.getAbsolutePath()));
            entries.add(entry);
        }
    }

    private File getSourcesJar(String groupId, String artifactId, String version) {
        if (groupId != null && artifactId != null && version != null) {
            IMaven maven = MavenPlugin.getMaven();
            try {
                Artifact artifact = maven.resolve(groupId, artifactId, version, "jar", "sources", null, null);
                File file = artifact.getFile();
                if (file != null && file.exists() && file.canRead()) {
                    return file;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }
}

