/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.callgraph.core.CallgraphCorePlugin;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;

public class SystemTapErrorHandler {
    public static final String FILE_PROP = "errors.prop";
    private final int LINE_LIMIT = 300;
    private boolean errorRecognized = false;
    private StringBuilder errorMessage = new StringBuilder("");
    private StringBuilder logContents;

    public SystemTapErrorHandler() {
        this.errorMessage.append(String.valueOf(Messages.getString("SystemTapErrorHandler.ErrorMessage")) + Messages.getString("SystemTapErrorHandler.ErrorMessage1"));
        this.logContents = new StringBuilder();
    }

    /*
     * Unable to fully structure code
     */
    public void handle(IProgressMonitor m, String errors) {
        errorsList = errors.split("\n");
        file = new File(String.valueOf(PluginConstants.getPluginLocation()) + "errors.prop");
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                buff1 = new BufferedReader(new FileReader(file));
                try {
                    var12_11 = errorsList;
                    var11_12 = errorsList.length;
                    var10_13 = 0;
                    while (var10_13 < var11_12) {
                        message = var12_11[var10_13];
                        var13_16 = null;
                        var14_18 = null;
                        try {
                            innerBuff = new BufferedReader(new FileReader(file));
                            try {
                                while ((line = innerBuff.readLine()) != null) {
                                    if (m != null && m.isCanceled()) {
                                        while (true) {
                                            if (buff1 != null) {
                                                buff1.close();
                                            }
                                            return;
                                        }
                                    }
                                    index = line.indexOf(61);
                                    pat = Pattern.compile(line.substring(0, index), 32);
                                    matcher = pat.matcher(message);
                                    if (!matcher.matches()) continue;
                                    if (!this.isErrorRecognized()) {
                                        this.errorMessage.append(Messages.getString("SystemTapErrorHandler.ErrorMessage2"));
                                        this.errorRecognized = true;
                                    }
                                    errorFound = line.substring(index + 1);
                                    if (!this.errorMessage.toString().contains(errorFound)) {
                                        this.errorMessage.append(String.valueOf(errorFound) + "\n");
                                    }
                                    break;
                                }
                            }
                            finally {
                                if (innerBuff == null) ** continue;
                                innerBuff.close();
                            }
                        }
                        catch (Throwable var14_19) {
                            if (var13_16 == null) {
                                var13_16 = var14_19;
                            } else if (var13_16 != var14_19) {
                                var13_16.addSuppressed(var14_19);
                            }
                            throw var13_16;
                        }
                        ++var10_13;
                    }
                    this.logContents.append(errors);
                }
                finally {
                    if (buff1 != null) {
                        buff1.close();
                    }
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                } else if (var5_5 != var6_9) {
                    var5_5.addSuppressed(var6_9);
                }
                throw var5_5;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void appendToLog(String header) {
        this.logContents.append(header);
    }

    public void handle(IProgressMonitor m, FileReader f) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(f);
        StringBuilder builder = new StringBuilder();
        int counter = 0;
        while ((line = br.readLine()) != null) {
            ++counter;
            builder.append(String.valueOf(line) + "\n");
            if (m != null && m.isCanceled()) {
                return;
            }
            if (counter != 300) continue;
            this.handle(m, builder.toString());
            builder = new StringBuilder();
            counter = 0;
        }
        this.handle(m, builder.toString());
    }

    public void finishHandling() {
        if (!this.isErrorRecognized()) {
            this.errorMessage.append(String.valueOf(Messages.getString("SystemTapErrorHandler.NoErrRecognized")) + Messages.getString("SystemTapErrorHandler.NoErrRecognizedMsg"));
            this.writeToLog();
        }
    }

    private void writeToLog() {
        Status status = new Status(1, "org.eclipse.linuxtools.callgraph.core", this.logContents.toString());
        CallgraphCorePlugin.getDefault().getLog().log((IStatus)status);
        this.logContents = new StringBuilder();
    }

    public boolean isErrorRecognized() {
        return this.errorRecognized;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }
}

