/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.helpers.app.editors.properties.method;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.application.ApplicationPackage;
import org.eclipse.jwt.we.helpers.app.editors.properties.method.MethodNameLabelProvider;
import org.eclipse.jwt.we.helpers.app.jdt.JDTTools;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomMethodPropertyDescriptor
extends PropertyDescriptor {
    private Application application;

    public CustomMethodPropertyDescriptor(Object application, IItemPropertyDescriptor itemPropertyDescriptor) {
        super(application, itemPropertyDescriptor);
        this.application = (Application)application;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        Object methodEditor = null;
        try {
            List<IMethod> methods = JDTTools.getMethodList(this.application.getJavaClass(), JDTTools.getJavaProject(this.application));
            methodEditor = methods.size() > 0 ? new ExtendedComboBoxCellEditor(parent, CustomMethodPropertyDescriptor.getComboEntriesFromMethods(methods), (ILabelProvider)new MethodNameLabelProvider(methods)) : new PropertyDescriptor.EDataTypeCellEditor((EDataType)ApplicationPackage.Literals.APPLICATION__METHOD.getEType(), parent);
        }
        catch (JavaModelException javaModelException) {
            System.err.println("Class [" + this.application.getJavaClass() + "] could not be found in specified runtime class path");
        }
        if (methodEditor == null) {
            methodEditor = new PropertyDescriptor.EDataTypeCellEditor((EDataType)ApplicationPackage.Literals.APPLICATION__METHOD.getEType(), parent);
        }
        return methodEditor;
    }

    public static List<String> getComboEntriesFromMethods(List<IMethod> methods) {
        ArrayList<String> res = new ArrayList<String>();
        for (IMethod method : methods) {
            res.add(method.getElementName());
        }
        return res;
    }
}

