/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractShowWhereUsedQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;

public class ShowWhereUsedComponentNameQuery
extends AbstractShowWhereUsedQuery {
    private IComponentNamePO m_compName;

    public ShowWhereUsedComponentNameQuery(IComponentNamePO compName) {
        super("org.eclipse.jubula.client.ui.rcp.views.CompNamesView");
        this.m_compName = compName;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp());
        sb.append(":");
        sb.append(" ");
        sb.append(Messages.UIJobSearchingCompNames);
        sb.append(" \"");
        sb.append(this.getCompName().getName());
        sb.append("\"");
        return sb.toString();
    }

    public IStatus run(IProgressMonitor monitor) {
        this.calculateUseOfLogicalName(this.getCompName().getGuid(), monitor);
        return Status.OK_STATUS;
    }

    protected void calculateUseOfLogicalName(String logicalName, IProgressMonitor monitor) {
        Set<INodePO> reuse = this.findNodes(logicalName, monitor);
        ArrayList<BasicSearchResult.SearchResultElement> reuseLoc = new ArrayList<BasicSearchResult.SearchResultElement>(reuse.size());
        reuseLoc.addAll(this.getSearchResultListFromNodes(reuse));
        Set reuseAssocs = ComponentNamesBP.findAssocsOfReuse((Collection)GeneralStorage.getInstance().getProject().getAutMainList(), (String)logicalName);
        for (IObjectMappingAssoziationPO assoc : reuseAssocs) {
            IAUTMainPO aut = null;
            IObjectMappingCategoryPO cat = assoc.getCategory();
            while (cat.getParent() != null) {
                cat = cat.getParent();
            }
            for (IAUTMainPO projAut : GeneralStorage.getInstance().getProject().getAutMainList()) {
                if (!projAut.getObjMap().getMappedCategory().equals(cat)) continue;
                aut = projAut;
                break;
            }
            StringBuilder assocSb = new StringBuilder();
            if (aut != null) {
                assocSb.append(aut.getName()).append(" ").append("/").append(" ");
            }
            assocSb.append(assoc.getTechnicalName().getComponentNameToDisplay());
            reuseLoc.add(new BasicSearchResult.SearchResultElement<Long>(assocSb.toString(), assoc.getId(), IconConstants.TECHNICAL_NAME_IMAGE, new BasicSearchResult.ObjectMappingSearchResultElementAction()));
        }
        this.setSearchResult(reuseLoc);
        monitor.done();
    }

    protected Set<INodePO> findNodes(String logicalName, IProgressMonitor monitor) {
        HashSet<INodePO> reuse = new HashSet<INodePO>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        reuse.addAll(ComponentNamesBP.findNodesOfReuse((Collection)project.getUnmodSpecList(), (Collection)TestSuiteBP.getListOfTestSuites((IProjectPO)project), (String)logicalName, (IProgressMonitor)monitor));
        return reuse;
    }

    protected IComponentNamePO getCompName() {
        return this.m_compName;
    }
}

