/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.AbstractNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.ParamNamePM;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.persistence.locking.LockedObjectPO;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompNamePM
extends AbstractNamePM {
    private static final String COMP_NAME_TABLE_ID = "org.eclipse.jubula.client.core.model.ComponentNamePO";
    private static final String P_COMP_NAME_GUID = "compNameGuid";
    private static final String P_PARENT_PROJECT_ID = "parentProjectId";
    private static final String P_NAME = "logName";
    private static final String Q_PREEX_NAMES_SINGLE = "select compName from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjectId and compName.hbmName = :logName";
    private static final String Q_NUM_REUSE_TYPE_PAIRS = "select count(compNamePair) from CompNamesPairPO as compNamePair where (compNamePair.secondName = :compNameGuid or compNamePair.firstName = :compNameGuid) and compNamePair.hbmParentProjectId = :parentProjectId";
    private static final String Q_REUSE_TYPE_CAPS_COUNT = "select count (cap.componentType) from CapPO as cap where cap.componentName = :compNameGuid and cap.hbmParentProjectId = :parentProjectId";
    private static final String Q_REF_COMP_NAME_GUIDS = "select compName.hbmGuid from ComponentNamePO as compName where compName.hbmReferencedGuid is not null and compName.hbmParentProjectId = :parentProjectId";
    private static final String Q_CAP_COMP_NAME_GUIDS = "select cap.componentName from CapPO as cap where cap.hbmParentProjectId = :parentProjectId";
    private static final String Q_ASSOC_COUNT = " select count(assoc) from ObjectMappingAssoziationPO as assoc join assoc.logicalNames as logical where logical = :compNameGuid and assoc.technicalName is not null and assoc.hbmParentProjectId = :parentProjectId";
    private static final String Q_PAIR_FIRST_COMP_NAME_GUIDS = "select pair.firstName from CompNamesPairPO as pair where pair.hbmParentProjectId = :parentProjectId";
    private static final String Q_PAIR_SECOND_COMP_NAME_GUIDS = "select pair.secondName from CompNamesPairPO as pair where pair.hbmParentProjectId = :parentProjectId";
    private static final String Q_ASSOC_COMP_NAME_GUIDS = "select logicalName from ObjectMappingAssoziationPO as assoc join assoc.logicalNames as logicalName where assoc.hbmParentProjectId = :parentProjectId";
    private static final String Q_COMP_NAME_REF_GUIDS = "select compName.hbmReferencedGuid from ComponentNamePO as compName where compName.hbmReferencedGuid is not null and compName.hbmParentProjectId = :parentProjectId";
    private static final String P_COMP_NAME_REMOVAL_LIST = "compNameRemovalList";
    private static final String Q_DELETE_COMP_NAMES = "delete from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjectId and compName.hbmGuid in :compNameRemovalList";
    private static Logger log = LoggerFactory.getLogger(ParamNamePM.class);
    private static LockedObjectPO lockObj = null;

    public static final List<IComponentNamePO> readAllCompNamesRO(Long parentProjectId) throws PMException {
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        return CompNamePM.readAllCompNames(parentProjectId, s);
    }

    private static final List<IComponentNamePO> readAllCompNames(Long parentProjectId, EntityManager s) throws PMException {
        ArrayList<IComponentNamePO> compNames = new ArrayList<IComponentNamePO>();
        try {
            Query q = s.createQuery("select compName from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjId");
            q.setParameter("parentProjId", (Object)parentProjectId);
            compNames.addAll(q.getResultList());
        }
        catch (PersistenceException e) {
            OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
            log.error(String.valueOf(Messages.CouldNotReadComponentNamesFromDBOfProjectWithID) + " " + "'" + String.valueOf(parentProjectId) + "'", (Throwable)e);
            PersistenceManager.handleDBExceptionForAnySession(null, e, s);
        }
        return compNames;
    }

    public static final void deleteCompNames(EntityManager s, Long rootProjId) throws PMException {
        try {
            CompNamePM.lockComponentNames(s);
            Query q = s.createQuery("delete from ComponentNamePO c where c.hbmParentProjectId = :rootProjId");
            q.setParameter("rootProjId", (Object)rootProjId);
            q.executeUpdate();
        }
        catch (PersistenceException e) {
            OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
            log.error(String.valueOf(Messages.CouldNotReadComponentNamesFromDBOfProjectWithID) + " " + "'" + String.valueOf(rootProjId) + "'", (Throwable)e);
            PersistenceManager.handleDBExceptionForAnySession(null, e, s);
        }
    }

    private static final void lockComponentNames(EntityManager s) throws PMObjectDeletedException, PMAlreadyLockedException {
        try {
            if (lockObj == null) {
                CompNamePM.initLockedObj();
            }
            long start = System.currentTimeMillis();
            while (!LockManager.instance().lockPO(s, lockObj, false)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                long stop = System.currentTimeMillis();
                if (stop - start <= 5000L) continue;
                throw new PMAlreadyLockedException(lockObj, Messages.CouldNotGetALockOnTableCOMPONENT_NAMES, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        catch (PMDirtyVersionException e) {
            Assert.notReached((String)(String.valueOf(Messages.ExceptionShouldNotHappen) + ":" + " " + (Object)((Object)e)));
        }
    }

    private static final void unlockComponentNames() {
        if (lockObj != null) {
            LockManager.instance().unlockPO(lockObj);
        }
    }

    private static void loadLockedObj() {
        EntityManager sess = null;
        try {
            try {
                sess = Persistor.instance().openSession();
                EntityTransaction tx = sess.getTransaction();
                tx.begin();
                Query q = sess.createQuery("select p from LockedObjectPO p where p.hbmObjectName = :hbmObjectName");
                q.setParameter("hbmObjectName", (Object)COMP_NAME_TABLE_ID);
                try {
                    lockObj = (LockedObjectPO)q.getSingleResult();
                }
                catch (NoResultException noResultException) {
                    lockObj = null;
                }
                tx.commit();
            }
            catch (PersistenceException e) {
                throw new JBFatalAbortException(String.valueOf(Messages.ErrorInitializingComponentNamesLocking) + "!", (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(sess);
        }
    }

    private static void initLockedObj() {
        CompNamePM.createOrUpdateCompNamesLock();
        CompNamePM.loadLockedObj();
    }

    private static void createOrUpdateCompNamesLock() throws PersistenceException {
        EntityManager s = null;
        EntityTransaction tx = null;
        try {
            try {
                s = Persistor.instance().openSession();
                tx = s.getTransaction();
                tx.begin();
                Query q = s.createQuery("select p from LockedObjectPO p where p.hbmObjectName = :hbmObjectName");
                q.setParameter("hbmObjectName", (Object)COMP_NAME_TABLE_ID);
                try {
                    q.getSingleResult();
                }
                catch (NoResultException noResultException) {
                    s.persist((Object)new LockedObjectPO(COMP_NAME_TABLE_ID));
                }
                tx.commit();
            }
            catch (PersistenceException e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        finally {
            Persistor.instance().dropSession(s);
        }
    }

    public static synchronized long getNumberOfUsages(EntityManager session, Long parentProjectId, String compNameGuid) {
        long referenceCount = 0L;
        FlushModeType flushMode = session.getFlushMode();
        session.setFlushMode(FlushModeType.COMMIT);
        try {
            referenceCount += CompNamePM.countOfReusedCompnameTypesInCaps(session, parentProjectId, compNameGuid);
            IProjectPO cfr_ignored_0 = (IProjectPO)session.find(NodeMaker.getProjectPOClass(), (Object)parentProjectId);
            referenceCount += CompNamePM.getAutAssociations(session, parentProjectId, compNameGuid);
        }
        finally {
            session.setFlushMode(flushMode);
        }
        return referenceCount += CompNamePM.getNumPairs(compNameGuid, parentProjectId, session);
    }

    private static long getAutAssociations(EntityManager session, Long parentProjectId, String compNameGuid) {
        StringBuilder capQuerySb = new StringBuilder(Q_ASSOC_COUNT);
        Query capQuery = session.createQuery(capQuerySb.toString());
        capQuery.setParameter(P_PARENT_PROJECT_ID, (Object)parentProjectId);
        capQuery.setParameter(P_COMP_NAME_GUID, (Object)compNameGuid);
        long res = (Long)capQuery.getSingleResult();
        return res;
    }

    private static long countOfReusedCompnameTypesInCaps(EntityManager session, Long parentProjectId, String compNameGuid) {
        StringBuilder capQuerySb = new StringBuilder(Q_REUSE_TYPE_CAPS_COUNT);
        Query capQuery = session.createQuery(capQuerySb.toString());
        capQuery.setParameter(P_PARENT_PROJECT_ID, (Object)parentProjectId);
        capQuery.setParameter(P_COMP_NAME_GUID, (Object)compNameGuid);
        return (Long)capQuery.getSingleResult();
    }

    private static long getNumPairs(String compNameGuid, Long parentProjectId, EntityManager session) {
        StringBuilder reuseQuerySb = new StringBuilder(Q_NUM_REUSE_TYPE_PAIRS);
        Query reuseQuery = session.createQuery(reuseQuerySb.toString());
        reuseQuery.setParameter(P_PARENT_PROJECT_ID, (Object)parentProjectId);
        reuseQuery.setParameter(P_COMP_NAME_GUID, (Object)compNameGuid);
        new HashSet();
        return (Long)reuseQuery.getResultList().get(0);
    }

    public static SaveCompNamesData flushCompNames(EntityManager sess, Long projId, IWritableComponentNameCache cache) {
        ArrayList<IComponentNamePO> dbVersions = new ArrayList<IComponentNamePO>();
        HashMap<String, String> guidsToSwap = new HashMap<String, String>();
        Map<String, IComponentNamePO> localChanges = cache.getLocalChanges();
        if (localChanges == null) {
            return null;
        }
        IComponentNamePO dbPO = null;
        IComponentNamePO newCN = null;
        Query q = sess.createQuery(Q_PREEX_NAMES_SINGLE);
        q.setParameter(P_PARENT_PROJECT_ID, (Object)projId).setMaxResults(1);
        for (String guid : localChanges.keySet()) {
            newCN = localChanges.get(guid);
            if (newCN.getParentProjectId() == null || projId.equals(newCN.getParentProjectId())) {
                q.setParameter(P_NAME, (Object)newCN.getName());
                List resList = q.getResultList();
                if (!resList.isEmpty()) {
                    if (!((IComponentNamePO)resList.get(0)).getGuid().equals(guid)) {
                        newCN = (IComponentNamePO)resList.get(0);
                        guidsToSwap.put(guid, ((IComponentNamePO)resList.get(0)).getGuid());
                    } else {
                        newCN.setId(((IComponentNamePO)resList.get(0)).getId());
                    }
                    sess.detach(resList.get(0));
                }
            }
            dbPO = null;
            if (newCN.getId() != null) {
                dbPO = (IComponentNamePO)sess.find(newCN.getClass(), (Object)newCN.getId());
            }
            if (dbPO == null) {
                sess.persist((Object)newCN);
                dbPO = newCN;
            }
            if (newCN.getName() != null) {
                dbPO.setName(newCN.getName());
            }
            if (dbPO.getParentProjectId() == null) {
                dbPO.setParentProjectId(projId);
            }
            dbVersions.add(dbPO);
        }
        if (!guidsToSwap.isEmpty()) {
            cache.handleExistingNames(guidsToSwap);
        }
        return new SaveCompNamesData(dbVersions, guidsToSwap);
    }

    public static void flushCompNamesImport(EntityManager sess, Long projId, IWritableComponentNameCache cache) {
        Map<String, IComponentNamePO> localChanges = cache.getLocalChanges();
        for (String guid : localChanges.keySet()) {
            IComponentNamePO cN = localChanges.get(guid);
            if (cN.getParentProjectId() == null) {
                cN.setParentProjectId(projId);
            }
            sess.persist((Object)localChanges.get(guid));
        }
    }

    public static void removeUnusedCompNames(Long projectId, EntityManager session) {
        Query refCompNameGuidQuery = session.createQuery(Q_REF_COMP_NAME_GUIDS);
        refCompNameGuidQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List refCompNameGuids = refCompNameGuidQuery.getResultList();
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query capQuery = session.createQuery(Q_CAP_COMP_NAME_GUIDS);
        capQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List capCompNames = capQuery.getResultList();
        refCompNameGuids.removeAll(capCompNames);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query pairQuery = session.createQuery(Q_PAIR_FIRST_COMP_NAME_GUIDS);
        pairQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List pairCompNameGuids = pairQuery.getResultList();
        refCompNameGuids.removeAll(pairCompNameGuids);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        pairQuery = session.createQuery(Q_PAIR_SECOND_COMP_NAME_GUIDS);
        pairQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        pairCompNameGuids = pairQuery.getResultList();
        refCompNameGuids.removeAll(pairCompNameGuids);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query assocQuery = session.createQuery(Q_ASSOC_COMP_NAME_GUIDS);
        assocQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List assocCompNameGuids = assocQuery.getResultList();
        refCompNameGuids.removeAll(assocCompNameGuids);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query compNameRefQuery = session.createQuery(Q_COMP_NAME_REF_GUIDS);
        compNameRefQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List compNameRefGuidList = compNameRefQuery.getResultList();
        refCompNameGuids.removeAll(compNameRefGuidList);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query deleteQuery = session.createQuery(Q_DELETE_COMP_NAMES);
        deleteQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        deleteQuery.setParameter(P_COMP_NAME_REMOVAL_LIST, (Object)refCompNameGuids);
        deleteQuery.executeUpdate();
    }

    public static void dispose() {
        lockObj = null;
    }

    public static class SaveCompNamesData {
        private List<IComponentNamePO> m_dbVersions;
        private Map<String, String> m_guidsToSwap;

        public SaveCompNamesData(List<IComponentNamePO> dbVersions, Map<String, String> guidsToSwap) {
            this.m_dbVersions = dbVersions;
            this.m_guidsToSwap = guidsToSwap;
        }

        public List<IComponentNamePO> getDBVersions() {
            return this.m_dbVersions;
        }

        public Map<String, String> getGuidsToSwap() {
            return this.m_guidsToSwap;
        }
    }
}

