/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query.internal.taglib;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelManagerFactory;
import org.eclipse.jst.jsf.common.metadata.query.AbstractEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.IHierarchicalEntityVisitor;
import org.eclipse.jst.jsf.common.metadata.query.internal.IPredicateMatcher;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleResultSet;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainEntityPredicateMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaglibDomainEntityQuerySpecVisitor
extends AbstractEntityQueryVisitor
implements IHierarchicalEntityVisitor {
    private HierarchicalSearchControl _control;
    private ITaglibDomainEntityPredicateMatcher _matcher;
    private IMetaDataDomainContext _context;
    private List<Entity> _entityResults;
    private Model _initialEntity;
    private boolean _stop;

    public TaglibDomainEntityQuerySpecVisitor(IMetaDataDomainContext context, ITaglibDomainEntityPredicateMatcher matcher) {
        this(context, matcher, new HierarchicalSearchControl());
    }

    public TaglibDomainEntityQuerySpecVisitor(IMetaDataDomainContext context, ITaglibDomainEntityPredicateMatcher matcher, HierarchicalSearchControl control) {
        this._matcher = matcher;
        this._context = context;
        this._control = control;
    }

    public IResultSet<Entity> findEntities() {
        this._matcher.reset();
        IMetaDataModelManager mgr = MetaDataModelManagerFactory.getMetaDataModelManagerInstance(this.getProject());
        if (mgr != null) {
            Model model = mgr.getModel(this.getModelContext());
            this.findEntities(model);
        }
        return new SimpleResultSet<Entity>(this.getInternalEntityResults());
    }

    private void findEntities(Model model) {
        if (model != null) {
            this._initialEntity = model;
            this._initialEntity.accept(this);
        }
    }

    private List<Entity> getInternalEntityResults() {
        if (this._entityResults == null) {
            this._entityResults = new ArrayList<Entity>();
        }
        return this._entityResults;
    }

    private IMetaDataModelContext getModelContext() {
        return new MetaDataModelContext(this.getProject(), this._context.getDomainId(), this._matcher.getUri());
    }

    private IProject getProject() {
        return (IProject)this._context.getAdapter(IProject.class);
    }

    @Override
    public boolean visitEnter(Entity entity) {
        this._matcher.pushLevel();
        if (this._matcher.getCurrentLevel() <= this._matcher.getMaxLevel()) {
            IPredicateMatcher.MATCH match = this._matcher.matches(entity);
            if (match == IPredicateMatcher.MATCH.FULLY) {
                this.getInternalEntityResults().add(entity);
                this.checkShouldStopVisitingEntities();
                return false;
            }
            if (match == IPredicateMatcher.MATCH.PARTIALLY) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisitingEntities() {
        if (!this._stop && this._control.getCountLimit() == this.getInternalEntityResults().size() && this._control.getCountLimit() != -1) {
            this._stop = true;
        }
    }

    @Override
    public boolean visitLeave(Entity entity) {
        if (entity != this._initialEntity) {
            this._matcher.popLevel();
        }
        return true;
    }

    @Override
    public void visit(Entity key) {
    }
}

