/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResult2;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.util.EscapeUtils;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.FederatedSearchSorter;
import org.eclipse.help.ui.internal.views.SearchResultsPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Bundle;

public class EngineResultSection {
    private static final String KEY_PREFIX_GRAYED = "grayed:";
    private static final String CAT_HEADING_PREFIX = "catheading:";
    private SearchResultsPart part;
    private EngineDescriptor desc;
    private IStatus errorStatus;
    private ArrayList<ISearchEngineResult> hits;
    private Section section;
    private Composite container;
    private FormText searchResults;
    private ImageHyperlink prevLink;
    private ImageHyperlink nextLink;
    private boolean needsUpdating;
    private FederatedSearchSorter sorter;
    private int HITS_PER_PAGE = 10;
    private static final String HREF_PROGRESS = "__progress__";
    private static final String PROGRESS_VIEW = "org.eclipse.ui.views.ProgressView";
    private int resultOffset = 0;

    public EngineResultSection(SearchResultsPart part, EngineDescriptor desc) {
        this.part = part;
        this.desc = desc;
        this.hits = new ArrayList();
        this.sorter = new FederatedSearchSorter();
    }

    public boolean hasControl(Control control) {
        return this.searchResults.equals(control);
    }

    public boolean matches(EngineDescriptor desc) {
        return this.desc == desc;
    }

    public Control createControl(Composite parent, FormToolkit toolkit) {
        this.section = toolkit.createSection(parent, 8802);
        this.container = toolkit.createComposite((Composite)this.section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.verticalSpacing = 0;
        this.container.setLayout((Layout)layout);
        this.createFormText(this.container, toolkit);
        this.searchResults.setLayoutData((Object)new TableWrapData(256));
        this.searchResults.setColor("summary", parent.getDisplay().getSystemColor(17));
        this.section.setClient((Control)this.container);
        this.updateSectionTitle(0);
        this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (EngineResultSection.this.needsUpdating) {
                    EngineResultSection.this.asyncUpdateResults(true, false);
                }
            }
        });
        return this.section;
    }

    private void createFormText(Composite parent, FormToolkit toolkit) {
        this.searchResults = toolkit.createFormText(parent, false);
        this.searchResults.setColor("org.eclipse.ui.forms.TITLE", toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.searchResults.marginHeight = 5;
        String topicKey = "obj16/topic_small.gif";
        String searchKey = "etool16/helpsearch_co.gif";
        this.searchResults.setImage(topicKey, HelpUIResources.getImage(topicKey));
        this.searchResults.setImage(searchKey, HelpUIResources.getImage(searchKey));
        this.searchResults.setColor("summary", parent.getDisplay().getSystemColor(17));
        this.searchResults.setImage("IMG_TOOL_FORWARD", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        this.searchResults.setImage("IMG_TOOL_BACK", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        this.searchResults.setImage("IMG_OBJS_ERROR_TSK", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        this.searchResults.setImage(this.desc.getId(), this.desc.getIconImage());
        this.searchResults.setImage(KEY_PREFIX_GRAYED + this.desc.getId(), this.getGrayedImage(this.desc.getIconImage()));
        this.searchResults.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                String shref = (String)href;
                if (EngineResultSection.HREF_PROGRESS.equals(href)) {
                    EngineResultSection.this.showProgressView();
                } else if (shref.startsWith("bmk:")) {
                    EngineResultSection.this.doBookmark(e.getLabel(), shref);
                } else if (shref.startsWith(EngineResultSection.CAT_HEADING_PREFIX)) {
                    EngineResultSection.this.part.doCategoryLink(shref.substring(EngineResultSection.CAT_HEADING_PREFIX.length()));
                } else {
                    EngineResultSection.this.part.doOpenLink(e.getHref());
                }
            }

            public void linkEntered(HyperlinkEvent e) {
                ((EngineResultSection)EngineResultSection.this).part.parent.handleLinkEntered(e);
            }

            public void linkExited(HyperlinkEvent e) {
                ((EngineResultSection)EngineResultSection.this).part.parent.handleLinkExited(e);
            }
        });
        this.initializeText();
        this.part.parent.hookFormText(this.searchResults);
        this.needsUpdating = true;
    }

    private void initializeText() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.views");
        if (bundle != null) {
            StringBuilder buff = new StringBuilder();
            buff.append("<form>");
            buff.append("<p><a href=\"");
            buff.append(HREF_PROGRESS);
            buff.append("\"");
            if (!Platform.getWS().equals("gtk")) {
                buff.append(" alt=\"");
                buff.append(Messages.EngineResultSection_progressTooltip);
                buff.append("\"");
            }
            buff.append(">");
            buff.append(Messages.EngineResultSection_searchInProgress);
            buff.append("</a></p></form>");
            this.searchResults.setText(buff.toString(), true, false);
        } else {
            this.searchResults.setText(Messages.EngineResultSection_progress2, false, false);
        }
    }

    private void showProgressView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                page.showView(PROGRESS_VIEW);
            }
            catch (PartInitException e) {
                HelpUIPlugin.logError(Messages.EngineResultSection_progressError, e);
            }
        }
    }

    public synchronized void add(ISearchEngineResult match) {
        this.hits.add(match);
        this.asyncUpdateResults(false, false);
    }

    public synchronized void add(ISearchEngineResult[] matches) {
        int i = 0;
        while (i < matches.length) {
            this.hits.add(matches[i]);
            ++i;
        }
        this.asyncUpdateResults(false, false);
    }

    public synchronized void error(IStatus status) {
        this.errorStatus = status;
        this.asyncUpdateResults(false, false);
    }

    public synchronized void completed() {
        if (this.hits.size() == 0 && !this.searchResults.isDisposed()) {
            this.asyncUpdateResults(false, false);
        }
    }

    public synchronized void canceling() {
        if (this.hits.size() == 0 && !this.searchResults.isDisposed()) {
            StringBuilder buff = new StringBuilder();
            buff.append("<form>");
            buff.append("<p><span color=\"summary\">");
            buff.append(Messages.EngineResultSection_canceling);
            buff.append("</span></p>");
            buff.append("</form>");
            this.searchResults.setText(buff.toString(), true, false);
        }
    }

    private void asyncUpdateResults(boolean now, boolean scrollToBeginning) {
        Runnable runnable = () -> BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), () -> {
            if (this.section.isDisposed()) {
                return;
            }
            this.updateResults(true);
            if (scrollToBeginning) {
                this.searchResults.setFocus();
                FormToolkit.setControlVisible((Control)this.section, (boolean)true);
                this.part.updateSeparatorVisibility();
            }
        });
        if (this.section.isDisposed()) {
            return;
        }
        if (now) {
            PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    private ISearchEngineResult[] getResults() {
        ArrayList<Object> list = this.hits;
        if (this.desc.getEngineTypeId().equals("org.eclipse.help.ui.localSearch") && this.part.parent.isFilteredByRoles()) {
            list = new ArrayList();
            int i = 0;
            while (i < this.hits.size()) {
                ISearchEngineResult hit = this.hits.get(i);
                if (HelpBasePlugin.getActivitySupport().isEnabled(hit.getHref())) {
                    list.add(hit);
                }
                ++i;
            }
        }
        Object[] results = list.toArray(new ISearchEngineResult[list.size()]);
        if (this.part.getShowCategories()) {
            this.sorter.sort(null, results);
        }
        return results;
    }

    private Image getGrayedImage(Image image) {
        Image temp = new Image(image.getDevice(), image, 2);
        ImageData data = temp.getImageData();
        ImageData maskData = data.getTransparencyMask();
        if (maskData != null) {
            int y = 0;
            while (y < maskData.height) {
                int x = 0;
                while (x < maskData.width) {
                    if (maskData.getPixel(x, y) == 0) {
                        data.setAlpha(x, y, 0);
                    } else {
                        data.setAlpha(x, y, 128);
                    }
                    ++x;
                }
                ++y;
            }
            data.maskData = null;
        }
        Image grayed = new Image(image.getDevice(), data);
        temp.dispose();
        return grayed;
    }

    void updateResults(boolean reflow) {
        ISearchEngineResult[] results = this.getResults();
        this.updateSectionTitle(results.length);
        StringBuilder buff = new StringBuilder();
        buff.append("<form>");
        IHelpResource oldCat = null;
        int i = this.resultOffset;
        while (i < results.length) {
            String edesc;
            URL iconURL;
            boolean isPotentialHit;
            if (i - this.resultOffset == this.HITS_PER_PAGE) break;
            ISearchEngineResult hit = results[i];
            IHelpResource cat = hit.getCategory();
            if (this.part.getShowCategories() && cat != null && (oldCat == null || !oldCat.getLabel().equals(cat.getLabel()))) {
                buff.append("<p>");
                if (cat.getHref() != null) {
                    buff.append("<a bold=\"true\" href=\"");
                    String absoluteHref = "";
                    if (cat.getHref().endsWith(".xml")) {
                        absoluteHref = String.valueOf(absoluteHref) + CAT_HEADING_PREFIX;
                    }
                    absoluteHref = String.valueOf(absoluteHref) + hit.toAbsoluteHref(cat.getHref(), true);
                    buff.append(EscapeUtils.escapeSpecialChars(absoluteHref));
                    buff.append("\">");
                    buff.append(cat.getLabel());
                    buff.append("</a>");
                } else {
                    buff.append("<b>");
                    buff.append(cat.getLabel());
                    buff.append("</b>");
                }
                buff.append("</p>");
                oldCat = cat;
            }
            int indent = this.part.getShowCategories() && cat != null ? 26 : 21;
            int bindent = this.part.getShowCategories() && cat != null ? 5 : 0;
            buff.append("<li indent=\"" + indent + "\" bindent=\"" + bindent + "\" style=\"image\" value=\"");
            String imageId = this.desc.getId();
            boolean bl = isPotentialHit = hit instanceof SearchHit && ((SearchHit)hit).isPotentialHit();
            if (hit instanceof ISearchEngineResult2 && (iconURL = ((ISearchEngineResult2)hit).getIconURL()) != null) {
                String id = null;
                id = isPotentialHit ? this.registerGrayedHitIcon(iconURL) : this.registerHitIcon(iconURL);
                if (id != null) {
                    imageId = id;
                }
            }
            if (isPotentialHit) {
                imageId = KEY_PREFIX_GRAYED + imageId;
            }
            buff.append(imageId);
            buff.append("\">");
            buff.append("<a href=\"");
            String href = null;
            if (hit instanceof ISearchEngineResult2) {
                ISearchEngineResult2 hit2 = (ISearchEngineResult2)hit;
                if (((ISearchEngineResult2)hit).canOpen()) {
                    href = "open:" + this.desc.getId() + "?id=" + hit2.getId();
                }
            }
            if (href == null) {
                if (hit.getForceExternalWindow()) {
                    href = "nw:";
                }
                href = EscapeUtils.escapeSpecialChars(hit.toAbsoluteHref(hit.getHref(), false));
            }
            buff.append(href);
            buff.append("\"");
            if (hit.getCategory() != null && Platform.getWS() != "gtk") {
                buff.append(" alt=\"");
                buff.append(hit.getCategory().getLabel());
                buff.append("\"");
            }
            buff.append(">");
            String elabel = null;
            elabel = isPotentialHit ? Messages.bind((String)Messages.SearchPart_potential_hit, (Object)hit.getLabel()) : hit.getLabel();
            elabel = EscapeUtils.escapeSpecialChars(elabel);
            buff.append(elabel);
            buff.append("</a>");
            if (this.part.getShowDescription() && (edesc = hit.getDescription()) != null) {
                edesc = EscapeUtils.escapeSpecialChars(edesc);
                buff.append("<br/>");
                buff.append(edesc);
            }
            buff.append("</li>");
            ++i;
        }
        if (this.errorStatus != null) {
            this.updateErrorStatus(buff);
        }
        this.updateNavigation(results.length);
        buff.append("</form>");
        this.searchResults.setText(buff.toString(), true, false);
        this.section.layout();
        if (reflow) {
            this.part.reflow();
        }
    }

    private String registerHitIcon(URL iconURL) {
        Image image = HelpUIResources.getImage(iconURL);
        if (image != null) {
            this.searchResults.setImage(iconURL.toString(), image);
            return iconURL.toString();
        }
        return null;
    }

    private String registerGrayedHitIcon(URL iconURL) {
        Image image = HelpUIResources.getImage(iconURL);
        if (image != null) {
            this.searchResults.setImage(iconURL.toString(), image);
            return KEY_PREFIX_GRAYED + iconURL.toString();
        }
        return null;
    }

    private void updateErrorStatus(StringBuilder buff) {
        int indent = 21;
        buff.append("<li indent=\"" + indent + "\" style=\"image\" value=\"");
        buff.append("IMG_OBJS_ERROR_TSK");
        buff.append("\">");
        buff.append("<b>");
        buff.append(EscapeUtils.escapeSpecialChars(this.errorStatus.getMessage()));
        buff.append("</b>");
        buff.append("<br/>");
        Throwable t = this.errorStatus.getException();
        if (t != null && t.getMessage() != null) {
            buff.append(EscapeUtils.escapeSpecialChars(t.getMessage()));
        }
        buff.append("</li>");
    }

    private void updateNavigation(int size) {
        if (size > this.HITS_PER_PAGE) {
            if (this.prevLink == null) {
                FormToolkit toolkit = this.part.getToolkit();
                Composite navContainer = toolkit.createComposite(this.container);
                TableWrapData td = new TableWrapData(256);
                navContainer.setLayoutData((Object)td);
                GridLayout glayout = new GridLayout();
                glayout.numColumns = 2;
                navContainer.setLayout((Layout)glayout);
                this.prevLink = toolkit.createImageHyperlink(navContainer, 0);
                this.prevLink.setText(NLS.bind((String)Messages.EngineResultSection_previous, (Object)("" + this.HITS_PER_PAGE)));
                this.prevLink.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
                this.prevLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        EngineResultSection engineResultSection = EngineResultSection.this;
                        engineResultSection.resultOffset = engineResultSection.resultOffset - EngineResultSection.this.HITS_PER_PAGE;
                        EngineResultSection.this.asyncUpdateResults(false, true);
                    }
                });
                this.nextLink = toolkit.createImageHyperlink(navContainer, 131072);
                this.nextLink.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
                GridData gd = new GridData(128);
                gd.grabExcessHorizontalSpace = true;
                this.nextLink.setLayoutData((Object)gd);
                this.nextLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        EngineResultSection engineResultSection = EngineResultSection.this;
                        engineResultSection.resultOffset = engineResultSection.resultOffset + EngineResultSection.this.HITS_PER_PAGE;
                        EngineResultSection.this.asyncUpdateResults(false, true);
                    }
                });
            }
            this.prevLink.setVisible(this.resultOffset > 0);
            int nextOffset = this.resultOffset + this.HITS_PER_PAGE;
            int remainder = this.hits.size() - nextOffset;
            remainder = Math.min(remainder, this.HITS_PER_PAGE);
            this.nextLink.setText(NLS.bind((String)Messages.EngineResultSection_next, (Object)("" + remainder)));
            this.nextLink.setVisible(this.hits.size() > this.resultOffset + this.HITS_PER_PAGE);
        } else if (this.prevLink != null) {
            this.prevLink.getParent().setMenu(null);
            this.prevLink.getParent().dispose();
            this.prevLink = null;
            this.nextLink = null;
        }
    }

    private void updateSectionTitle(int size) {
        if (this.errorStatus != null) {
            Label label = this.part.getToolkit().createLabel((Composite)this.section, null);
            label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            this.section.setTextClient((Control)label);
            this.section.setText(Messages.EngineResultSection_sectionTitle_error);
        } else {
            this.section.setTextClient(null);
        }
        if (size == 1) {
            this.section.setText(NLS.bind((String)Messages.EngineResultSection_sectionTitle_hit, (Object)this.desc.getLabel(), (Object)("" + this.hits.size())));
        } else if (size <= this.HITS_PER_PAGE) {
            this.section.setText(NLS.bind((String)Messages.EngineResultSection_sectionTitle_hits, (Object)this.desc.getLabel(), (Object)("" + this.hits.size())));
        } else {
            int from = this.resultOffset + 1;
            int to = this.resultOffset + this.HITS_PER_PAGE;
            to = Math.min(to, size);
            this.section.setText(NLS.bind((String)Messages.EngineResultSection_sectionTitle_hitsRange, (Object[])new String[]{this.desc.getLabel(), "" + from, "" + to, "" + size}));
        }
    }

    private void doBookmark(String label, String href) {
        String fhref = href.substring(4);
        BusyIndicator.showWhile((Display)this.container.getDisplay(), () -> BaseHelpSystem.getBookmarkManager().addBookmark(fhref, label));
    }

    public void dispose() {
        this.part.parent.unhookFormText(this.searchResults);
        if (!this.section.isDisposed()) {
            this.recursiveSetMenu((Control)this.section, null);
            this.section.dispose();
        }
    }

    private void recursiveSetMenu(Control control, Menu menu) {
        control.setMenu(menu);
        if (control instanceof Composite) {
            Composite parent = (Composite)control;
            Control[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                this.recursiveSetMenu(children[i], menu);
                ++i;
            }
        }
    }
}

