/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.css.ui.commands.RemoveCssEditorNature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddCssEditorNature
extends AbstractHandler
implements IHandler {
    private Logger logger;

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerCreator.createLogger(RemoveCssEditorNature.class);
        }
        return this.logger;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = AddCssEditorNature.getProject(event);
        this.getLogger().debug("adding css nature to " + project.getName());
        try {
            IProjectDescription description = project.getDescription();
            String[] natureIds = description.getNatureIds();
            boolean found = false;
            String[] stringArray = natureIds;
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                if ("org.eclipse.fx.ide.css.nature".equals(natureId)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                String[] newNatureIds = new String[natureIds.length + 1];
                int i = 0;
                i = 0;
                while (i < natureIds.length) {
                    newNatureIds[i] = natureIds[i];
                    ++i;
                }
                newNatureIds[natureIds.length] = "org.eclipse.fx.ide.css.nature";
                description.setNatureIds(newNatureIds);
                project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println(event);
        return null;
    }

    public static IProject getProject(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            return (IProject)Platform.getAdapterManager().getAdapter(element, IProject.class);
        }
        return null;
    }
}

