/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.parsley.listeners.AsyncCommandStackListenerClient;
import org.eclipse.emf.parsley.listeners.AsyncCommandStackListenerHelper;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.emf.parsley.resource.ResourceSaveStrategy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractSaveableView
extends ViewPart
implements ISaveablePart,
IEditingDomainProvider,
AsyncCommandStackListenerClient {
    private Resource resource;
    private static final Logger LOGGER = Logger.getLogger(AbstractSaveableView.class);
    @Inject
    private ResourceLoader resourceLoader;
    @Inject
    private ResourceSaveStrategy resourceSaveStrategy;
    @Inject
    private AsyncCommandStackListenerHelper commandStackListenerHelper;
    @Inject
    private EditingDomain editingDomain;

    public void createPartControl(Composite parent) {
        this.resource = this.loadResource(this.createResourceURI());
        this.commandStackListenerHelper.addCommandStackListener(this.editingDomain, (Widget)this.getSite().getWorkbenchWindow().getShell(), (AsyncCommandStackListenerClient)this, this.resource);
    }

    protected abstract URI createResourceURI();

    protected Resource loadResource(URI uri) {
        return this.resourceLoader.getResource(this.editingDomain, uri).getResource();
    }

    public void mostRecentCommandAffectsResource(Command mostRecentCommand) {
        this.setDirtyAndFirePropertyChange(true);
    }

    protected void setDirtyAndFirePropertyChange(boolean dirtyState) {
        if (!dirtyState) {
            this.getBasicCommandStack().saveIsDone();
        }
        this.firePropertyChange(257);
    }

    protected Resource getResource() {
        return this.resource;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected BasicCommandStack getBasicCommandStack() {
        return (BasicCommandStack)this.getEditingDomain().getCommandStack();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveResourceAndUpdateDirtyState();
        }
        catch (IOException e) {
            LOGGER.error((Object)"doSave", (Throwable)e);
        }
    }

    protected void saveResourceAndUpdateDirtyState() throws IOException {
        if (this.resourceSaveStrategy.save(this.resource)) {
            this.setDirtyAndFirePropertyChange(false);
        }
    }

    public boolean isDirty() {
        return this.getBasicCommandStack().isSaveNeeded();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }
}

