/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceConflict
extends VisualConflict {
    private final boolean containmentConflict = this.getMyOperation(MultiReferenceOperation.class).isAdd() && this.getTheirOperation(MultiReferenceOperation.class).isAdd();

    public MultiReferenceConflict(ConflictBucket conflictBucket, DecisionManager decisionManager, boolean meAdding) {
        super(conflictBucket, decisionManager, meAdding, false);
        this.init();
    }

    public MultiReferenceConflict(ConflictBucket conflictBucket, MultiReferenceOperation leftOperation, MultiReferenceOperation rightOperation, DecisionManager decisionManager, boolean meAdding) {
        super(conflictBucket, (AbstractOperation)leftOperation, (AbstractOperation)rightOperation, decisionManager, meAdding, false);
        this.init();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (this.containmentConflict) {
            description.setDescription(DecisionUtil.getDescription("multireferenceconflict.containment", this.getDecisionManager().isBranchMerge()));
        } else if (this.isLeftMy()) {
            description.setDescription(DecisionUtil.getDescription("multireferenceconflict.my", this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription("multireferenceconflict.their", this.getDecisionManager().isBranchMerge()));
        }
        description.add("target", this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
        description.add("othercontainer", this.getTheirOperation(MultiReferenceOperation.class).getModelElementId());
        description.setImage("multiref.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        EObject target = this.getDecisionManager().getModelElement((ModelElementId)this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
        if (this.containmentConflict) {
            myOption.setOptionLabel(MessageFormat.format(Messages.MultiReferenceConflict_MoveTo, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId()))));
            theirOption.setOptionLabel(MessageFormat.format(Messages.MultiReferenceConflict_MoveTo, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId()))));
        } else {
            myOption.setOptionLabel(this.isLeftMy() ? Messages.MultiReferenceConflict_Add : String.valueOf(Messages.MultiReferenceConflict_Remove) + " " + DecisionUtil.getClassAndName(target));
            theirOption.setOptionLabel(!this.isLeftMy() ? Messages.MultiReferenceConflict_Add : String.valueOf(Messages.MultiReferenceConflict_Remove) + " " + DecisionUtil.getClassAndName(target));
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

