/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntIntMap;
import org.eclipse.collections.api.map.primitive.IntIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntIntMaps;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntIntSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyIntIterate;

final class ImmutableIntIntEmptyMap
implements ImmutableIntIntMap,
Serializable {
    static final ImmutableIntIntMap INSTANCE = new ImmutableIntIntEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    ImmutableIntIntEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public int get(int key) {
        return 0;
    }

    @Override
    public int getIfAbsent(int key, int ifAbsent) {
        return ifAbsent;
    }

    @Override
    public int getOrThrow(int key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(int key) {
        return false;
    }

    @Override
    public boolean containsValue(int value) {
        return false;
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
    }

    @Override
    public void forEachKeyValue(IntIntProcedure procedure) {
    }

    @Override
    public LazyIntIterable keysView() {
        return LazyIntIterate.empty();
    }

    @Override
    public RichIterable<IntIntPair> keyValuesView() {
        return LazyIterate.empty();
    }

    @Override
    public ImmutableIntIntMap flipUniqueValues() {
        return IntIntMaps.immutable.empty();
    }

    @Override
    public ImmutableIntIntMap select(IntIntPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableIntIntMap reject(IntIntPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableIntIntMap toImmutable() {
        return this;
    }

    @Override
    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    @Override
    public void forEach(IntProcedure procedure) {
    }

    @Override
    public void each(IntProcedure procedure) {
    }

    @Override
    public int count(IntPredicate predicate) {
        return 0;
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public int min() {
        throw new NoSuchElementException();
    }

    @Override
    public int max() {
        throw new NoSuchElementException();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public int[] toSortedArray() {
        return new int[0];
    }

    @Override
    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public ImmutableIntBag select(IntPredicate predicate) {
        return IntBags.immutable.empty();
    }

    @Override
    public ImmutableIntBag reject(IntPredicate predicate) {
        return IntBags.immutable.empty();
    }

    @Override
    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public RichIterable<IntIterable> chunk(int size) {
        return Lists.immutable.empty();
    }

    @Override
    public int[] toArray() {
        return new int[0];
    }

    @Override
    public boolean contains(int value) {
        return false;
    }

    @Override
    public boolean containsAll(int ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableIntList toList() {
        return new IntArrayList();
    }

    @Override
    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    @Override
    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableIntIntMap newWithKeyValue(int key, int value) {
        return new ImmutableIntIntSingletonMap(key, value);
    }

    @Override
    public ImmutableIntIntMap newWithoutKey(int key) {
        return this;
    }

    @Override
    public ImmutableIntIntMap newWithoutAllKeys(IntIterable keys) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(new IntHashSet());
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(new IntArrayList());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntIntMap)) {
            return false;
        }
        IntIntMap map = (IntIntMap)obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "{}";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

